/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.items.AbstractItemStructurize;
import com.ldtteam.structurize.util.LanguageHandler;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemCaliper
extends AbstractItemStructurize {
    private static final RangedAttribute ATTRIBUTE_CALIPER_USE = new RangedAttribute(null, "player.caliperUse", 0.0, 0.0, 1.0);
    private static final double HALF = 0.5;
    private static final String ITEM_CALIPER_MESSAGE_SAME = "item.caliper.message.same";
    private static final String ITEM_CALIPER_MESSAGE_BASE = "item.caliper.message.base";
    private static final String ITEM_CALIPER_MESSAGE_BY = "item.caliper.message.by";
    private static final String ITEM_CALIPER_MESSAGE_XD = "item.caliper.message.%sd";
    private BlockPos startPosition;

    public ItemCaliper(Item.Properties properties) {
        super("caliper", properties.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (worldIn.field_72995_K) {
            return ActionResultType.FAIL;
        }
        IAttributeInstance attribute = player.func_110148_a((IAttribute)ATTRIBUTE_CALIPER_USE);
        if (attribute == null) {
            attribute = player.func_110140_aT().func_111150_b((IAttribute)ATTRIBUTE_CALIPER_USE);
        }
        if (attribute.func_111126_e() < 0.5) {
            this.startPosition = pos;
            attribute.func_111128_a(1.0);
            return ActionResultType.SUCCESS;
        }
        attribute.func_111128_a(0.0);
        if (this.startPosition.func_177958_n() == pos.func_177958_n() && this.startPosition.func_177956_o() == pos.func_177956_o() && this.startPosition.func_177952_p() == pos.func_177952_p()) {
            LanguageHandler.sendPlayerMessage(player, ITEM_CALIPER_MESSAGE_SAME, new Object[0]);
            return ActionResultType.FAIL;
        }
        return this.handlePlayerMessage(player, pos);
    }

    private ActionResultType handlePlayerMessage(@NotNull PlayerEntity playerIn, @NotNull BlockPos pos) {
        int disX = Math.abs(pos.func_177958_n() - this.startPosition.func_177958_n());
        int disY = Math.abs(pos.func_177956_o() - this.startPosition.func_177956_o());
        int disZ = Math.abs(pos.func_177952_p() - this.startPosition.func_177952_p());
        int flag = 3;
        if (this.startPosition.func_177958_n() == pos.func_177958_n()) {
            --flag;
        }
        if (this.startPosition.func_177956_o() == pos.func_177956_o()) {
            --flag;
        }
        if (this.startPosition.func_177952_p() == pos.func_177952_p()) {
            --flag;
        }
        String by = " " + LanguageHandler.format(ITEM_CALIPER_MESSAGE_BY, new Object[0]) + " ";
        StringBuilder msg = new StringBuilder();
        if (disX != 0) {
            msg.append(++disX);
            msg.append(by);
        }
        if (disY != 0) {
            msg.append(++disY);
            msg.append(by);
        }
        if (disZ != 0) {
            msg.append(++disZ);
            msg.append(by);
        }
        msg.delete(msg.length() - by.length(), msg.length());
        msg = new StringBuilder(LanguageHandler.format(ITEM_CALIPER_MESSAGE_BASE, msg.toString()));
        msg.append(" ");
        msg.append(LanguageHandler.format(String.format(ITEM_CALIPER_MESSAGE_XD, flag), new Object[0]));
        LanguageHandler.sendPlayerMessage(playerIn, msg.toString(), new Object[0]);
        return ActionResultType.SUCCESS;
    }
}

