/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.tileentities.TileEntityMultiBlock;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class MultiBlockChangeMessage
implements IMessage {
    private Direction direction;
    private Direction output;
    private int range;
    private int speed;
    private BlockPos pos;

    public MultiBlockChangeMessage() {
    }

    public MultiBlockChangeMessage(BlockPos pos, Direction facing, Direction output, int range, int speed) {
        this.pos = pos;
        this.direction = facing;
        this.range = range;
        this.output = output;
        this.speed = speed;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.direction.ordinal());
        buf.writeInt(this.output.ordinal());
        buf.writeInt(this.range);
        buf.writeInt(this.speed);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.direction = Direction.values()[buf.readInt()];
        this.output = Direction.values()[buf.readInt()];
        this.range = buf.readInt();
        this.speed = buf.readInt();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerWorld world = ctxIn.getSender().func_71121_q();
        TileEntity entity = world.func_175625_s(this.pos);
        if (entity instanceof TileEntityMultiBlock) {
            ((TileEntityMultiBlock)entity).setDirection(this.direction);
            ((TileEntityMultiBlock)entity).setOutput(this.output);
            ((TileEntityMultiBlock)entity).setRange(this.range);
            ((TileEntityMultiBlock)entity).setSpeed(this.speed);
            BlockState state = world.func_180495_p(this.pos);
            world.func_184138_a(this.pos, state, state, 3);
        }
    }
}

