/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.StructureUtils;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchematicSaveMessage
implements IMessage {
    private byte[] data = null;
    private int pieces;
    private int piece;
    private UUID id;

    public SchematicSaveMessage() {
    }

    public SchematicSaveMessage(byte[] data, UUID id, int pieces, int piece) {
        this.data = (byte[])data.clone();
        this.id = id;
        this.pieces = pieces;
        this.piece = piece;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        int length = buf.readInt();
        byte[] compressedData = new byte[length];
        buf.readBytes(compressedData);
        this.data = StructureUtils.uncompress(compressedData);
        this.pieces = buf.readInt();
        this.piece = buf.readInt();
        this.id = buf.func_179253_g();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        byte[] compressedData = StructureUtils.compress(this.data);
        if (compressedData != null) {
            buf.capacity(compressedData.length + buf.writerIndex());
            buf.writeInt(compressedData.length);
            buf.writeBytes(compressedData);
            buf.writeInt(this.pieces);
            buf.writeInt(this.piece);
            buf.func_179252_a(this.id);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            boolean schematicSent;
            if (!((Boolean)Structurize.getConfig().getCommon().allowPlayerSchematics.get()).booleanValue()) {
                Log.getLogger().info("SchematicSaveMessage: custom schematic is not allowed on this server.");
                ctxIn.getSender().func_145747_a((ITextComponent)new StringTextComponent("The server does not allow custom schematic!"));
                return;
            }
            if (this.pieces > 20) {
                Log.getLogger().error("Schematic has more than {} pieces, discarding.", (Object)20);
                ctxIn.getSender().func_145747_a((ITextComponent)new StringTextComponent("Schematic has more than 20 pieces, that's too big!"));
                return;
            }
            if (this.data == null) {
                Log.getLogger().error("Received empty schematic file");
                schematicSent = false;
            } else {
                schematicSent = Structures.handleSaveSchematicMessage(this.data, this.id, this.pieces, this.piece);
            }
            if (schematicSent) {
                ctxIn.getSender().func_145747_a((ITextComponent)new StringTextComponent("Schematic successfully sent!"));
            } else {
                ctxIn.getSender().func_145747_a((ITextComponent)new StringTextComponent("Failed to send the Schematic!"));
            }
        } else if (this.data == null) {
            Log.getLogger().error("Received empty schematic file");
        } else {
            Structures.handleSaveSchematicMessage(this.data);
        }
    }
}

