/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.BlueprintIterator;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class StructurePlacer {
    protected final BlueprintIterator iterator;
    protected final IStructureHandler handler;

    public StructurePlacer(IStructureHandler handler) {
        this.iterator = new BlueprintIterator(handler);
        this.handler = handler;
    }

    public StructurePhasePlacementResult executeStructureStep(World world, ChangeStorage storage, BlockPos inputPos, Operation operation, Supplier<BlueprintIterator.Result> iterateFunction, boolean includeEntities) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        if (includeEntities) {
            this.iterator.includeEntities();
        }
        this.iterator.setProgressPos(new BlockPos(inputPos.func_177958_n(), inputPos.func_177956_o(), inputPos.func_177952_p()));
        BlueprintIterator.Result iterationResult = iterateFunction.get();
        BlockPos lastPos = inputPos;
        int count = 0;
        while (iterationResult == BlueprintIterator.Result.NEW_BLOCK) {
            BlockPlacementResult result;
            BlockPos localPos = this.iterator.getProgressPos();
            BlockPos worldPos = this.handler.getProgressPosInWorld(localPos);
            if (count >= this.handler.getStepsPerCall()) {
                return new StructurePhasePlacementResult(lastPos, new BlockPlacementResult(worldPos, BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
            }
            BlockState localState = this.handler.getBluePrint().getBlockState(localPos);
            if (localState == null) continue;
            if (storage != null) {
                storage.addPositionStorage(worldPos, world);
            }
            switch (operation) {
                case BLOCK_REMOVAL: {
                    if (!this.handler.isCreative() && !(world.func_180495_p(worldPos).func_177230_c() instanceof AirBlock)) {
                        result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
                        break;
                    }
                    world.func_217377_a(worldPos, false);
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case WATER_REMOVAL: {
                    BlockState worldState = world.func_180495_p(worldPos);
                    if (worldState.func_177230_c() instanceof IBucketPickupHandler || worldState.func_177230_c() instanceof FlowingFluidBlock || !worldState.func_204520_s().func_206888_e()) {
                        BlockUtils.removeFluid(world, worldPos);
                    }
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case GET_RES_REQUIREMENTS: {
                    result = this.getResourceRequirements(world, worldPos, localPos, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                    requiredItems.addAll(result.getRequiredItems());
                    break;
                }
                default: {
                    result = this.handleBlockPlacement(world, worldPos, localPos, storage, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                }
            }
            ++count;
            if (operation != Operation.GET_RES_REQUIREMENTS && (result.getResult() == BlockPlacementResult.Result.MISSING_ITEMS || result.getResult() == BlockPlacementResult.Result.FAIL || result.getResult() == BlockPlacementResult.Result.BREAK_BLOCK)) {
                return new StructurePhasePlacementResult(lastPos, result);
            }
            lastPos = localPos;
            iterationResult = iterateFunction.get();
        }
        if (iterationResult == BlueprintIterator.Result.AT_END) {
            this.iterator.reset();
            return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.iterator.getProgressPos(), BlockPlacementResult.Result.FINISHED, requiredItems));
        }
        return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.handler.getProgressPosInWorld(this.iterator.getProgressPos()), BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
    }

    public BlockPlacementResult handleBlockPlacement(World world, BlockPos worldPos, BlockPos localPos, ChangeStorage storage, BlockState localState, CompoundNBT tileEntityData) {
        BlockState worldState = world.func_180495_p(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.func_177230_c() == localState.func_177230_c()) {
            sameBlockInWorld = true;
        }
        if (!(worldState.func_177230_c() instanceof AirBlock) && !this.handler.allowReplace()) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
        }
        for (CompoundNBT compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().func_177973_b((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.func_220347_a((CompoundNBT)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).func_200721_a(world)) == null) continue;
                entity.deserializeNBT(compound);
                ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
                if (!this.handler.isCreative()) {
                    requiredItems.addAll(ItemStackUtils.getListOfStackForEntity(entity, pos));
                    if (!InventoryUtils.hasRequiredItems(this.handler.getInventory(), requiredItems)) {
                        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                    }
                }
                entity.func_184221_a(UUID.randomUUID());
                Vec3d posInWorld = entity.func_174791_d().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                entity.func_70107_b(posInWorld.field_72450_a, posInWorld.field_72448_b, posInWorld.field_72449_c);
                List list = world.func_217357_a(entity.getClass(), new AxisAlignedBB(posInWorld.func_72441_c(1.0, 1.0, 1.0), posInWorld.func_72441_c(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.func_174791_d().equals((Object)entity.func_174791_d())) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity) continue;
                world.func_217376_c(entity);
                if (storage != null) {
                    storage.addToBeKilledEntity(entity);
                }
                for (ItemStack tempStack : requiredItems) {
                    if (ItemStackUtils.isEmpty(tempStack).booleanValue()) continue;
                    InventoryUtils.consumeStack(tempStack, this.handler.getInventory());
                }
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        if (localState.func_177230_c() == ModBlocks.blockSolidSubstitution && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
            if (!sameBlockInWorld && !this.handler.isCreative()) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.func_190926_b() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
                if (!this.handler.hasRequiredItems(requiredItems)) {
                    return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                }
            }
            if (!(worldState.func_177230_c() instanceof AirBlock || sameBlockInWorld || worldState.func_185904_a() == Material.field_151579_a || worldState.func_177230_c() instanceof DoublePlantBlock && ((DoubleBlockHalf)worldState.func_177229_b((IProperty)DoublePlantBlock.field_176492_b)).equals((Object)DoubleBlockHalf.UPPER))) {
                if (!this.handler.isCreative()) {
                    List<ItemStack> items = BlockUtils.getBlockDrops(world, worldPos, 0, this.handler.getHeldItem());
                    for (ItemStack item : items) {
                        InventoryUtils.transferIntoNextBestSlot(item, this.handler.getInventory());
                    }
                } else if (world.func_175625_s(worldPos) != null) {
                    world.func_175713_t(worldPos);
                }
                world.func_217377_a(worldPos, false);
            }
            this.handler.prePlacementLogic(worldPos, localState);
            IPlacementHandler.ActionProcessingResult result = placementHandler.handle(world, worldPos, localState, tileEntityData, !this.handler.fancyPlacement(), this.handler.getWorldPos(), this.handler.getSettings());
            if (result == IPlacementHandler.ActionProcessingResult.DENY) {
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
            }
            this.handler.triggerSuccess(localPos, requiredItems, true);
            if (result == IPlacementHandler.ActionProcessingResult.PASS) {
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
            }
            if (!this.handler.isCreative() && !sameBlockInWorld) {
                for (ItemStack tempStack : requiredItems) {
                    if (ItemStackUtils.isEmpty(tempStack).booleanValue()) continue;
                    InventoryUtils.consumeStack(tempStack, this.handler.getInventory());
                }
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
    }

    public BlockPlacementResult getResourceRequirements(World world, BlockPos worldPos, BlockPos localPos, BlockState localState, CompoundNBT tileEntityData) {
        BlockState worldState = world.func_180495_p(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.func_177230_c() == localState.func_177230_c()) {
            sameBlockInWorld = true;
        }
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        for (CompoundNBT compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().func_177973_b((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.func_220347_a((CompoundNBT)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).func_200721_a(world)) == null) continue;
                entity.deserializeNBT(compound);
                Vec3d posInWorld = entity.func_174791_d().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                List list = world.func_217357_a(entity.getClass(), new AxisAlignedBB(posInWorld.func_72441_c(1.0, 1.0, 1.0), posInWorld.func_72441_c(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.func_174791_d().equals((Object)entity.func_174791_d())) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity) continue;
                requiredItems.addAll(ItemStackUtils.getListOfStackForEntity(entity, pos));
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        if (localState.func_177230_c() == ModBlocks.blockSolidSubstitution && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            if (!sameBlockInWorld) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.func_190926_b() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
    }

    public boolean checkForFreeSpace(@NotNull BlockPos pos) {
        this.iterator.setProgressPos(pos);
        while (this.iterator.increment() == BlueprintIterator.Result.NEW_BLOCK) {
            BlockPos localPos = this.iterator.getProgressPos();
            BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
            if (worldPos.func_177956_o() <= pos.func_177956_o() && !this.handler.getWorld().func_180495_p(worldPos.func_177977_b()).func_185904_a().func_76220_a()) {
                this.iterator.reset();
                return false;
            }
            BlockState worldState = this.handler.getWorld().func_180495_p(worldPos);
            if (worldState.func_177230_c() == Blocks.field_150357_h) {
                this.iterator.reset();
                return false;
            }
            if (worldPos.func_177956_o() <= pos.func_177956_o() || worldState.func_177230_c() == Blocks.field_150350_a) continue;
            this.iterator.reset();
            return false;
        }
        this.iterator.reset();
        return true;
    }

    public BlueprintIterator getIterator() {
        return this.iterator;
    }

    public static enum Operation {
        WATER_REMOVAL,
        BLOCK_REMOVAL,
        BLOCK_PLACEMENT,
        GET_RES_REQUIREMENTS;

    }
}

