/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStructureHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void loadBlueprint(String structureName) {
        InputStream inputStream;
        String correctStructureName;
        block7: {
            correctStructureName = structureName;
            inputStream = null;
            try {
                if (Structures.hasMD5(correctStructureName) && (inputStream = StructureLoadingUtils.getStream("cache/" + Structures.getMD5(correctStructureName))) != null) {
                    correctStructureName = "cache/" + Structures.getMD5(correctStructureName);
                }
                if (inputStream == null) {
                    inputStream = StructureLoadingUtils.getStream(correctStructureName);
                }
                if (inputStream != null) break block7;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return;
        }
        try {
            this.setMd5(StructureUtils.calculateMD5(StructureLoadingUtils.getStream(correctStructureName)));
            CompoundNBT CompoundNBT2 = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            this.setBlueprint(BlueprintUtil.readBlueprintFromNBT(CompoundNBT2));
        }
        catch (IOException e) {
            Log.getLogger().warn(String.format("Failed to load blueprint %s", correctStructureName), (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void setBlueprint(Blueprint var1);

    public void setMd5(String var1);

    public String getMd5();

    default public boolean isCorrectMD5(String otherMD5) {
        Log.getLogger().info("isCorrectMD5: md5:" + this.getMd5() + " other:" + otherMD5);
        if (this.getMd5() == null || otherMD5 == null) {
            return false;
        }
        return this.getMd5().compareTo(otherMD5) == 0;
    }

    public Blueprint getBluePrint();

    public World getWorld();

    public BlockPos getWorldPos();

    public PlacementSettings getSettings();

    @Nullable
    public IItemHandler getInventory();

    public void triggerSuccess(BlockPos var1, List<ItemStack> var2, boolean var3);

    public boolean isCreative();

    public boolean hasBluePrint();

    public int getStepsPerCall();

    public int getMaxBlocksCheckedPerCall();

    public boolean isStackFree(@Nullable ItemStack var1);

    public boolean allowReplace();

    public ItemStack getHeldItem();

    public boolean replaceWithSolidBlock(BlockState var1);

    public boolean fancyPlacement();

    public boolean shouldBlocksBeConsideredEqual(BlockState var1, BlockState var2);

    public boolean hasRequiredItems(@NotNull List<ItemStack> var1);

    default public BlockPos getProgressPosInWorld(BlockPos localPos) {
        return this.getWorldPos().func_177973_b((Vec3i)this.getBluePrint().getPrimaryBlockOffset()).func_177971_a((Vec3i)localPos);
    }

    public void prePlacementLogic(BlockPos var1, BlockState var2);

    public BlockState getSolidBlockForPos(BlockPos var1);
}

