/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageHandler {
    private LanguageHandler() {
    }

    public static void sendPlayerMessage(@NotNull PlayerEntity player, String key, Object ... message) {
        player.func_145747_a(LanguageHandler.buildChatComponent(key.toLowerCase(Locale.US), message));
    }

    public static ITextComponent buildChatComponent(String key, Object ... message) {
        TranslationTextComponent translation = null;
        int onlyArgsUntil = 0;
        for (Object object : message) {
            if (object instanceof ITextComponent) {
                if (onlyArgsUntil != 0) break;
                onlyArgsUntil = -1;
                break;
            }
            ++onlyArgsUntil;
        }
        if (onlyArgsUntil >= 0) {
            Object[] args = new Object[onlyArgsUntil];
            System.arraycopy(message, 0, args, 0, onlyArgsUntil);
            translation = new TranslationTextComponent(key, args);
        }
        for (Object object : message) {
            if (translation == null) {
                if (object instanceof ITextComponent) {
                    translation = new TranslationTextComponent(key, new Object[0]);
                } else {
                    translation = new TranslationTextComponent(key, new Object[]{object});
                    continue;
                }
            }
            if (object instanceof ITextComponent) {
                translation.func_150257_a((ITextComponent)new StringTextComponent(" "));
                translation.func_150257_a((ITextComponent)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            boolean isInArgs = false;
            for (Object obj : translation.func_150271_j()) {
                if (!obj.equals(object)) continue;
                isInArgs = true;
                break;
            }
            if (isInArgs) continue;
            translation.func_150258_a(" " + object);
        }
        if (translation == null) {
            translation = new TranslationTextComponent(key, new Object[0]);
        }
        return translation;
    }

    public static String format(String inputKey, Object ... args) {
        String key = inputKey.toLowerCase(Locale.US);
        String result = args.length == 0 ? new TranslationTextComponent(key, new Object[0]).func_150261_e() : new TranslationTextComponent(key, args).func_150261_e();
        return result.isEmpty() ? key : result;
    }

    public static void sendPlayersMessage(@Nullable List<PlayerEntity> players, String key, Object ... message) {
        if (players == null || players.isEmpty()) {
            return;
        }
        ITextComponent textComponent = LanguageHandler.buildChatComponent(key.toLowerCase(Locale.US), message);
        for (PlayerEntity player : players) {
            player.func_145747_a(textComponent);
        }
    }

    public static void sendMessageToPlayer(PlayerEntity player, String key, Object ... format) {
        player.func_145747_a((ITextComponent)new StringTextComponent(LanguageHandler.translateKeyWithFormat(key, format)));
    }

    public static String translateKeyWithFormat(String key, Object ... format) {
        return String.format(LanguageHandler.translateKey(key.toLowerCase(Locale.US)), format);
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key.toLowerCase(Locale.US));
    }

    public static void setMClanguageLoaded() {
        LanguageCache.getInstance().isMCloaded = true;
        LanguageCache.getInstance().languageMap = null;
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static LanguageCache instance;
        private boolean isMCloaded = false;
        private Map<String, String> languageMap;

        private LanguageCache() {
            String fileLoc = "assets/structurize/lang/%s.json";
            this.load("assets/structurize/lang/%s.json");
        }

        private void load(String path) {
            InputStream is;
            String defaultLocale = "en_us";
            String locale = (String)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x() == null ? null : Minecraft.func_71410_x().field_71474_y.field_74363_ab);
            if (locale == null) {
                locale = "en_us";
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale))) == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, "en_us"));
            }
            this.languageMap = (Map)new Gson().fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
        }

        private static LanguageCache getInstance() {
            return instance == null ? (instance = new LanguageCache()) : instance;
        }

        private String translateKey(String key) {
            if (this.isMCloaded) {
                return LanguageMap.func_74808_a().func_74805_b(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? key : res;
        }
    }
}

