/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Image;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextProperties;

public class ButtonImage
extends Button {
    private static final int DEFAULT_BUTTON_SIZE = 20;
    private static final float HALF = 0.5f;
    protected ResourceLocation image;
    protected ResourceLocation imageHighlight;
    protected ResourceLocation imageDisabled;
    protected int imageOffsetX = 0;
    protected int imageOffsetY = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int imageMapWidth = 256;
    protected int imageMapHeight = 256;
    protected int highlightOffsetX = 0;
    protected int highlightOffsetY = 0;
    protected int highlightWidth = 0;
    protected int highlightHeight = 0;
    protected int highlightMapWidth = 256;
    protected int highlightMapHeight = 256;
    protected int disabledOffsetX = 0;
    protected int disabledOffsetY = 0;
    protected int disabledWidth = 0;
    protected int disabledHeight = 0;
    protected int disabledMapWidth = 256;
    protected int disabledMapHeight = 256;
    protected double textScale = 1.0;
    protected Alignment textAlignment = Alignment.MIDDLE;
    protected int textColor = 0xFFFFFF;
    protected int textHoverColor = 0xFFFFFF;
    protected int textDisabledColor = 0xFFFFFF;
    protected boolean shadow = false;
    protected int textOffsetX = 0;
    protected int textOffsetY = 0;

    public ButtonImage() {
        this.width = 20;
        this.height = 20;
    }

    public ButtonImage(PaneParams params) {
        super(params);
        this.loadImageInfo(params);
        this.loadHighlightInfo(params);
        this.loadDisabledInfo(params);
        this.loadTextInfo(params);
    }

    private void loadImageInfo(PaneParams params) {
        PaneParams.SizePair size;
        String path = params.getStringAttribute("source", null);
        if (path != null) {
            this.image = new ResourceLocation(path);
            this.loadImageDimensions();
        }
        if ((size = params.getSizePairAttribute("imageoffset", null, null)) != null) {
            this.imageOffsetX = size.getX();
            this.imageOffsetY = size.getY();
        }
        if ((size = params.getSizePairAttribute("imagesize", null, null)) != null) {
            this.imageWidth = size.getX();
            this.imageHeight = size.getY();
        }
    }

    private void loadHighlightInfo(PaneParams params) {
        PaneParams.SizePair size;
        String path = params.getStringAttribute("highlight", null);
        if (path != null) {
            this.imageHighlight = new ResourceLocation(path);
            this.loadImageHighlightDimensions();
        }
        if ((size = params.getSizePairAttribute("highlightoffset", null, null)) != null) {
            this.highlightOffsetX = size.getX();
            this.highlightOffsetY = size.getY();
        }
        if ((size = params.getSizePairAttribute("highlightsize", null, null)) != null) {
            this.highlightWidth = size.getX();
            this.highlightHeight = size.getY();
        }
    }

    private void loadDisabledInfo(PaneParams params) {
        PaneParams.SizePair size;
        String path = params.getStringAttribute("disabled", null);
        if (path != null) {
            this.imageDisabled = new ResourceLocation(path);
            this.loadImageDisabledDimensions();
        }
        if ((size = params.getSizePairAttribute("disabledoffset", null, null)) != null) {
            this.disabledOffsetX = size.getX();
            this.disabledOffsetY = size.getY();
        }
        if ((size = params.getSizePairAttribute("disabledsize", null, null)) != null) {
            this.disabledWidth = size.getX();
            this.disabledHeight = size.getY();
        }
    }

    private void loadTextInfo(PaneParams params) {
        this.textScale = params.getDoubleAttribute("textscale", this.textScale);
        this.textAlignment = params.getEnumAttribute("textalign", Alignment.class, this.textAlignment);
        this.textColor = params.getColorAttribute("textcolor", this.textColor);
        this.textHoverColor = params.getColorAttribute("texthovercolor", this.textColor);
        this.textDisabledColor = params.getColorAttribute("textdisabledcolor", this.textColor);
        this.shadow = params.getBooleanAttribute("shadow", this.shadow);
        PaneParams.SizePair size = params.getSizePairAttribute("textoffset", null, null);
        if (size != null) {
            this.textOffsetX = size.getX();
            this.textOffsetY = size.getY();
        }
    }

    private void loadImageDimensions() {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(this.image);
        this.imageMapWidth = (Integer)dimensions.func_76341_a();
        this.imageMapHeight = (Integer)dimensions.func_76340_b();
    }

    private void loadImageHighlightDimensions() {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(this.imageHighlight);
        this.highlightMapWidth = (Integer)dimensions.func_76341_a();
        this.highlightMapHeight = (Integer)dimensions.func_76340_b();
    }

    private void loadImageDisabledDimensions() {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(this.imageDisabled);
        this.disabledMapWidth = (Integer)dimensions.func_76341_a();
        this.disabledMapHeight = (Integer)dimensions.func_76340_b();
    }

    public void setImage(String source) {
        this.setImage(source, 0, 0, 0, 0);
    }

    public void setImage(String source, int offsetX, int offsetY, int w, int h) {
        this.setImage(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.image = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageHeight = w;
        this.imageWidth = h;
        this.loadImageDimensions();
    }

    public void setImage(ResourceLocation loc) {
        this.setImage(loc, 0, 0, 0, 0);
    }

    public void setImageHighlight(String source) {
        this.setImageHighlight(source, 0, 0, 0, 0);
    }

    public void setImageHighlight(String source, int offsetX, int offsetY, int w, int h) {
        this.setImageHighlight(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImageHighlight(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.imageHighlight = loc;
        this.highlightOffsetX = offsetX;
        this.highlightOffsetY = offsetY;
        this.highlightHeight = w;
        this.highlightWidth = h;
        this.loadImageHighlightDimensions();
    }

    public void setImageHighlight(ResourceLocation loc) {
        this.setImageHighlight(loc, 0, 0, 0, 0);
    }

    public void setImageDisabled(String source) {
        this.setImageHighlight(source, 0, 0, 0, 0);
    }

    public void setImageDisabled(String source, int offsetX, int offsetY, int w, int h) {
        this.setImageHighlight(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImageDisabled(ResourceLocation loc) {
        this.setImageHighlight(loc, 0, 0, 0, 0);
    }

    public void setImageDisabled(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.imageDisabled = loc;
        this.disabledOffsetX = offsetX;
        this.disabledOffsetY = offsetY;
        this.disabledHeight = w;
        this.disabledWidth = h;
        this.loadImageDisabledDimensions();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int c) {
        this.setTextColor(c, c, c);
    }

    public void setTextColor(int c, int d, int h) {
        this.textColor = c;
        this.textDisabledColor = d;
        this.textHoverColor = h;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public int getTextDisabledColor() {
        return this.textDisabledColor;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public void setShadow(boolean s) {
        this.shadow = s;
    }

    public Alignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(Alignment align) {
        this.textAlignment = align;
    }

    public double getTextScale() {
        return this.textScale;
    }

    public void setTextScale(double s) {
        this.textScale = s;
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        boolean mouseOver = this.isPointInPane(mx, my);
        this.drawImage(ms, mouseOver);
        this.drawlabel(ms, mouseOver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawImage(MatrixStack ms, boolean mouseOver) {
        ResourceLocation bind = this.image;
        int u = this.imageOffsetX;
        int v = this.imageOffsetY;
        int w = this.imageWidth;
        int h = this.imageHeight;
        int mapWidth = this.imageMapWidth;
        int mapHeight = this.imageMapHeight;
        if (!this.enabled) {
            if (this.imageDisabled == null) return;
            bind = this.imageDisabled;
            u = this.disabledOffsetX;
            v = this.disabledOffsetY;
            w = this.disabledWidth;
            h = this.disabledHeight;
            mapWidth = this.disabledMapWidth;
            mapHeight = this.disabledMapHeight;
        } else if (mouseOver && this.imageHighlight != null) {
            bind = this.imageHighlight;
            u = this.highlightOffsetX;
            v = this.highlightOffsetY;
            w = this.highlightWidth;
            h = this.highlightHeight;
            mapWidth = this.highlightMapWidth;
            mapHeight = this.highlightMapHeight;
        }
        if (w == 0 || w > this.getWidth()) {
            w = this.getWidth();
        }
        if (h == 0 || h > this.getHeight()) {
            h = this.getHeight();
        }
        this.mc.func_110434_K().func_110577_a(bind);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.enabled || this.imageDisabled != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ButtonImage.func_238463_a_((MatrixStack)ms, (int)this.x, (int)this.y, (float)u, (float)v, (int)w, (int)h, (int)mapWidth, (int)mapHeight);
        } else {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            ButtonImage.func_238463_a_((MatrixStack)ms, (int)this.x, (int)this.y, (float)u, (float)v, (int)w, (int)h, (int)mapWidth, (int)mapHeight);
        }
        RenderSystem.disableBlend();
    }

    private void drawlabel(MatrixStack ms, boolean mouseOver) {
        if (this.label != null) {
            int color = this.enabled ? (mouseOver ? this.textHoverColor : this.textColor) : this.textDisabledColor;
            int offsetX = this.textOffsetX;
            int offsetY = this.textOffsetY;
            if (this.textAlignment.isRightAligned()) {
                offsetX += this.getWidth() - this.getStringWidth();
            } else if (this.textAlignment.isHorizontalCentered()) {
                offsetX += (this.getWidth() - this.getStringWidth()) / 2;
            }
            if (this.textAlignment.isBottomAligned()) {
                offsetY += this.getHeight() - this.getTextHeight();
            } else if (this.textAlignment.isVerticalCentered()) {
                offsetY += (this.getHeight() - this.getTextHeight()) / 2;
            }
            ms.func_227860_a_();
            ms.func_227862_a_((float)this.textScale, (float)this.textScale, 1.0f);
            this.drawString(ms, (ITextProperties)this.label, (float)(this.getX() + offsetX), (float)(this.getY() + offsetY), color, this.shadow);
            ms.func_227865_b_();
        }
    }

    public int getStringWidth() {
        return (int)((double)this.mc.field_71466_p.func_238414_a_((ITextProperties)this.label) * this.textScale);
    }

    public int getTextHeight() {
        this.mc.field_71466_p.getClass();
        return (int)(9.0 * this.textScale);
    }
}

