/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.AbstractTextElement;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class Text
extends AbstractTextElement {
    protected String textContent;
    protected List<ITextProperties> formattedText;
    protected int textHeight;
    protected int linespace = 0;

    public Text() {
    }

    public Text(PaneParams params) {
        super(params);
        this.textContent = params.getLocalizedText();
        this.linespace = params.getIntAttribute("linespace", this.linespace);
    }

    @Override
    public void setScale(float s) {
        super.setScale(s);
        this.formattedText = null;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String s) {
        this.textContent = s;
        this.formattedText = null;
    }

    public int getLineSpace() {
        return this.linespace;
    }

    public void setLineSpace(int l) {
        this.linespace = l;
    }

    public int getLineHeight() {
        this.mc.field_71466_p.getClass();
        return (int)(9.0 * this.scale);
    }

    public int getTextHeight() {
        this.getFormattedText();
        return this.textHeight;
    }

    public int getStringWidth(ITextProperties s) {
        return (int)((double)this.mc.field_71466_p.func_238414_a_(s) * this.scale);
    }

    public List<ITextProperties> getFormattedText() {
        if (this.formattedText == null) {
            this.formattedText = this.textContent == null || this.textContent.length() == 0 ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.mc.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(this.textContent), (int)((double)this.getWidth() / this.scale)).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            int numLines = this.formattedText.size();
            if (numLines > 0) {
                int scaledLinespace = (int)((double)this.linespace * this.scale);
                this.textHeight = numLines * (this.getLineHeight() + scaledLinespace) - scaledLinespace;
            } else {
                this.textHeight = 0;
            }
        }
        return this.formattedText;
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        int scaledLinespace = (int)((double)this.linespace * this.scale);
        int offsetY = 0;
        if (this.textAlignment.isBottomAligned() || this.textAlignment.isVerticalCentered()) {
            int maxVisibleLines = (this.getHeight() + scaledLinespace) / (this.getLineHeight() + scaledLinespace);
            int maxVisibleSize = maxVisibleLines * (this.getLineHeight() + scaledLinespace) - scaledLinespace;
            if (this.getTextHeight() < maxVisibleSize) {
                maxVisibleSize = this.getTextHeight();
            }
            offsetY = Math.max(0, this.getHeight() - maxVisibleSize);
            if (this.textAlignment.isVerticalCentered()) {
                offsetY /= 2;
            }
        }
        for (ITextProperties s : this.getFormattedText()) {
            int offsetX = 0;
            if (this.textAlignment.isRightAligned() || this.textAlignment.isHorizontalCentered()) {
                offsetX = this.getWidth() - this.getStringWidth(s);
                if (this.textAlignment.isHorizontalCentered()) {
                    offsetX /= 2;
                }
            }
            ms.func_227860_a_();
            ms.func_227861_a_((double)(this.getX() + offsetX), (double)(this.getY() + offsetY), 0.0);
            ms.func_227862_a_((float)this.scale, (float)this.scale, (float)this.scale);
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            this.drawString(ms, s, 0.0f, 0.0f, this.textColor, this.shadow);
            ms.func_227865_b_();
            if ((offsetY += this.getLineHeight() + scaledLinespace) + this.getLineHeight() <= this.getHeight()) continue;
            break;
        }
    }
}

