/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class TextField
extends Pane {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private static final int RECT_COLOR = -3092272;
    private static final int DEFAULT_MAX_TEXT_LENGTH = 32;
    protected int maxTextLength = 32;
    protected int textColor = 0xE0E0E0;
    protected int textColorDisabled = 0x707070;
    protected boolean shadow = true;
    @Nullable
    protected String tabNextPaneID = null;
    protected String text = "";
    protected Filter filter;
    protected int cursorPosition = 0;
    protected int scrollOffset = 0;
    protected int selectionEnd = 0;
    protected int cursorBlinkCounter = 0;

    public TextField() {
    }

    public TextField(@NotNull PaneParams params) {
        super(params);
        this.maxTextLength = params.getIntAttribute("maxlength", this.maxTextLength);
        this.textColor = params.getColorAttribute("color", this.textColor);
        this.textColorDisabled = params.getColorAttribute("colordisabled", this.textColorDisabled);
        this.shadow = params.getBooleanAttribute("shadow", this.shadow);
        this.text = params.getLocalizedStringAttribute("textContent", this.text);
        this.tabNextPaneID = params.getStringAttribute("tab", null);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NotNull String s) {
        this.text = s.length() <= this.maxTextLength ? s : s.substring(0, this.maxTextLength);
        this.setCursorPosition(this.text.length());
    }

    public void setTextIgnoreLength(@NotNull String s) {
        this.text = s;
        this.setCursorPosition(this.text.length());
    }

    public int getInternalWidth() {
        return this.getWidth();
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int m) {
        this.maxTextLength = m;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int c) {
        this.textColor = c;
    }

    public int getTextColorDisabled() {
        return this.textColorDisabled;
    }

    public void setTextColorDisabled(int c) {
        this.textColorDisabled = c;
    }

    @Nullable
    public String getTabNextPaneID() {
        return this.tabNextPaneID;
    }

    public void setTabNextPaneID(String nextID) {
        this.tabNextPaneID = nextID;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
        this.setSelectionEnd(this.cursorPosition);
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selectionEnd + offset);
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int pos) {
        this.selectionEnd = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
        int internalWidth = this.getInternalWidth();
        if (internalWidth > 0) {
            if (this.scrollOffset > this.text.length()) {
                this.scrollOffset = this.text.length();
            }
            String visibleString = this.mc.field_71466_p.func_238412_a_(this.text.substring(this.scrollOffset), internalWidth);
            int rightmostVisibleChar = visibleString.length() + this.scrollOffset;
            if (this.selectionEnd == this.scrollOffset) {
                this.scrollOffset -= this.mc.field_71466_p.func_238413_a_(this.text, internalWidth, true).length();
            }
            if (this.selectionEnd > rightmostVisibleChar) {
                this.scrollOffset += this.selectionEnd - rightmostVisibleChar;
            } else if (this.selectionEnd <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - this.selectionEnd;
            }
            this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)this.text.length());
        }
    }

    @NotNull
    public String getSelectedText() {
        int start = Math.min(this.cursorPosition, this.selectionEnd);
        int end = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(start, end);
    }

    private boolean handleKey(char c, int key) {
        switch (key) {
            case 259: 
            case 261: {
                return this.handleDelete(key);
            }
            case 268: 
            case 269: {
                return this.handleHomeEnd(key);
            }
            case 262: 
            case 263: {
                return this.handleArrowKeys(key);
            }
            case 258: {
                return this.handleTab();
            }
        }
        return this.handleChar(c);
    }

    private boolean handleChar(char c) {
        if (this.filter.isAllowedCharacter(c)) {
            this.writeText(Character.toString(c));
            return true;
        }
        return false;
    }

    private boolean handleTab() {
        Pane next;
        if (this.tabNextPaneID != null && (next = this.getWindow().findPaneByID(this.tabNextPaneID)) != null) {
            next.setFocus();
        }
        return true;
    }

    private boolean handleArrowKeys(int key) {
        int direction;
        int n = direction = key == 263 ? -1 : 1;
        if (Screen.func_231173_s_()) {
            if (Screen.func_231172_r_()) {
                this.setSelectionEnd(this.getNthWordFromPos(direction, this.getSelectionEnd()));
            } else {
                this.setSelectionEnd(this.getSelectionEnd() + direction);
            }
        } else if (Screen.func_231172_r_()) {
            this.setCursorPosition(this.getNthWordFromCursor(direction));
        } else {
            this.moveCursorBy(direction);
        }
        return true;
    }

    private boolean handleHomeEnd(int key) {
        int position;
        int n = position = key == 268 ? 0 : this.text.length();
        if (Screen.func_231173_s_()) {
            this.setSelectionEnd(position);
        } else {
            this.setCursorPosition(position);
        }
        return true;
    }

    private boolean handleDelete(int key) {
        int direction;
        int n = direction = key == 259 ? -1 : 1;
        if (Screen.func_231172_r_()) {
            this.deleteWords(direction);
        } else {
            this.deleteFromCursor(direction);
        }
        return true;
    }

    @Override
    public void onFocus() {
        this.setCursorPosition(this.text.length());
        this.cursorBlinkCounter = 0;
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        boolean cursorBeforeEnd;
        int color = this.enabled ? this.textColor : this.textColorDisabled;
        int drawWidth = this.getInternalWidth();
        int drawX = this.x;
        int drawY = this.y;
        String visibleString = this.mc.field_71466_p.func_238412_a_(this.text.substring(this.scrollOffset), drawWidth);
        int relativeCursorPosition = this.cursorPosition - this.scrollOffset;
        int relativeSelectionEnd = this.selectionEnd - this.scrollOffset;
        boolean cursorVisible = relativeCursorPosition >= 0 && relativeCursorPosition <= visibleString.length();
        boolean bl = cursorBeforeEnd = this.cursorPosition < this.text.length() || this.text.length() >= this.maxTextLength;
        if (relativeSelectionEnd > visibleString.length()) {
            relativeSelectionEnd = visibleString.length();
        }
        int textX = drawX;
        if (visibleString.length() > 0) {
            String s1 = cursorVisible ? visibleString.substring(0, relativeCursorPosition) : visibleString;
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            textX = this.drawString(ms, s1, (float)textX, (float)drawY, color, this.shadow);
        }
        int cursorX = textX--;
        if (!cursorVisible) {
            cursorX = relativeCursorPosition > 0 ? drawX + this.width : drawX;
        } else if (cursorBeforeEnd && this.shadow) {
            --cursorX;
        }
        if (visibleString.length() > 0 && cursorVisible && relativeCursorPosition < visibleString.length()) {
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            this.drawString(ms, visibleString.substring(relativeCursorPosition), (float)textX, (float)drawY, color, this.shadow);
        }
        if (this.isFocus() && cursorVisible && this.cursorBlinkCounter / 6 % 2 == 0) {
            if (cursorBeforeEnd) {
                this.mc.field_71466_p.getClass();
                TextField.func_238467_a_((MatrixStack)ms, (int)cursorX, (int)(drawY - 1), (int)(cursorX + 1), (int)(drawY + 1 + 9), (int)-3092272);
            } else {
                this.mc.func_110434_K().func_110577_a(TEXTURE);
                this.drawString(ms, "_", (float)cursorX, (float)drawY, color, this.shadow);
            }
        }
        if (relativeSelectionEnd != relativeCursorPosition) {
            int selectedDrawX = drawX + this.mc.field_71466_p.func_78256_a(visibleString.substring(0, relativeSelectionEnd));
            int selectionStartX = Math.min(cursorX, selectedDrawX - 1);
            int selectionEndX = Math.max(cursorX, selectedDrawX - 1);
            if (selectionStartX > this.x + this.width) {
                selectionStartX = this.x + this.width;
            }
            if (selectionEndX > this.x + this.width) {
                selectionEndX = this.x + this.width;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableColorLogicOp();
            GL11.glLogicOp((int)5387);
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            double d = selectionStartX;
            double d2 = (double)drawY + 1.0;
            this.mc.field_71466_p.getClass();
            vertexBuffer.func_225582_a_(d, d2 + 9.0, 0.0).func_181675_d();
            double d3 = selectionEndX;
            double d4 = (double)drawY + 1.0;
            this.mc.field_71466_p.getClass();
            vertexBuffer.func_225582_a_(d3, d4 + 9.0, 0.0).func_181675_d();
            vertexBuffer.func_225582_a_((double)selectionEndX, (double)drawY - 1.0, 0.0).func_181675_d();
            vertexBuffer.func_225582_a_((double)selectionStartX, (double)drawY - 1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableColorLogicOp();
            RenderSystem.enableTexture();
        }
    }

    @Override
    public void putInside(View view) {
        super.putInside(view);
        this.setSelectionEnd(this.selectionEnd);
    }

    @Override
    public boolean handleClick(double mx, double my) {
        if (mx < 0.0) {
            return false;
        }
        String visibleString = this.mc.field_71466_p.func_238412_a_(this.text.substring(this.scrollOffset), this.getInternalWidth());
        String trimmedString = this.mc.field_71466_p.func_238412_a_(visibleString, (int)mx);
        int oldScrollOffset = this.scrollOffset;
        this.setFocus();
        this.scrollOffset = oldScrollOffset;
        this.setCursorPosition(trimmedString.length() + this.scrollOffset);
        return true;
    }

    @Override
    public boolean onKeyTyped(char c, int key) {
        if (Screen.func_231169_i_((int)key)) {
            this.mc.field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231166_g_((int)key)) {
            this.mc.field_195559_v.func_197960_a(this.getSelectedText());
            this.writeText("");
            return true;
        }
        if (Screen.func_231170_j_((int)key)) {
            this.setCursorPosition(this.text.length());
            this.setSelectionEnd(0);
            return true;
        }
        if (Screen.func_231168_h_((int)key)) {
            this.writeText(this.mc.field_195559_v.func_197965_a());
            return true;
        }
        return this.handleKey(c, key);
    }

    @Override
    public void onUpdate() {
        ++this.cursorBlinkCounter;
    }

    public void writeText(String str) {
        int insertedLength;
        String filteredStr = this.filter.filter(str);
        int insertAt = Math.min(this.cursorPosition, this.selectionEnd);
        int insertEnd = Math.max(this.cursorPosition, this.selectionEnd);
        int availableChars = this.maxTextLength - this.text.length() + (insertEnd - insertAt);
        if (availableChars < 0) {
            return;
        }
        StringBuilder resultBuffer = new StringBuilder();
        if (this.text.length() > 0 && insertAt > 0) {
            resultBuffer.append(this.text.substring(0, insertAt));
        }
        if (availableChars < filteredStr.length()) {
            resultBuffer.append(filteredStr.substring(0, availableChars));
            insertedLength = availableChars;
        } else {
            resultBuffer.append(filteredStr);
            insertedLength = filteredStr.length();
        }
        if (this.text.length() > 0 && insertEnd < this.text.length()) {
            resultBuffer.append(this.text.substring(insertEnd));
        }
        this.text = resultBuffer.toString();
        this.moveCursorBy(insertAt - this.selectionEnd + insertedLength);
    }

    public void deleteWords(int count) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(count) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int count) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean backwards = count < 0;
            int start = backwards ? this.cursorPosition + count : this.cursorPosition;
            int end = backwards ? this.cursorPosition : this.cursorPosition + count;
            String result = "";
            if (start > 0) {
                result = this.text.substring(0, start);
            }
            if (end < this.text.length()) {
                result = result + this.text.substring(end);
            }
            this.text = result;
            if (backwards) {
                this.moveCursorBy(count);
            }
        }
    }

    public int getNthWordFromPos(int count, int pos) {
        boolean reverse = count < 0;
        int position = pos;
        for (int i1 = 0; i1 < Math.abs(count); ++i1) {
            if (reverse) {
                while (position > 0 && this.text.charAt(position - 1) == ' ') {
                    --position;
                }
                while (position > 0 && this.text.charAt(position - 1) != ' ') {
                    --position;
                }
                continue;
            }
            if ((position = this.text.indexOf(32, position)) == -1) {
                position = this.text.length();
                continue;
            }
            while (position < this.text.length() && this.text.charAt(position) == ' ') {
                ++position;
            }
        }
        return position;
    }

    public int getNthWordFromCursor(int count) {
        return this.getNthWordFromPos(count, this.cursorPosition);
    }

    public static interface Filter {
        public String filter(String var1);

        public boolean isAllowedCharacter(char var1);
    }
}

