/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.TextField;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.SharedConstants;

public class TextFieldVanilla
extends TextField {
    private static final int BACKGROUND_WIDTH_OFFSET = 8;
    private static final float BACKGROUND_X_TRANSLATE = 4.0f;
    private static final int BACKGROUND_Y_TRANSLATE_OFFSET = 8;
    private static final int BACKGROUND_MOUSE_OFFSET_X = 4;
    private boolean backgroundEnabled = true;
    private int backgroundOuterColor = -6250336;
    private int backgroundInnerColor = -16777216;

    public TextFieldVanilla() {
        this.filter = new FilterVanilla();
    }

    public TextFieldVanilla(PaneParams params) {
        super(params);
        this.backgroundEnabled = params.getBooleanAttribute("background", this.backgroundEnabled);
        this.backgroundOuterColor = params.getColorAttribute("backgroundOuter", this.backgroundOuterColor);
        this.backgroundInnerColor = params.getColorAttribute("backgroundInner", this.backgroundInnerColor);
        this.filter = new FilterVanilla();
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean e) {
        this.backgroundEnabled = e;
    }

    public int getBackgroundOuterColor() {
        return this.backgroundOuterColor;
    }

    public void setBackgroundOuterColor(int c) {
        this.backgroundOuterColor = c;
    }

    public int getBackgroundInnerColor() {
        return this.backgroundInnerColor;
    }

    public void setBackgroundInnerColor(int c) {
        this.backgroundInnerColor = c;
    }

    @Override
    public int getInternalWidth() {
        return this.backgroundEnabled ? this.getWidth() - 8 : this.getWidth();
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        if (this.backgroundEnabled) {
            TextFieldVanilla.func_238467_a_((MatrixStack)ms, (int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)this.backgroundOuterColor);
            TextFieldVanilla.func_238467_a_((MatrixStack)ms, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundInnerColor);
            ms.func_227860_a_();
            ms.func_227861_a_(4.0, (double)((this.height - 8) / 2), 0.0);
        }
        super.drawSelf(ms, mx, my);
        if (this.backgroundEnabled) {
            ms.func_227865_b_();
        }
    }

    @Override
    public boolean handleClick(double mx, double my) {
        double mouseX = mx;
        if (this.backgroundEnabled) {
            mouseX -= 4.0;
        }
        super.handleClick(mouseX, my);
        return true;
    }

    private static class FilterVanilla
    implements TextField.Filter {
        private FilterVanilla() {
        }

        @Override
        public String filter(String s) {
            return SharedConstants.func_71565_a((String)s);
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return SharedConstants.func_71566_a((char)c);
        }
    }
}

