/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.ScrollingContainer;
import com.ldtteam.blockout.views.ScrollingListContainer;
import com.ldtteam.blockout.views.ScrollingView;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public class ScrollingList
extends ScrollingView {
    protected DataProvider dataProvider;
    private PaneParams listNodeParams;
    private int maxHeight;

    public ScrollingList() {
    }

    public ScrollingList(PaneParams params) {
        super(params);
        this.setMaxHeight(this.height);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setDataProvider(final IntSupplier countSupplier, final IPaneUpdater paneUpdater) {
        this.setDataProvider(new DataProvider(){

            @Override
            public int getElementCount() {
                return countSupplier.getAsInt();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                paneUpdater.apply(index, rowPane);
            }
        });
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.refreshElementPanes();
    }

    public void refreshElementPanes() {
        ((ScrollingListContainer)this.container).refreshElementPanes(this.dataProvider, this.listNodeParams, this.maxHeight);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.refreshElementPanes();
    }

    @Override
    @NotNull
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingListContainer(this);
    }

    @Override
    public void parseChildren(@NotNull PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes == null) {
            return;
        }
        this.listNodeParams = childNodes.get(0);
    }

    public int getListElementIndexByPane(Pane pane) {
        return ((ScrollingListContainer)this.container).getListElementIndexByPane(pane);
    }

    @FunctionalInterface
    public static interface IPaneUpdater {
        public void apply(int var1, Pane var2);
    }

    public static interface DataProvider {
        public int getElementCount();

        public void updateElement(int var1, Pane var2);
    }
}

