/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.MouseEventCallback;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.Window;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class View
extends Pane {
    @NotNull
    protected List<Pane> children = new ArrayList<Pane>();
    protected int padding = 0;

    public View() {
    }

    public View(PaneParams params) {
        super(params);
        this.padding = params.getIntAttribute("padding", this.padding);
    }

    @NotNull
    public List<Pane> getChildren() {
        return this.children;
    }

    @Override
    public void parseChildren(PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes == null) {
            return;
        }
        for (PaneParams node : childNodes) {
            Loader.createFromPaneParams(node, this);
        }
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        ms.func_227860_a_();
        int paddedX = this.x + this.padding;
        int paddedY = this.y + this.padding;
        ms.func_227861_a_((double)paddedX, (double)paddedY, 0.0);
        int drawX = mx - paddedX;
        int drawY = my - paddedY;
        this.children.stream().filter(this::childIsVisible).forEach(child -> child.draw(ms, drawX, drawY));
        ms.func_227865_b_();
    }

    @Override
    public void drawSelfLast(MatrixStack ms, int mx, int my) {
        ms.func_227860_a_();
        int paddedX = this.x + this.padding;
        int paddedY = this.y + this.padding;
        ms.func_227861_a_((double)paddedX, (double)paddedY, 0.0);
        int drawX = mx - paddedX;
        int drawY = my - paddedY;
        for (Pane child : this.children) {
            if (!child.isVisible()) continue;
            child.drawLast(ms, drawX, drawY);
        }
        ms.func_227865_b_();
    }

    @Override
    public boolean scrollInput(double wheel, double mx, double my) {
        this.handleUnhover();
        return this.mousePointableEventHandler(mx, my, (child, mxChild, myChild) -> child.scrollInput(wheel, mxChild, myChild), null);
    }

    @Override
    public boolean handleHover(double mx, double my) {
        return this.mousePointableEventHandler(mx, my, Pane::handleHover, Pane::handleUnhover);
    }

    @Override
    @Nullable
    public Pane findPaneByID(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        for (Pane child : this.children) {
            Pane found = child.findPaneByID(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void setWindow(Window w) {
        super.setWindow(w);
        for (Pane child : this.children) {
            child.setWindow(w);
        }
    }

    @Override
    public boolean rightClick(double mx, double my) {
        return this.mouseClickableEventHandler(mx, my, Pane::rightClick);
    }

    @Override
    public boolean click(double mx, double my) {
        return this.mouseClickableEventHandler(mx, my, Pane::click);
    }

    @Nullable
    public Pane findPaneForClick(double mx, double my) {
        AtomicReference result = new AtomicReference();
        this.mouseClickableEventHandler(mx, my, (child, mxChild, myChild) -> {
            result.set(child);
            return true;
        });
        return (Pane)((Object)result.get());
    }

    @Override
    public void onUpdate() {
        this.children.forEach(Pane::onUpdate);
    }

    protected boolean childIsVisible(Pane child) {
        return child.getX() < this.getInteriorWidth() && child.getY() < this.getInteriorHeight() && child.getX() + child.getWidth() >= 0 && child.getY() + child.getHeight() >= 0;
    }

    public int getInteriorWidth() {
        return this.width - this.padding * 2;
    }

    public int getInteriorHeight() {
        return this.height - this.padding * 2;
    }

    public void addChild(Pane child) {
        child.setWindow(this.getWindow());
        this.children.add(child);
        this.adjustChild(child);
        child.setParentView(this);
    }

    @Override
    public void handleUnhover() {
        for (Pane child : this.children) {
            child.handleUnhover();
        }
    }

    protected void adjustChild(Pane child) {
        Alignment alignment;
        int childX = child.getX();
        int childY = child.getY();
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        if (childWidth < 0) {
            childWidth = Math.max(0, this.getInteriorWidth() + childWidth);
        }
        if ((alignment = child.getAlignment()).isRightAligned()) {
            childX = this.getInteriorWidth() - childWidth - childX;
        } else if (alignment.isHorizontalCentered()) {
            childX = (this.getInteriorWidth() - childWidth) / 2 + childX;
        }
        if (childHeight < 0) {
            childHeight = Math.max(0, this.getInteriorHeight() + childHeight);
        }
        if (alignment.isBottomAligned()) {
            childY = this.getInteriorHeight() - childHeight - childY;
        } else if (alignment.isVerticalCentered()) {
            childY = (this.getInteriorHeight() - childHeight) / 2 + childY;
        }
        child.setSize(childWidth, childHeight);
        child.setPosition(childX, childY);
    }

    public void removeChild(Pane child) {
        this.children.remove((Object)child);
    }

    @Override
    public boolean onMouseDrag(double x, double y, int speed, double deltaX, double deltaY) {
        return this.mousePointableEventHandler(x, y, (child, mxChild, myChild) -> child.onMouseDrag(mxChild, myChild, speed, deltaX, deltaY), null);
    }

    public boolean mouseClickableEventHandler(double mx, double my, MouseEventCallback eventCallback) {
        return this.mouseEventProcessor(mx, my, Pane::canHandleClick, eventCallback, null);
    }

    public boolean mousePointableEventHandler(double mx, double my, MouseEventCallback eventCallbackPositive, @Nullable MouseEventCallback eventCallbackNegative) {
        return this.mouseEventProcessor(mx, my, Pane::isPointInPane, eventCallbackPositive, eventCallbackNegative);
    }

    public boolean mouseEventProcessor(double mx, double my, MouseEventCallback panePredicate, MouseEventCallback eventCallbackPositive, MouseEventCallback eventCallbackNegative) {
        ListIterator<Pane> it = this.children.listIterator(this.children.size());
        double mxChild = mx - (double)this.x - (double)this.padding;
        double myChild = my - (double)this.y - (double)this.padding;
        boolean invokedPositive = false;
        while (it.hasPrevious()) {
            Pane child = it.previous();
            if (panePredicate.accept(child, mxChild, myChild) && !invokedPositive) {
                if (eventCallbackNegative != null) {
                    invokedPositive = eventCallbackPositive.accept(child, mxChild, myChild);
                    continue;
                }
                return eventCallbackPositive.accept(child, mxChild, myChild);
            }
            if (eventCallbackNegative == null) continue;
            eventCallbackNegative.accept(child, mxChild, myChild);
        }
        return invokedPositive;
    }
}

