/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ZoomDragView
extends View {
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private double scale = 1.0;
    protected int contentHeight = 0;
    protected int contentWidth = 0;
    private double dragFactor = 1.0;
    private boolean dragEnabled = true;
    private double zoomFactor = 1.1;
    private boolean zoomEnabled = true;
    private double minScale = 0.2;
    private double maxScale = 2.0;

    public ZoomDragView() {
    }

    public ZoomDragView(PaneParams params) {
        super(params);
        this.dragFactor = params.getDoubleAttribute("dragfactor", this.dragFactor);
        this.dragEnabled = params.getBooleanAttribute("dragenabled", this.dragEnabled);
        this.zoomFactor = params.getDoubleAttribute("zoomfactor", this.zoomFactor);
        this.zoomEnabled = params.getBooleanAttribute("zoomenabled", this.zoomEnabled);
        this.minScale = params.getDoubleAttribute("minscale", this.minScale);
        this.maxScale = params.getDoubleAttribute("maxscale", this.maxScale);
    }

    @Override
    protected boolean childIsVisible(@NotNull Pane child) {
        return this.calcInverseAbsoluteX(child.getX()) < (double)this.getInteriorWidth() && this.calcInverseAbsoluteY(child.getY()) < (double)this.getInteriorHeight() && this.calcInverseAbsoluteX(child.getX() + child.getWidth()) >= 0.0 && this.calcInverseAbsoluteY(child.getY() + child.getHeight()) >= 0.0;
    }

    private double calcInverseAbsoluteX(double xIn) {
        return xIn * this.scale - this.scrollX;
    }

    private double calcInverseAbsoluteY(double yIn) {
        return yIn * this.scale - this.scrollY;
    }

    private double calcRelativeX(double xIn) {
        return (xIn - (double)this.x + this.scrollX) / this.scale + (double)this.x;
    }

    private double calcRelativeY(double yIn) {
        return (yIn - (double)this.y + this.scrollY) / this.scale + (double)this.y;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentSize();
    }

    @Override
    public void addChild(Pane child) {
        super.addChild(child);
        this.computeContentSize();
    }

    protected void computeContentSize() {
        this.contentHeight = 0;
        this.contentWidth = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
            this.contentWidth = Math.max(this.contentWidth, child.getX() + child.getWidth());
        }
        this.setScrollY(this.scrollY);
        this.setScrollX(this.scrollX);
    }

    private double getMaxScrollY() {
        return Math.max(0.0, (double)this.contentHeight * this.scale - (double)this.getHeight());
    }

    private double getMaxScrollX() {
        return Math.max(0.0, (double)this.contentWidth * this.scale - (double)this.getWidth());
    }

    protected void abstractDrawSelfPre(MatrixStack ms, int mx, int my) {
    }

    protected void abstractDrawSelfPost(MatrixStack ms, int mx, int my) {
    }

    @Override
    public void drawSelf(MatrixStack ms, int mx, int my) {
        this.scissorsStart(ms);
        ms.func_227860_a_();
        ms.func_227861_a_(-this.scrollX, -this.scrollY, 0.0);
        ms.func_227861_a_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        ms.func_227862_a_((float)this.scale, (float)this.scale, 1.0f);
        this.abstractDrawSelfPre(ms, mx, my);
        super.drawSelf(ms, (int)this.calcRelativeX(mx), (int)this.calcRelativeY(my));
        this.abstractDrawSelfPost(ms, mx, my);
        ms.func_227865_b_();
        this.scissorsEnd();
    }

    @Override
    public void drawSelfLast(MatrixStack ms, int mx, int my) {
        this.scissorsStart(ms);
        ms.func_227860_a_();
        ms.func_227861_a_(-this.scrollX, -this.scrollY, 0.0);
        ms.func_227861_a_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        ms.func_227862_a_((float)this.scale, (float)this.scale, 1.0f);
        super.drawSelfLast(ms, (int)this.calcRelativeX(mx), (int)this.calcRelativeY(my));
        ms.func_227865_b_();
        this.scissorsEnd();
    }

    private void setScrollY(double offset) {
        this.scrollY = MathHelper.func_151237_a((double)offset, (double)0.0, (double)this.getMaxScrollY());
    }

    private void setScrollX(double offset) {
        this.scrollX = MathHelper.func_151237_a((double)offset, (double)0.0, (double)this.getMaxScrollX());
    }

    @Override
    public boolean onMouseDrag(double startX, double startY, int speed, double x, double y) {
        boolean childResult = super.onMouseDrag(this.calcRelativeX(startX), this.calcRelativeY(startY), speed, this.calcRelativeX(x), this.calcRelativeY(y));
        if (!childResult && this.dragEnabled) {
            this.setScrollX(this.scrollX - x * this.dragFactor);
            this.setScrollY(this.scrollY - y * this.dragFactor);
            return true;
        }
        return childResult;
    }

    @Override
    public boolean scrollInput(double wheel, double mx, double my) {
        boolean childResult = super.scrollInput(wheel, mx, my);
        if (!childResult && this.zoomEnabled) {
            double childX = mx - (double)this.x;
            double childY = my - (double)this.y;
            double oldX = (childX + this.scrollX) / this.scale;
            double oldY = (childY + this.scrollY) / this.scale;
            this.scale = wheel < 0.0 ? this.scale / this.zoomFactor : this.scale * this.zoomFactor;
            this.scale = MathHelper.func_151237_a((double)this.scale, (double)this.minScale, (double)this.maxScale);
            this.setScrollX(oldX * this.scale - childX);
            this.setScrollY(oldY * this.scale - childY);
            return true;
        }
        return childResult;
    }

    @Override
    public boolean click(double mx, double my) {
        return super.click(this.calcRelativeX(mx), this.calcRelativeY(my));
    }

    @Override
    public Pane findPaneForClick(double mx, double my) {
        return super.findPaneForClick(this.calcRelativeX(mx), this.calcRelativeY(my));
    }

    @Override
    public boolean handleHover(double mx, double my) {
        return super.handleHover(this.calcRelativeX(mx), this.calcRelativeY(my));
    }

    @Override
    public boolean rightClick(double mx, double my) {
        return super.rightClick(this.calcRelativeX(mx), this.calcRelativeY(my));
    }

    public void treeViewHelperAddChild(Pane child) {
        super.addChild(child);
    }
}

