/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.ChunkPaletteFormat;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;

public class BlueprintUtil {
    private static final int DEFAULT_FIXER_IF_NOT_FOUND = DataFixerUtils.Versions.v1_12_2.getDataVersion();
    private static final String NBT_OPTIONAL_DATA_TAG = "optional_data";

    public static Blueprint createBlueprint(World world, BlockPos pos, boolean saveEntities, short sizeX, short sizeY, short sizeZ, String name, Optional<BlockPos> anchorPos) {
        ArrayList<BlockState> pallete = new ArrayList<BlockState>();
        pallete.add(Blocks.field_150350_a.func_176223_P());
        short[][][] structure = new short[sizeY][sizeZ][sizeX];
        ArrayList<CompoundNBT> tileEntities = new ArrayList<CompoundNBT>();
        ArrayList<String> requiredMods = new ArrayList<String>();
        for (BlockPos mutablePos : BlockPos.func_218278_a((BlockPos)pos, (BlockPos)pos.func_177982_a(sizeX - 1, sizeY - 1, sizeZ - 1))) {
            TileEntity te;
            BlockState state = world.func_180495_p(mutablePos);
            String modName = state.func_177230_c().getRegistryName().func_110624_b();
            short x = (short)(mutablePos.func_177958_n() - pos.func_177958_n());
            short y = (short)(mutablePos.func_177956_o() - pos.func_177956_o());
            short z = (short)(mutablePos.func_177952_p() - pos.func_177952_p());
            if (!modName.equals("minecraft")) {
                if (!requiredMods.contains(modName)) {
                    if (!ModList.get().getModContainerById(modName).isPresent()) {
                        requiredMods.add(modName);
                    }
                } else if (!ModList.get().getModContainerById(modName).isPresent()) {
                    structure[y][z][x] = (short)pallete.indexOf(Blocks.field_150350_a.func_176223_P());
                    continue;
                }
            }
            if ((te = world.func_175625_s(mutablePos)) != null) {
                CompoundNBT teTag = te.serializeNBT();
                teTag.func_74777_a("x", x);
                teTag.func_74777_a("y", y);
                teTag.func_74777_a("z", z);
                tileEntities.add(teTag);
            }
            if (!pallete.contains(state)) {
                pallete.add(state);
            }
            structure[y][z][x] = (short)pallete.indexOf(state);
        }
        CompoundNBT[] tes = tileEntities.toArray(new CompoundNBT[0]);
        ArrayList<CompoundNBT> entitiesTag = new ArrayList<CompoundNBT>();
        List entities = new ArrayList();
        if (saveEntities) {
            entities = world.func_72839_b(null, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + sizeX), (double)(pos.func_177956_o() + sizeY), (double)(pos.func_177952_p() + sizeZ)));
        }
        for (Entity entity : entities) {
            Vector3d oldPos = entity.func_213303_ch();
            CompoundNBT entityTag = entity.serializeNBT();
            ListNBT posList = new ListNBT();
            posList.add((Object)DoubleNBT.func_229684_a_((double)(oldPos.field_72450_a - (double)pos.func_177958_n())));
            posList.add((Object)DoubleNBT.func_229684_a_((double)(oldPos.field_72448_b - (double)pos.func_177956_o())));
            posList.add((Object)DoubleNBT.func_229684_a_((double)(oldPos.field_72449_c - (double)pos.func_177952_p())));
            BlockPos entityPos = entity.func_233580_cy_();
            if (entity instanceof HangingEntity) {
                entityPos = ((HangingEntity)entity).func_174857_n();
            }
            entityTag.func_218657_a("Pos", (INBT)posList);
            entityTag.func_218657_a("TileX", (INBT)IntNBT.func_229692_a_((int)(entityPos.func_177958_n() - pos.func_177958_n())));
            entityTag.func_218657_a("TileY", (INBT)IntNBT.func_229692_a_((int)(entityPos.func_177956_o() - pos.func_177956_o())));
            entityTag.func_218657_a("TileZ", (INBT)IntNBT.func_229692_a_((int)(entityPos.func_177952_p() - pos.func_177952_p())));
            entitiesTag.add(entityTag);
        }
        Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)pallete.size(), pallete, structure, tes, requiredMods);
        schem.setEntities(entitiesTag.toArray(new CompoundNBT[0]));
        if (anchorPos.isPresent()) {
            BlockPos relativeAnchorPos = new BlockPos((Vector3i)anchorPos.get().func_177973_b((Vector3i)pos));
            schem.setCachePrimaryOffset(relativeAnchorPos);
        }
        if (name != null) {
            schem.setName(name);
        }
        return schem;
    }

    public static CompoundNBT writeBlueprintToNBT(Blueprint schem) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74774_a("version", (byte)1);
        tag.func_74777_a("size_x", schem.getSizeX());
        tag.func_74777_a("size_y", schem.getSizeY());
        tag.func_74777_a("size_z", schem.getSizeZ());
        BlockState[] palette = schem.getPalette();
        ListNBT paletteTag = new ListNBT();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            paletteTag.add((Object)NBTUtil.func_190009_a((BlockState)palette[i]));
        }
        tag.func_218657_a("palette", (INBT)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        tag.func_74783_a("blocks", blockInt);
        ListNBT finishedTes = new ListNBT();
        CompoundNBT[] tes = (CompoundNBT[])Arrays.stream(schem.getTileEntities()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(Objects::nonNull).toArray(CompoundNBT[]::new);
        finishedTes.addAll(Arrays.asList(tes));
        tag.func_218657_a("tile_entities", (INBT)finishedTes);
        ListNBT finishedEntities = new ListNBT();
        CompoundNBT[] entities = schem.getEntities();
        finishedEntities.addAll(Arrays.asList(entities));
        tag.func_218657_a("entities", (INBT)finishedEntities);
        List<String> requiredMods = schem.getRequiredMods();
        ListNBT modsList = new ListNBT();
        for (String requiredMod : requiredMods) {
            modsList.add((Object)StringNBT.func_229705_a_((String)requiredMod));
        }
        tag.func_218657_a("required_mods", (INBT)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            tag.func_74778_a("name", name);
        }
        if (architects != null) {
            ListNBT architectsTag = new ListNBT();
            for (String architect : architects) {
                architectsTag.add((Object)StringNBT.func_229705_a_((String)architect));
            }
            tag.func_218657_a("architects", (INBT)architectsTag);
        }
        tag.func_218657_a("mcversion", (INBT)IntNBT.func_229692_a_((int)SharedConstants.func_215069_a().getWorldVersion()));
        CompoundNBT optionalTag = new CompoundNBT();
        CompoundNBT structurizeTag = new CompoundNBT();
        BlockPosUtil.writeToNBT(structurizeTag, "primary_offset", schem.getPrimaryBlockOffset());
        optionalTag.func_218657_a("structurize", (INBT)structurizeTag);
        tag.func_218657_a(NBT_OPTIONAL_DATA_TAG, (INBT)optionalTag);
        return tag;
    }

    private static List<BlockState> fixPalette(int oldDataVersion, ListNBT paletteTag) {
        short paletteSize = (short)paletteTag.size();
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
            CompoundNBT nbt = paletteTag.func_150305_b((int)i);
            try {
                CompoundNBT fixedNbt = DataFixerUtils.runDataFixer(nbt, TypeReferences.field_211296_l, oldDataVersion);
                switch (oldDataVersion) {
                    case 1343: {
                        BlueprintUtil.fixPalette1343(fixedNbt);
                    }
                }
                BlockState state = NBTUtil.func_190008_d((CompoundNBT)fixedNbt);
                palette.add(i, state);
                continue;
            }
            catch (Exception e) {
                palette.add(i, Blocks.field_150350_a.func_176223_P());
                Log.getLogger().warn("Blueprint reader: something went wrong loading block at position: " + i, (Throwable)e);
            }
        }
        return palette;
    }

    private static void fixPalette1343(CompoundNBT oldBlockState) {
        String name = oldBlockState.func_74779_i("Name");
        oldBlockState.func_74778_a("Name", oldBlockState.func_74779_i("Name").toLowerCase(Locale.US));
        if (name.contains("structurize")) {
            if (name.contains("blockshingle_")) {
                String[] split = name.split(":")[1].split("_");
                oldBlockState.func_74778_a("Name", "structurize:clay_" + (split.length > 2 ? split[1] + "_" + split[2] : split[1]) + "_shingle");
            } else if (name.contains("blockshingleslab")) {
                oldBlockState.func_74778_a("Name", "structurize:clay_shingle_slab");
            } else if (name.contains("blocktimberframe")) {
                String[] split = name.split(":")[1].split("_");
                String output = "structurize:" + (split.length > 3 ? split[3] : split[2]) + "_" + (split.length > 3 ? split[1] + "_" + split[2] : split[1]) + "_paper_timber_frame";
                output = output.replace("doublecrossed", "double_crossed");
                output = output.replace("sideframed", "side_framed");
                output = output.replace("upgated", "up_gated");
                output = output.replace("downgated", "down_gated");
                output = output.replace("onecrossedlr", "one_crossed_lr");
                output = output.replace("onecrossedrl", "one_crossed_rl");
                output = output.replace("horizontalplain", "horizontal_plain");
                output = output.replace("sideframedhorizontal", "side_framed_horizontal");
                oldBlockState.func_74778_a("Name", output);
            } else if (name.contains("blockpaperwall") && !name.contains("_")) {
                oldBlockState.func_74778_a("Name", "structurize:" + oldBlockState.func_74775_l("Properties").func_74779_i("variant") + "_blockpaperwall");
            }
        }
    }

    private static CompoundNBT[] fixTileEntities(int oldDataVersion, ListNBT tileEntitiesTag) {
        CompoundNBT[] tileEntities = new CompoundNBT[tileEntitiesTag.size()];
        for (int i = 0; i < tileEntities.length; i = (int)((short)(i + 1))) {
            CompoundNBT nbt = tileEntitiesTag.func_150305_b(i);
            try {
                String id = nbt.func_74779_i("id");
                if (id.contains("minecolonies")) {
                    nbt.func_74778_a("id", id.toLowerCase(Locale.US));
                    nbt.func_74778_a("Item", nbt.func_74779_i("Item".toLowerCase(Locale.US)));
                    tileEntities[i] = nbt;
                    continue;
                }
                if (id.equals("minecraft:flower_pot") || id.equals("minecraft:noteblock")) {
                    tileEntities[i] = nbt;
                    continue;
                }
                tileEntities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, TypeReferences.field_211294_j, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                tileEntities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading tile entity at position: " + i, (Throwable)e);
            }
        }
        return tileEntities;
    }

    private static CompoundNBT[] fixEntities(int oldDataVersion, ListNBT entitiesTag) {
        CompoundNBT[] entities = new CompoundNBT[entitiesTag.size()];
        for (int i = 0; i < entities.length; i = (int)((short)(i + 1))) {
            CompoundNBT nbt = entitiesTag.func_150305_b(i);
            try {
                String id = nbt.func_74779_i("id");
                entities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, TypeReferences.field_211299_o, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                entities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading entity at position: " + i, (Throwable)e);
            }
        }
        return entities;
    }

    private static List<BlockPos> searchForBlockIdInBlocks(short idToCheck, short[][][] blocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int y = 0; y < blocks.length; y = (int)((short)(y + 1))) {
            short[][] temp = blocks[y];
            for (int z = 0; z < temp.length; z = (int)((short)(z + 1))) {
                short[] temp2 = temp[z];
                for (int x = 0; x < temp2.length; x = (int)((short)(x + 1))) {
                    short id = temp2[x];
                    if (id != idToCheck) continue;
                    result.add(new BlockPos(x, y, z));
                }
            }
        }
        return result;
    }

    private static Map<Integer, BlockPos> searchForTEposInTEs(List<BlockPos> blockPosToFind, CompoundNBT[] tileEntities) {
        HashMap<Integer, BlockPos> result = new HashMap<Integer, BlockPos>();
        for (int i = 0; i < tileEntities.length; ++i) {
            BlockPos bp;
            CompoundNBT compound = tileEntities[i];
            if (compound == null || !blockPosToFind.contains(bp = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")))) continue;
            result.put(i, bp);
        }
        return result;
    }

    private static void teToBlockStateFix(List<BlockState> palette, short[][][] blocks, CompoundNBT[] tileEntities, short paletteIndex, Function<CompoundNBT, CompoundNBT> dataFixer) {
        Map<Integer, BlockPos> teToReplace = BlueprintUtil.searchForTEposInTEs(BlueprintUtil.searchForBlockIdInBlocks(paletteIndex, blocks), tileEntities);
        HashMap<BlockState, Short> newBlocksToBlockId = new HashMap<BlockState, Short>();
        boolean paletteFull = false;
        palette.set(paletteIndex, null);
        for (Map.Entry<Integer, BlockPos> e : teToReplace.entrySet()) {
            short newBlockId;
            CompoundNBT teCompound = tileEntities[e.getKey()];
            tileEntities[e.getKey().intValue()] = null;
            CompoundNBT newBScompound = dataFixer.apply(teCompound);
            BlockState newBlockState = NBTUtil.func_190008_d((CompoundNBT)newBScompound);
            short s = newBlockId = paletteFull ? newBlocksToBlockId.getOrDefault(newBlockState, (short)palette.size()) : paletteIndex;
            if (newBlockId == palette.size()) {
                palette.add(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
            } else if (!paletteFull) {
                palette.set(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
                paletteFull = true;
            }
            blocks[e.getValue().func_177956_o()][e.getValue().func_177952_p()][e.getValue().func_177958_n()] = newBlockId;
        }
    }

    private static void fixCross1343(List<BlockState> palette, short[][][] blocks, CompoundNBT[] tileEntities, CompoundNBT[] entities) {
        short s = palette.size();
        for (short i = 0; i < s; i = (short)(i + 1)) {
            BlockState bs = palette.get(i);
            if (bs.func_177230_c() == Blocks.field_196685_eC) {
                BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                    String type = teCompound.func_74779_i("Item") + teCompound.func_74762_e("Data");
                    return (CompoundNBT)((Dynamic)ChunkPaletteFormat.field_199158_n.getOrDefault(type, ChunkPaletteFormat.field_199158_n.get("minecraft:air0"))).getValue();
                });
                continue;
            }
            if (bs.func_177230_c() != Blocks.field_196586_al) continue;
            BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                String type = Boolean.toString(teCompound.func_74767_n("powered")) + (byte)Math.min(Math.max(teCompound.func_74762_e("note"), 0), 24);
                return (CompoundNBT)((Dynamic)ChunkPaletteFormat.field_199161_q.getOrDefault(type, ChunkPaletteFormat.field_199161_q.get("false0"))).getValue();
            });
        }
    }

    public static Blueprint readBlueprintFromNBT(CompoundNBT nbtTag) {
        CompoundNBT tag = nbtTag;
        byte version = tag.func_74771_c("version");
        if (version == 1) {
            CompoundNBT optionalTag;
            short sizeX = tag.func_74765_d("size_x");
            short sizeY = tag.func_74765_d("size_y");
            short sizeZ = tag.func_74765_d("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList missingMods = new ArrayList();
            ListNBT modsList = (ListNBT)tag.func_74781_a("required_mods");
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(modsList.get(i).func_150285_a_());
                if (((String)requiredMods.get(i)).equals("minecraft") || ModList.get().getModContainerById((String)requiredMods.get(i)).isPresent()) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add(requiredMods.get(i));
            }
            int oldDataVersion = tag.func_74764_b("mcversion") ? tag.func_74762_e("mcversion") : DEFAULT_FIXER_IF_NOT_FOUND;
            ListNBT paletteTag = (ListNBT)tag.func_74781_a("palette");
            List<BlockState> palette = BlueprintUtil.fixPalette(oldDataVersion, paletteTag);
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.func_74759_k("blocks"), sizeX, sizeY, sizeZ);
            CompoundNBT[] tileEntities = BlueprintUtil.fixTileEntities(oldDataVersion, (ListNBT)tag.func_74781_a("tile_entities"));
            CompoundNBT[] entities = BlueprintUtil.fixEntities(oldDataVersion, (ListNBT)tag.func_74781_a("entities"));
            if (oldDataVersion == DEFAULT_FIXER_IF_NOT_FOUND) {
                BlueprintUtil.fixCross1343(palette, blocks, tileEntities, entities);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)palette.size(), palette, blocks, tileEntities, requiredMods).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.func_150296_c().contains("name")) {
                schem.setName(tag.func_74779_i("name"));
            }
            if (tag.func_150296_c().contains("architects")) {
                ListNBT architectsTag = (ListNBT)tag.func_74781_a("architects");
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.func_150307_f(i);
                }
                schem.setArchitects(architects);
            }
            if (tag.func_150296_c().contains(NBT_OPTIONAL_DATA_TAG) && (optionalTag = tag.func_74775_l(NBT_OPTIONAL_DATA_TAG)).func_150296_c().contains("structurize")) {
                CompoundNBT structurizeTag = optionalTag.func_74775_l("structurize");
                BlockPos offsetPos = BlockPosUtil.readFromNBT(structurizeTag, "primary_offset");
                schem.setCachePrimaryOffset(offsetPos);
            }
            return schem;
        }
        return null;
    }

    public static void writeToStream(OutputStream os, Blueprint schem) {
        try {
            CompressedStreamTools.func_74799_a((CompoundNBT)BlueprintUtil.writeBlueprintToNBT(schem), (OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    private static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

