/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;

public class DataFixerUtils {
    public static final List<Integer> VERSIONS_LIST = Arrays.asList(Versions.values()).stream().map(ver -> ver.getDataVersion()).sorted().collect(Collectors.toList());

    private DataFixerUtils() {
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, Versions startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, Versions startVersion, Versions endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), endVersion.getDataVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, endVersion, startVersion <= Versions.pre1466.getDataVersion() && Versions.post1466.getDataVersion() <= endVersion && dataType == TypeReferences.field_211294_j);
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion, boolean debugNonBlockstate) {
        return startVersion == endVersion ? dataIn : (debugNonBlockstate && dataType != TypeReferences.field_211296_l ? DataFixerUtils.runDataFixerCascade(dataIn, dataType, startVersion, endVersion) : (CompoundNBT)DataFixesManager.func_210901_a().update(dataType, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)dataIn), startVersion, endVersion).getValue());
    }

    public static CompoundNBT runDataFixerCascade(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        CompoundNBT fixedNbt = dataIn;
        Versions currentVersion = Versions.findFromDataVersion(startVersion);
        while (currentVersion.getDataVersion() < endVersion) {
            fixedNbt = (CompoundNBT)DataFixesManager.func_210901_a().update(dataType, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)fixedNbt), currentVersion.getDataVersion(), currentVersion.getSuccessor().getDataVersion()).getValue();
            if ((currentVersion = currentVersion.getSuccessor()) != Versions.pre1466 || dataType != TypeReferences.field_211294_j) continue;
            currentVersion = Versions.post1466;
        }
        return fixedNbt;
    }

    public static enum Versions {
        v1_16_1(2567, "1.16.1", null),
        v1_16(2566, "1.16", v1_16_1),
        v1_15_2(2230, "1.15.2", v1_16),
        v1_15_1(2227, "1.15.1", v1_15_2),
        v1_15(2225, "1.15", v1_15_1),
        v1_14_4(1976, "1.14.4", v1_15),
        v1_14_3(1968, "1.14.3", v1_14_4),
        v1_14_2(1963, "1.14.2", v1_14_3),
        v1_14_1(1957, "1.14.1", v1_14_2),
        v1_14(1952, "1.14", v1_14_1),
        v1_13_2(1631, "1.13.2", v1_14),
        v1_13_1(1628, "1.13.1", v1_13_2),
        v1_13(1519, "1.13", v1_13_1),
        post1466(1467, "post1466", v1_13),
        pre1466(1465, "pre1466", post1466),
        v1_12_2(1343, "1.12.2", pre1466),
        v1_12_1(1241, "1.12.1", v1_12_2),
        v1_12(1139, "1.12", v1_12_1),
        v1_11_2(922, "1.11.2", v1_12),
        v1_11_1(921, "1.11.1", v1_11_2),
        v1_11(819, "1.11", v1_11_1),
        v1_10_2(512, "1.10.2", v1_11),
        v1_10_1(511, "1.10.1", v1_10_2),
        v1_10(510, "1.10", v1_10_1),
        v1_9_4(184, "1.9.4", v1_10),
        v1_9_3(183, "1.9.3", v1_9_4),
        v1_9_2(176, "1.9.2", v1_9_3),
        v1_9_1(175, "1.9.1", v1_9_2),
        v1_9(169, "1.9", v1_9_1),
        DEFAULT(0, null, v1_9);

        private final int dataVersion;
        private final String mcVersion;
        private final Versions successor;

        private Versions(int dataVersion, String mcVersion, Versions successor) {
            this.dataVersion = dataVersion;
            this.mcVersion = mcVersion;
            this.successor = successor;
        }

        public int getDataVersion() {
            return this.dataVersion;
        }

        public String getMcVersion() {
            return this.mcVersion;
        }

        public Versions getSuccessor() {
            return this.successor;
        }

        public static Versions findFromMcVersion(String mcVersion) {
            for (Versions ver : Versions.values()) {
                if (!ver.getMcVersion().equals(mcVersion)) continue;
                return ver;
            }
            return DEFAULT;
        }

        public static Versions findFromDataVersion(int dataVersion) {
            for (Versions ver : Versions.values()) {
                if (ver.getDataVersion() != dataVersion) continue;
                return ver;
            }
            return DEFAULT;
        }
    }
}

