/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.decorative;

import com.ldtteam.structurize.blocks.AbstractBlockStructurizeDirectional;
import com.ldtteam.structurize.blocks.types.ShingleFaceType;
import com.ldtteam.structurize.blocks.types.ShingleSlabShapeType;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.NotNull;

public class BlockShingleSlab
extends AbstractBlockStructurizeDirectional<BlockShingleSlab> {
    public static final EnumProperty<ShingleSlabShapeType> SHAPE = EnumProperty.func_177709_a((String)"shape", ShingleSlabShapeType.class);
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private static final int FOUR_CONNECTIONS = 4;
    private static final int THREE_CONNECTIONS = 3;
    private static final int TWO_CONNECTIONS = 2;
    private static final int ONE_CONNECTION = 1;
    private final ShingleFaceType faceType;

    public BlockShingleSlab(ShingleFaceType faceType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 1.0f));
        this.setRegistryName(faceType.getName() + "_shingle_slab");
        this.faceType = faceType;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction HORIZONTAL_FACING, BlockState HORIZONTAL_FACINGState, IWorld worldIn, BlockPos currentPos, BlockPos HORIZONTAL_FACINGPos) {
        return BlockShingleSlab.getSlabShape(stateIn, worldIn, currentPos);
    }

    public BlockState getStateForPlacement(BlockState state, Direction HORIZONTAL_FACING, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        return BlockShingleSlab.getSlabShape(state, world, pos1);
    }

    public ShingleFaceType getFaceType() {
        return this.faceType;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.9, (double)7.9, (double)15.9);
    }

    private static BlockState getSlabShape(@NotNull BlockState state, @NotNull IWorld world, @NotNull BlockPos position) {
        BlockState shapeState;
        boolean north = world.func_180495_p(position.func_177978_c()).func_177230_c() instanceof BlockShingleSlab;
        boolean south = world.func_180495_p(position.func_177968_d()).func_177230_c() instanceof BlockShingleSlab;
        boolean east = world.func_180495_p(position.func_177974_f()).func_177230_c() instanceof BlockShingleSlab;
        boolean west = world.func_180495_p(position.func_177976_e()).func_177230_c() instanceof BlockShingleSlab;
        boolean[] connectors = new boolean[]{north, south, east, west};
        int amount = 0;
        for (boolean check : connectors) {
            if (!check) continue;
            ++amount;
        }
        if (amount == 1) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.ONE_WAY));
            if (north) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (east) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
        }
        if (amount == 2) {
            if (north && east) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
            if (north && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (south && east) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (north && south) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (east && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
        }
        if (amount == 3) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.THREE_WAY));
            if (north && east && west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south && east && west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (east && north && south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (west && north && south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
        }
        if (amount == 4) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.FOUR_WAY));
            return shapeState;
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TOP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, SHAPE});
    }
}

