/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.items.ItemScanTool;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScanCommand
extends AbstractCommand {
    public static final String NAME = "scan";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String SCAN_SUCCESS_MESSAGE = "com.structurize.command.scan.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.scan.no.perm";
    private static final String FILE_NAME = "filename";
    private static final String PLAYER_NAME = "player";
    private static final String POS1 = "pos1";
    private static final String POS2 = "pos2";
    private static final String ANCHOR_POS = "anchor_pos";

    private static int execute(CommandSource source, BlockPos from, BlockPos to, Optional<BlockPos> anchorPos, GameProfile profile, String name) throws CommandSyntaxException {
        ServerPlayerEntity player;
        ServerWorld world = source.func_197023_e();
        if (source.func_197022_f() instanceof PlayerEntity && !source.func_197035_h().func_184812_l_()) {
            source.func_197021_a((ITextComponent)new StringTextComponent(NO_PERMISSION_MESSAGE));
        }
        if (profile != null && world.func_73046_m() != null) {
            player = world.func_73046_m().func_184103_al().func_177451_a(profile.getId());
            if (player == null) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent(PLAYER_NOT_FOUND, new Object[]{profile.getName()}));
                return 0;
            }
        } else if (source.func_197022_f() instanceof PlayerEntity) {
            player = source.func_197035_h();
        } else {
            source.func_197021_a((ITextComponent)new TranslationTextComponent(PLAYER_NOT_FOUND));
            return 0;
        }
        ItemScanTool.saveStructure((World)world, from, to, (PlayerEntity)player, name == null ? "" : name, true, anchorPos);
        source.func_197021_a((ITextComponent)new TranslationTextComponent(SCAN_SUCCESS_MESSAGE));
        return 1;
    }

    private static int onExecute(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.func_197274_b(context, (String)POS1);
        BlockPos to = BlockPosArgument.func_197274_b(context, (String)POS2);
        return ScanCommand.execute((CommandSource)context.getSource(), from, to, Optional.empty(), null, null);
    }

    private static int onExecuteWithAnchor(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.func_197274_b(context, (String)POS1);
        BlockPos to = BlockPosArgument.func_197274_b(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.func_197274_b(context, (String)ANCHOR_POS);
        return ScanCommand.execute((CommandSource)context.getSource(), from, to, Optional.of(anchorPos), null, null);
    }

    private static int onExecuteWithPlayerName(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.func_197274_b(context, (String)POS1);
        BlockPos to = BlockPosArgument.func_197274_b(context, (String)POS2);
        GameProfile profile = GameProfileArgument.func_197109_a(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        return ScanCommand.execute((CommandSource)context.getSource(), from, to, Optional.empty(), profile, null);
    }

    private static int onExecuteWithPlayerNameAndFileName(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.func_197274_b(context, (String)POS1);
        BlockPos to = BlockPosArgument.func_197274_b(context, (String)POS2);
        GameProfile profile = GameProfileArgument.func_197109_a(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSource)context.getSource(), from, to, Optional.empty(), profile, name);
    }

    private static int onExecuteWithPlayerNameAndFileNameAndAnchorPos(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.func_197274_b(context, (String)POS1);
        BlockPos to = BlockPosArgument.func_197274_b(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.func_197274_b(context, (String)ANCHOR_POS);
        GameProfile profile = GameProfileArgument.func_197109_a(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSource)context.getSource(), from, to, Optional.of(anchorPos), profile, name);
    }

    protected static LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)ScanCommand.newLiteral(NAME).then(ScanCommand.newArgument(POS1, BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ScanCommand.newArgument(POS2, BlockPosArgument.func_197276_a()).executes(ScanCommand::onExecute)).then(ScanCommand.newArgument(ANCHOR_POS, BlockPosArgument.func_197276_a()).executes(ScanCommand::onExecuteWithAnchor))).then(((RequiredArgumentBuilder)ScanCommand.newArgument(PLAYER_NAME, GameProfileArgument.func_197108_a()).executes(ScanCommand::onExecuteWithPlayerName)).then(((RequiredArgumentBuilder)ScanCommand.newArgument(FILE_NAME, StringArgumentType.word()).executes(ScanCommand::onExecuteWithPlayerNameAndFileName)).then(ScanCommand.newArgument(ANCHOR_POS, BlockPosArgument.func_197276_a()).executes(ScanCommand::onExecuteWithPlayerNameAndFileNameAndAnchorPos))))));
    }
}

