/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintHandler;
import com.ldtteam.structures.client.StructureClientHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.BoxRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventSubscriber {
    public static Map<BlockPos, List<String>> tagPosList = null;
    public static BlockPos tagAnchor;

    @SubscribeEvent
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_render");
        Blueprint blueprint = Settings.instance.getActiveStructure();
        if (blueprint != null) {
            BlockPos offset = new BlockPos(0, 0, 0);
            BlockPos primaryOffset = blueprint.getPrimaryBlockOffset();
            StructureClientHandler.renderStructure(blueprint, event.getPartialTicks(), Settings.instance.getPosition().func_177973_b((Vector3i)offset), event.getMatrixStack());
            BlockPos pos2 = Settings.instance.getPosition().func_177973_b((Vector3i)primaryOffset);
            BlockPos size = new BlockPos((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ());
            Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_box");
            ClientEventSubscriber.renderAnchorPos(primaryOffset.func_177971_a((Vector3i)pos2), event);
            ClientEventSubscriber.renderBox(pos2.func_177973_b((Vector3i)offset), pos2.func_177971_a((Vector3i)size).func_177973_b((Vector3i)new BlockPos(1, 1, 1)).func_177973_b((Vector3i)offset), event);
        }
        if (Settings.instance.getBox() != null) {
            Settings.instance.getAnchorPos().ifPresent(pos -> ClientEventSubscriber.renderAnchorPos(pos, event));
            Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_box");
            ClientEventSubscriber.renderBox((BlockPos)Settings.instance.getBox().func_76341_a(), (BlockPos)Settings.instance.getBox().func_76340_b(), event);
        }
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() != ModItems.tagTool) {
            tagPosList = null;
            tagAnchor = null;
            return;
        }
        if (tagAnchor == null) {
            ItemStack tagtool = player.func_184586_b(Hand.MAIN_HAND);
            if (tagtool.func_196082_o().func_74764_b("anchorpostag")) {
                tagAnchor = BlockPosUtil.readFromNBT(tagtool.func_196082_o(), "anchorpostag");
            } else {
                return;
            }
        }
        if (tagPosList == null) {
            TileEntity te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(tagAnchor);
            if (!(te instanceof IBlueprintDataProvider)) {
                return;
            }
            IBlueprintDataProvider dataProvider = (IBlueprintDataProvider)te;
            tagPosList = dataProvider.getWorldTagPosMap();
        }
        ClientEventSubscriber.renderAnchorPos(tagAnchor, event);
        for (Map.Entry<BlockPos, List<String>> entry : tagPosList.entrySet()) {
            ClientEventSubscriber.renderBox(entry.getKey(), entry.getKey(), event);
            ClientEventSubscriber.renderDebugText(entry.getKey(), entry.getValue(), event.getMatrixStack());
        }
    }

    private static void renderAnchorPos(BlockPos anchorPos, RenderWorldLastEvent event) {
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        ClientEventSubscriber.renderBox(anchorPos, anchorPos, event, 1.0f, 0.0f, 0.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    private static void renderBox(BlockPos posA, BlockPos posB, RenderWorldLastEvent event) {
        ClientEventSubscriber.renderBox(posA, posB, event, 1.0f, 1.0f, 1.0f);
    }

    private static void renderBox(BlockPos posA, BlockPos posB, RenderWorldLastEvent event, float red, float green, float blue) {
        int x1 = posA.func_177958_n();
        int y1 = posA.func_177956_o();
        int z1 = posA.func_177952_p();
        int x2 = posB.func_177958_n();
        int y2 = posB.func_177956_o();
        int z2 = posB.func_177952_p();
        if (x1 > x2) {
            ++x1;
        } else {
            ++x2;
        }
        if (y1 > y2) {
            ++y1;
        } else {
            ++y2;
        }
        if (z1 > z2) {
            ++z1;
        } else {
            ++z2;
        }
        RenderSystem.enableDepthTest();
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().func_175598_ae().field_217783_c;
        Vector3d viewPosition = activeRenderInfo.func_216785_c();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-viewPosition.field_72450_a, -viewPosition.field_72448_b, -viewPosition.field_72449_c);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        BoxRenderer.drawSelectionBoundingBox(matrix4f, axisalignedbb.func_186662_g(0.002), red, green, blue, 1.0f);
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
    }

    private static void renderDebugText(BlockPos pos, List<String> text, MatrixStack matrixStack) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        Vector3d viewPosition = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        matrixStack.func_227861_a_(-viewPosition.field_72450_a, -viewPosition.field_72448_b, -viewPosition.field_72449_c);
        matrixStack.func_227861_a_(0.0, 0.75, 0.0);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        matrixStack.func_227863_a_(renderManager.func_229098_b_());
        matrixStack.func_227862_a_(-0.014f, -0.014f, 0.014f);
        matrixStack.func_227861_a_(0.0, 18.0, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ArrayList<String> toRender = new ArrayList<String>();
        for (String element : text) {
            if (toRender.size() >= 3) {
                fontrenderer.func_228079_a_(((Object)toRender).toString(), (float)(-fontrenderer.func_78256_a(((Object)toRender).toString())) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, true, 0, 0xF000F0);
                matrixStack.func_227861_a_(0.0, 10.0, 0.0);
                toRender.clear();
            }
            toRender.add(element);
        }
        if (!toRender.isEmpty()) {
            fontrenderer.func_228079_a_(((Object)toRender).toString(), (float)(-fontrenderer.func_78256_a(((Object)toRender).toString())) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, true, 0, 0xF000F0);
        }
        buffer.func_228461_a_();
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            BlueprintHandler.getInstance().cleanCache();
        }
    }
}

