/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.commands.EntryPoint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.jetbrains.annotations.NotNull;

public class EventSubscriber {
    private EventSubscriber() {
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        Structures.init();
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), (ServerPlayerEntity)event.getPlayer());
            Network.getNetwork().sendToPlayer(new StructurizeStylesMessage(), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Manager.onWorldTick((ServerWorld)event.world);
    }
}

