/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.management.UUIDStorage;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

public final class Manager {
    private static boolean schematicDownloaded = false;
    private static LinkedList<ChangeStorage> changeQueue = new LinkedList();
    private static LinkedList<TickedWorldOperation> scanToolOperationPool = new LinkedList();
    private static volatile UUID serverUUID = null;

    private Manager() {
    }

    public static void onWorldTick(ServerWorld world) {
        TickedWorldOperation operation;
        if (!scanToolOperationPool.isEmpty() && (operation = scanToolOperationPool.peek()) != null && operation.apply(world)) {
            scanToolOperationPool.pop();
            if (!operation.isUndo()) {
                Manager.addToUndoCache(operation.getChangeStorage());
            }
        }
    }

    public static void addToQueue(TickedWorldOperation operation) {
        scanToolOperationPool.push(operation);
    }

    public static void addToUndoCache(ChangeStorage storage) {
        if (changeQueue.size() >= (Integer)Structurize.getConfig().getCommon().maxCachedChanges.get()) {
            changeQueue.pop();
        }
        changeQueue.push(storage);
    }

    public static void pasteStructure(ServerWorld server, BlockPos pos, int width, int length, int height, int frequency, String equation, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow, ServerPlayerEntity player, Mirror mirror, Rotation rotation) {
        Blueprint blueprint = Manager.getStructureFromFormula(width, length, height, frequency, equation, shape, inputBlock, inputFillBlock, hollow);
        StructurePlacementUtils.loadAndPlaceStructureWithRotation((World)server, blueprint, pos, rotation, mirror, true, player);
    }

    public static Blueprint getStructureFromFormula(int width, int length, int height, int frequency, String equation, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow) {
        BlockState mainBlock = BlockUtils.getBlockStateFromStack(inputBlock);
        BlockState fillBlock = BlockUtils.getBlockStateFromStack(inputFillBlock);
        Blueprint blueprint = shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL ? Manager.generateSphere(height / 2, mainBlock, fillBlock, hollow, shape) : (shape == Shape.CUBE ? Manager.generateCube(height, width, length, mainBlock, fillBlock, hollow) : (shape == Shape.WAVE ? Manager.generateWave(height, width, length, frequency, mainBlock, true) : (shape == Shape.WAVE_3D ? Manager.generateWave(height, width, length, frequency, mainBlock, false) : (shape == Shape.CYLINDER ? Manager.generateCylinder(height, width, mainBlock, fillBlock, hollow) : (shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND ? Manager.generatePyramid(height, mainBlock, fillBlock, hollow, shape) : Manager.generateRandomShape(height, width, length, equation, mainBlock))))));
        return blueprint;
    }

    private static Blueprint generatePyramid(int inputHeight, BlockState block, BlockState fillBlock, boolean hollow, Shape shape) {
        int height = shape == Shape.DIAMOND ? inputHeight : inputHeight * 2;
        int hHeight = height / 2;
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y < hHeight; ++y) {
            for (int x = 0; x < hHeight; ++x) {
                for (int z = 0; z < hHeight; ++z) {
                    BlockState blockToUse;
                    if (!(x == z && x >= y || x == y && x >= z) && (!(hollow ? y == z : y >= z) || y < x) || x * z > y * y) continue;
                    BlockState blockState = blockToUse = x == z && x >= y || x == y || y == z ? block : fillBlock;
                    if (shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
                        Manager.addPosToList(new BlockPos(hHeight + x, y, hHeight + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight + x, y, hHeight - z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight - x, y, hHeight + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight - x, y, hHeight - z), blockToUse, posList);
                    }
                    if (shape != Shape.PYRAMID && shape != Shape.DIAMOND) continue;
                    Manager.addPosToList(new BlockPos(hHeight + x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight + x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight - x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight - x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)height, (short)(shape == Shape.DIAMOND ? height : inputHeight + 2), (short)height);
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateCube(int height, int width, int length, BlockState block, BlockState fillBlock, boolean hollow) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    if (x == 0 || x == width - 1 || y == 0 || y == height - 1 || z == 0 || z == length - 1) {
                        posList.put(new BlockPos(x, y, z), block);
                        continue;
                    }
                    if (hollow) continue;
                    posList.put(new BlockPos(x, y, z), fillBlock);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)width, (short)height, (short)length);
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateSphere(int height, BlockState block, BlockState fillBlock, boolean hollow, Shape shape) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y <= height + 1; ++y) {
            for (int x = 0; x <= height + 1; ++x) {
                for (int z = 0; z <= height + 1; ++z) {
                    BlockState blockToUse;
                    int sum = x * x + z * z + y * y;
                    if (sum >= height * height || hollow && sum <= height * height - 2 * height) continue;
                    BlockState blockState = blockToUse = sum > height * height - 2 * height ? block : fillBlock;
                    if (shape == Shape.HALF_SPHERE || shape == Shape.SPHERE) {
                        Manager.addPosToList(new BlockPos(height + x, height + y, height + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height + x, height + y, height - z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height - x, height + y, height + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height - x, height + y, height - z), blockToUse, posList);
                    }
                    if (shape != Shape.BOWL && shape != Shape.SPHERE) continue;
                    Manager.addPosToList(new BlockPos(height + x, height - y, height + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height + x, height - y, height - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height - x, height - y, height + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height - x, height - y, height - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)((height + 2) * 2), (short)((height + 2) * 2), (short)((height + 2) * 2));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateCylinder(int height, int width, BlockState block, BlockState fillBlock, boolean hollow) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (int y = 0; y < height; ++y) {
                    int sum = x * x + z * z;
                    if (sum >= width * width / 4 || hollow && sum <= width * width / 4 - width) continue;
                    BlockState blockToUse = sum > width * width / 4 - width ? block : fillBlock;
                    Manager.addPosToList(new BlockPos(width + x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width + x, y, width - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)(width * 2), (short)height, (short)(width * 2));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateWave(int height, int width, int length, int frequency, BlockState block, boolean flat) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int x = 0; x < length; ++x) {
            for (int z = 0; z < width; ++z) {
                double yVal = (double)(flat ? 0 : z) + (double)frequency * Math.sin((double)x / (double)height);
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)frequency, (double)((flat ? 0 : width) + z)), block, posList);
                if (flat) continue;
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)frequency, (double)(width - z)), block, posList);
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)width - 1.0 + (double)frequency, (double)(width + z - width + 1)), block, posList);
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)width - 1.0 + (double)frequency, (double)(width - z + width - 1)), block, posList);
            }
        }
        Blueprint blueprint = new Blueprint((short)length, (short)(frequency * 2 + 1 + (!flat ? width * 2 : 0)), (short)(width * 2 + 1));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    public static Blueprint generateRandomShape(int height, int width, int length, String equation, BlockState block) {
        Expression e = new Expression(equation, new PrimitiveElement[0]);
        Argument argumentX = new Argument("x = 0", new PrimitiveElement[0]);
        Argument argumentY = new Argument("y = 0", new PrimitiveElement[0]);
        Argument argumentZ = new Argument("z = 0", new PrimitiveElement[0]);
        Argument argumentH = new Argument("h = " + height, new PrimitiveElement[0]);
        Argument argumentW = new Argument("w = " + width, new PrimitiveElement[0]);
        Argument argumentL = new Argument("l = " + length, new PrimitiveElement[0]);
        e.addArguments(new Argument[]{argumentX, argumentY, argumentZ, argumentH, argumentW, argumentL});
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (double x = (double)(-length) / 2.0; x <= (double)(length / 2); x += 1.0) {
            for (double y = (double)(-height) / 2.0; y <= (double)(height / 2); y += 1.0) {
                for (double z = (double)(-width) / 2.0; z <= (double)(width / 2); z += 1.0) {
                    argumentX.setArgumentValue(x);
                    argumentY.setArgumentValue(y);
                    argumentZ.setArgumentValue(z);
                    if (e.calculate() != 1.0) continue;
                    Manager.addPosToList(new BlockPos(x + (double)length / 2.0, y + (double)height / 2.0, z + (double)width / 2.0), block, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)(length + 1), (short)(height + 1), (short)(width + 1));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static void addPosToList(BlockPos blockPos, BlockState blockToUse, Map<BlockPos, BlockState> posList) {
        if (!posList.containsKey(blockPos)) {
            posList.put(blockPos, blockToUse);
        }
    }

    public static void undo(PlayerEntity player) {
        Iterable iterable = () -> changeQueue.iterator();
        Stream<ChangeStorage> storageStream = StreamSupport.stream(iterable.spliterator(), false);
        Optional<ChangeStorage> theStorage = storageStream.filter(storage -> storage.isOwner(player)).findFirst();
        if (theStorage.isPresent()) {
            Manager.addToQueue(new TickedWorldOperation(theStorage.get(), player));
            changeQueue.remove(theStorage.get());
        }
    }

    public static UUID getServerUUID() {
        if (serverUUID == null) {
            return Manager.generateOrRetrieveUUID();
        }
        return serverUUID;
    }

    private static UUID generateOrRetrieveUUID() {
        DimensionSavedDataManager storage = ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x();
        UUIDStorage instance = (UUIDStorage)storage.func_215752_a(UUIDStorage::new, "structurize_UUID");
        if (serverUUID == null) {
            Manager.setServerUUID(UUID.randomUUID());
            Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
        }
        storage.func_215757_a((WorldSavedData)instance);
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }
}

