/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.network.messages.BuildToolPasteMessage;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.network.messages.MultiBlockChangeMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.ldtteam.structurize.network.messages.UndoMessage;
import com.ldtteam.structurize.network.messages.UpdatePlaceholderBlockMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("structurize", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        int idx = 0;
        this.registerMessage(++idx, MultiBlockChangeMessage.class);
        this.registerMessage(++idx, BuildToolPasteMessage.class);
        this.registerMessage(++idx, GenerateAndPasteMessage.class);
        this.registerMessage(++idx, LSStructureDisplayerMessage.class);
        this.registerMessage(++idx, RemoveBlockMessage.class);
        this.registerMessage(++idx, RemoveEntityMessage.class);
        this.registerMessage(++idx, SaveScanMessage.class);
        this.registerMessage(++idx, ReplaceBlockMessage.class);
        this.registerMessage(++idx, ScanOnServerMessage.class);
        this.registerMessage(++idx, SchematicRequestMessage.class);
        this.registerMessage(++idx, SchematicSaveMessage.class);
        this.registerMessage(++idx, ServerUUIDMessage.class);
        this.registerMessage(++idx, StructurizeStylesMessage.class);
        this.registerMessage(++idx, UndoMessage.class);
        this.registerMessage(++idx, UpdateScanToolMessage.class);
        this.registerMessage(++idx, UpdatePlaceholderBlockMessage.class);
        this.registerMessage(++idx, AddRemoveTagMessage.class);
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz) {
        this.rawChannel.registerMessage(id, msgClazz, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> {
            try {
                IMessage msg = (IMessage)msgClazz.newInstance();
                msg.fromBytes((PacketBuffer)buf);
                return msg;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            if (msg.getExecutionSide() != null && packetOrigin.equals((Object)msg.getExecutionSide())) {
                Log.getLogger().warn("Receving {} at wrong side!", (Object)msg.getClass().getName());
                return;
            }
            ctx.enqueueWork(() -> msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToServer(IMessage msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(IMessage msg, ServerPlayerEntity player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToEveryone(IMessage msg) {
        this.rawChannel.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingChunk(IMessage msg, Chunk chunk) {
        this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }
}

