/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPasteMessage
implements IMessage {
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, Rotation rotation, boolean isHut, Mirror mirror, boolean complete) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation.ordinal();
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.structureName = buf.func_150789_c(Short.MAX_VALUE);
        this.workOrderName = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.structureName);
        buf.func_180714_a(this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        StructureName sn = new StructureName(this.structureName);
        if (!Structures.hasMD5(sn)) {
            ctxIn.getSender().func_145747_a((ITextComponent)new StringTextComponent("Can not build " + this.workOrderName + ": schematic missing!"), ctxIn.getSender().func_110124_au());
            return;
        }
        if (ctxIn.getSender().func_184812_l_()) {
            StructurePlacementUtils.loadAndPlaceStructureWithRotation(ctxIn.getSender().field_70170_p, this.structureName, this.pos, Rotation.values()[this.rotation], this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, ctxIn.getSender());
        }
    }
}

