/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeStructureHandler
extends AbstractStructureHandler {
    public boolean fancyPlacement;

    public CreativeStructureHandler(World world, BlockPos pos, String structureName, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, structureName, settings);
        this.fancyPlacement = fancyPlacement;
    }

    public CreativeStructureHandler(World world, BlockPos pos, Blueprint blueprint, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, blueprint, settings);
        this.fancyPlacement = fancyPlacement;
    }

    @Override
    @Nullable
    public IItemHandler getInventory() {
        return null;
    }

    @Override
    public void triggerSuccess(BlockPos pos, List<ItemStack> requiredItems, boolean placement) {
    }

    @Override
    public int getMaxBlocksCheckedPerCall() {
        return (Integer)Structurize.getConfig().getCommon().maxOperationsPerTick.get();
    }

    @Override
    public boolean isStackFree(@Nullable ItemStack stack) {
        return true;
    }

    @Override
    public boolean allowReplace() {
        return true;
    }

    @Override
    public ItemStack getHeldItem() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !blockState.func_185904_a().func_76220_a();
    }

    @Override
    public boolean fancyPlacement() {
        return this.fancyPlacement;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    @Override
    public int getStepsPerCall() {
        return (Integer)Structurize.getConfig().getCommon().maxOperationsPerTick.get();
    }

    @Override
    public boolean shouldBlocksBeConsideredEqual(BlockState state, BlockState state1) {
        return false;
    }

    @Override
    public boolean hasRequiredItems(@NotNull List<ItemStack> requiredItems) {
        return true;
    }

    @Override
    public void prePlacementLogic(BlockPos worldPos, BlockState blockState) {
    }

    @Override
    public BlockState getSolidBlockForPos(BlockPos worldPos) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.getWorld(), worldPos);
    }
}

