/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DaylightDetectorBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BedItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;

public final class BlockUtils {
    @NotNull
    public static final List<BiPredicate<Block, BlockState>> FREE_TO_PLACE_BLOCKS = Arrays.asList((block, iBlockState) -> block.equals(Blocks.field_150350_a), (block, iBlockState) -> iBlockState.func_185904_a().func_76224_d(), (block, iBlockState) -> BlockUtils.isWater(block.func_176223_P()), (block, iBlockState) -> block instanceof LeavesBlock, (block, iBlockState) -> block instanceof DoublePlantBlock, (block, iBlockState) -> block.equals(Blocks.field_150349_c), (block, iBlockState) -> block instanceof DoorBlock && iBlockState != null && (Boolean)iBlockState.func_177229_b((Property)BooleanProperty.func_177716_a((String)"upper")) != false);

    private BlockUtils() {
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getRotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static BlockState getSubstitutionBlockAtWorld(@NotNull World world, @NotNull BlockPos location) {
        BlockState filler = world.func_226691_t_(location).func_203944_q().func_204108_a();
        if (filler.func_177230_c() == Blocks.field_150354_m) {
            return Blocks.field_150322_A.func_176223_P();
        }
        if (filler.func_177230_c() instanceof FallingBlock) {
            return Blocks.field_150346_d.func_176223_P();
        }
        return filler;
    }

    public static boolean isWater(BlockState iBlockState) {
        return iBlockState.func_177230_c() == Blocks.field_150355_j;
    }

    private static Item getItem(@NotNull BlockState forgeBlockState) {
        BlockState blockState = forgeBlockState;
        if (blockState.func_177230_c().equals(Blocks.field_150353_l)) {
            return Items.field_151129_at;
        }
        if (blockState.func_177230_c() instanceof BrewingStandBlock) {
            return Items.field_222088_mr;
        }
        if (blockState.func_177230_c() instanceof CakeBlock) {
            return Items.field_222070_lD;
        }
        if (blockState.func_177230_c() instanceof CauldronBlock) {
            return Items.field_222089_ms;
        }
        if (blockState.func_177230_c() instanceof CocoaBlock) {
            return Items.field_196130_bo;
        }
        if (blockState.func_177230_c() instanceof CropsBlock) {
            ItemStack stack = ((CropsBlock)blockState.func_177230_c()).func_185473_a(null, null, blockState);
            if (stack != null) {
                return stack.func_77973_b();
            }
            return Items.field_151014_N;
        }
        if (blockState.func_177230_c() instanceof DaylightDetectorBlock) {
            return Item.func_150898_a((Block)Blocks.field_150453_bW);
        }
        if (blockState.func_177230_c() instanceof FarmlandBlock || blockState.func_177230_c() instanceof GrassPathBlock) {
            return Item.func_150898_a((Block)Blocks.field_150346_d);
        }
        if (blockState.func_177230_c() instanceof FireBlock) {
            return Items.field_151033_d;
        }
        if (blockState.func_177230_c() instanceof FlowerPotBlock) {
            return Items.field_222087_nH;
        }
        if (blockState.func_177230_c() instanceof FurnaceBlock) {
            return Item.func_150898_a((Block)Blocks.field_150460_al);
        }
        if (blockState.func_177230_c() instanceof NetherWartBlock) {
            return Items.field_151075_bm;
        }
        if (blockState.func_177230_c() instanceof RedstoneTorchBlock) {
            return Item.func_150898_a((Block)Blocks.field_150429_aA);
        }
        if (blockState.func_177230_c() instanceof RedstoneWireBlock) {
            return Items.field_151137_ax;
        }
        if (blockState.func_177230_c() instanceof SkullBlock) {
            return Items.field_196182_dv;
        }
        if (blockState.func_177230_c() instanceof StemBlock) {
            if (blockState.func_177230_c() == Blocks.field_150423_aK) {
                return Items.field_151080_bb;
            }
            return blockState.func_177230_c() == Blocks.field_150440_ba ? Items.field_151081_bc : null;
        }
        if (blockState.func_177230_c() == Blocks.field_222404_kP) {
            return Items.field_222068_kQ;
        }
        return (Item)GameData.getBlockItemMap().get(blockState.func_177230_c());
    }

    public static boolean areBlockStatesEqual(BlockState blockState1, BlockState blockState2, Predicate<BlockState> shallReplace, boolean fancy, BiPredicate<BlockState, BlockState> specialEqualRule) {
        if (blockState1 == null || blockState2 == null) {
            return true;
        }
        Block block1 = blockState1.func_177230_c();
        Block block2 = blockState2.func_177230_c();
        if (fancy) {
            if (block1 == ModBlocks.blockSubstitution || blockState2.equals(blockState1) || block2 == ModBlocks.blockSubstitution) {
                return true;
            }
            if (block1 == ModBlocks.blockSolidSubstitution && !shallReplace.test(blockState2) || block2 == ModBlocks.blockSolidSubstitution && !shallReplace.test(blockState1)) {
                return true;
            }
        }
        return specialEqualRule.test(blockState1, blockState2);
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_190931_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            return Blocks.field_150355_j.func_176223_P();
        }
        if (stack.func_77973_b() == Items.field_151129_at) {
            return Blocks.field_150353_l.func_176223_P();
        }
        return stack.func_77973_b() instanceof BlockItem ? ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P() : Blocks.field_150340_R.func_176223_P();
    }

    public static ItemStack getItemStackFromBlockState(@NotNull BlockState blockState) {
        if (blockState.func_177230_c() instanceof IFluidBlock) {
            return FluidUtil.getFilledBucket((FluidStack)new FluidStack(((IFluidBlock)blockState.func_177230_c()).getFluid(), 1000));
        }
        Item item = BlockUtils.getItem(blockState);
        if (item != Items.field_190931_a && item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
    }

    public static void handleCorrectBlockPlacement(World world, FakePlayer fakePlayer, ItemStack itemStack, BlockState blockState, BlockPos here) {
        BlockState transformation;
        Direction facing;
        ItemStack stackToPlace = itemStack.func_77946_l();
        stackToPlace.func_190920_e(stackToPlace.func_77976_d());
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stackToPlace);
        if (stackToPlace.func_77973_b().func_206844_a((ITag)ItemTags.field_219771_F) && blockState.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
            fakePlayer.field_70177_z = ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176736_b() * 90;
        }
        Direction direction = facing = itemStack.func_77973_b() instanceof BedItem ? Direction.UP : Direction.NORTH;
        if (stackToPlace.func_77973_b() instanceof BlockItem && !(((BlockItem)stackToPlace.func_77973_b()).func_179223_d() instanceof AbstractButtonBlock)) {
            world.func_180501_a(here, ((BlockItem)stackToPlace.func_77973_b()).func_179223_d().func_196258_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), facing, here, true)))), 2);
        } else {
            world.func_217377_a(here, false);
            ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), facing, here, true)));
        }
        BlockState newBlockState = world.func_180495_p(here);
        if (newBlockState.func_177230_c() instanceof AbstractButtonBlock && blockState.func_177230_c() instanceof AbstractButtonBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)AbstractButtonBlock.field_196366_M, blockState.func_177229_b((Property)AbstractButtonBlock.field_196366_M));
            world.func_180501_a(here, transformation, 2);
        }
        if (newBlockState.func_177230_c() instanceof FourWayBlock && blockState.func_177230_c() instanceof FourWayBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)FourWayBlock.field_196411_b, blockState.func_177229_b((Property)FourWayBlock.field_196411_b));
            transformation = (BlockState)transformation.func_206870_a((Property)FourWayBlock.field_196409_a, blockState.func_177229_b((Property)FourWayBlock.field_196409_a));
            transformation = (BlockState)transformation.func_206870_a((Property)FourWayBlock.field_196414_y, blockState.func_177229_b((Property)FourWayBlock.field_196414_y));
            transformation = (BlockState)transformation.func_206870_a((Property)FourWayBlock.field_196413_c, blockState.func_177229_b((Property)FourWayBlock.field_196413_c));
            transformation = (BlockState)transformation.func_206870_a((Property)FourWayBlock.field_204514_u, blockState.func_177229_b((Property)FourWayBlock.field_204514_u));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof SixWayBlock && blockState.func_177230_c() instanceof SixWayBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)SixWayBlock.field_196490_b, blockState.func_177229_b((Property)SixWayBlock.field_196490_b));
            transformation = (BlockState)transformation.func_206870_a((Property)SixWayBlock.field_196488_a, blockState.func_177229_b((Property)SixWayBlock.field_196488_a));
            transformation = (BlockState)transformation.func_206870_a((Property)SixWayBlock.field_196495_y, blockState.func_177229_b((Property)SixWayBlock.field_196495_y));
            transformation = (BlockState)transformation.func_206870_a((Property)SixWayBlock.field_196492_c, blockState.func_177229_b((Property)SixWayBlock.field_196492_c));
            transformation = (BlockState)transformation.func_206870_a((Property)SixWayBlock.field_196496_z, blockState.func_177229_b((Property)SixWayBlock.field_196496_z));
            transformation = (BlockState)transformation.func_206870_a((Property)SixWayBlock.field_196489_A, blockState.func_177229_b((Property)SixWayBlock.field_196489_A));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof BlockTimberFrame && blockState.func_177230_c() instanceof BlockTimberFrame) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)BlockTimberFrame.FACING, blockState.func_177229_b((Property)BlockTimberFrame.FACING));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof StairsBlock && blockState.func_177230_c() instanceof StairsBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)StairsBlock.field_176309_a, blockState.func_177229_b((Property)StairsBlock.field_176309_a));
            transformation = (BlockState)transformation.func_206870_a((Property)StairsBlock.field_176308_b, blockState.func_177229_b((Property)StairsBlock.field_176308_b));
            transformation = (BlockState)transformation.func_206870_a((Property)StairsBlock.field_176310_M, blockState.func_177229_b((Property)StairsBlock.field_176310_M));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof HorizontalBlock && blockState.func_177230_c() instanceof HorizontalBlock && !(blockState.func_177230_c() instanceof BedBlock)) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)HorizontalBlock.field_185512_D, blockState.func_177229_b((Property)HorizontalBlock.field_185512_D));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof DirectionalBlock && blockState.func_177230_c() instanceof DirectionalBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)DirectionalBlock.field_176387_N, blockState.func_177229_b((Property)DirectionalBlock.field_176387_N));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof SlabBlock && blockState.func_177230_c() instanceof SlabBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)SlabBlock.field_196505_a, blockState.func_177229_b((Property)SlabBlock.field_196505_a));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof RotatedPillarBlock && blockState.func_177230_c() instanceof RotatedPillarBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof TrapDoorBlock && blockState.func_177230_c() instanceof TrapDoorBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)TrapDoorBlock.field_176285_M, blockState.func_177229_b((Property)TrapDoorBlock.field_176285_M));
            transformation = (BlockState)transformation.func_206870_a((Property)TrapDoorBlock.field_185512_D, blockState.func_177229_b((Property)TrapDoorBlock.field_185512_D));
            transformation = (BlockState)transformation.func_206870_a((Property)TrapDoorBlock.field_176283_b, blockState.func_177229_b((Property)TrapDoorBlock.field_176283_b));
            world.func_180501_a(here, transformation, 2);
        } else if (newBlockState.func_177230_c() instanceof DoorBlock && blockState.func_177230_c() instanceof DoorBlock) {
            transformation = (BlockState)newBlockState.func_206870_a((Property)DoorBlock.field_176520_a, blockState.func_177229_b((Property)DoorBlock.field_176520_a));
            world.func_180501_a(here, transformation, 2);
        } else if (stackToPlace.func_77973_b() == Items.field_151129_at) {
            world.func_180501_a(here, Blocks.field_150353_l.func_176223_P(), 2);
        } else if (stackToPlace.func_77973_b() == Items.field_151131_as) {
            world.func_180501_a(here, Blocks.field_150355_j.func_176223_P(), 2);
        }
    }

    public static void removeFluid(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((!(block instanceof IBucketPickupHandler) || ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, state) == Fluids.field_204541_a) && block instanceof FlowingFluidBlock) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public static List<ItemStack> getBlockDrops(@NotNull World world, @NotNull BlockPos coords, int fortune, ItemStack stack) {
        return world.func_180495_p(coords).func_215693_a(new LootContext.Builder((ServerWorld)world).func_186469_a((float)fortune).func_216015_a(LootParameters.field_216289_i, (Object)stack).func_216015_a(LootParameters.field_216286_f, (Object)coords));
    }
}

