/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;

public class FluidRenderer {
    public static boolean render(IBlockDisplayReader blockAccess, BlockPos pos, IVertexBuilder iVertexBuilder, FluidState fluidState) {
        float waterDepth;
        boolean isWaterEast;
        boolean isLava = fluidState.func_206884_a((ITag)FluidTags.field_206960_b);
        TextureAtlasSprite[] atextureatlassprite = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)blockAccess, (BlockPos)pos, (FluidState)fluidState);
        int color = fluidState.func_206886_c().getAttributes().getColor(blockAccess, pos);
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        boolean isWaterUp = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.UP, fluidState);
        boolean isWaterDown = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.DOWN, fluidState) && !FluidRenderer.needsSideRendering((IBlockReader)blockAccess, pos, Direction.DOWN, 0.8888889f);
        boolean isWaterNorth = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.NORTH, fluidState);
        boolean isWaterSouth = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.SOUTH, fluidState);
        boolean isWaterWest = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.WEST, fluidState);
        boolean bl = isWaterEast = !FluidRenderer.isAdjacentFluidSameAs((IBlockReader)blockAccess, pos, Direction.EAST, fluidState);
        if (!(isWaterUp || isWaterDown || isWaterEast || isWaterWest || isWaterNorth || isWaterSouth)) {
            return false;
        }
        boolean needDepthRendering = false;
        float fluidHeight = FluidRenderer.getFluidHeight((IBlockReader)blockAccess, pos, fluidState.func_206886_c());
        float fluidHeightS = FluidRenderer.getFluidHeight((IBlockReader)blockAccess, pos.func_177968_d(), fluidState.func_206886_c());
        float fluidHeightSE = FluidRenderer.getFluidHeight((IBlockReader)blockAccess, pos.func_177974_f().func_177968_d(), fluidState.func_206886_c());
        float fluidHeightE = FluidRenderer.getFluidHeight((IBlockReader)blockAccess, pos.func_177974_f(), fluidState.func_206886_c());
        float posX = pos.func_177958_n();
        float posY = pos.func_177956_o();
        float posZ = pos.func_177952_p();
        float f = waterDepth = isWaterDown ? 0.001f : 0.0f;
        if (isWaterUp && !FluidRenderer.needsSideRendering((IBlockReader)blockAccess, pos, Direction.UP, Math.min(Math.min(fluidHeight, fluidHeightS), Math.min(fluidHeightSE, fluidHeightE)))) {
            float f20;
            float f16;
            float f19;
            float f15;
            float f18;
            float f14;
            float f17;
            float f13;
            needDepthRendering = true;
            fluidHeight -= 0.001f;
            fluidHeightS -= 0.001f;
            fluidHeightSE -= 0.001f;
            fluidHeightE -= 0.001f;
            Vector3d vec3d = fluidState.func_215673_c((IBlockReader)blockAccess, pos);
            if (vec3d.field_72450_a == 0.0 && vec3d.field_72449_c == 0.0) {
                TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                f13 = textureatlassprite1.func_94214_a(0.0);
                f17 = textureatlassprite1.func_94207_b(0.0);
                f14 = f13;
                f18 = textureatlassprite1.func_94207_b(16.0);
                f15 = textureatlassprite1.func_94214_a(16.0);
                f19 = f18;
                f16 = f15;
                f20 = f17;
            } else {
                TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                float f21 = (float)MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) - 1.5707964f;
                float f22 = MathHelper.func_76126_a((float)f21) * 0.25f;
                float f23 = MathHelper.func_76134_b((float)f21) * 0.25f;
                f13 = textureatlassprite.func_94214_a((double)(8.0f + (-f23 - f22) * 16.0f));
                f17 = textureatlassprite.func_94207_b((double)(8.0f + (-f23 + f22) * 16.0f));
                f14 = textureatlassprite.func_94214_a((double)(8.0f + (-f23 + f22) * 16.0f));
                f18 = textureatlassprite.func_94207_b((double)(8.0f + (f23 + f22) * 16.0f));
                f15 = textureatlassprite.func_94214_a((double)(8.0f + (f23 + f22) * 16.0f));
                f19 = textureatlassprite.func_94207_b((double)(8.0f + (f23 - f22) * 16.0f));
                f16 = textureatlassprite.func_94214_a((double)(8.0f + (f23 - f22) * 16.0f));
                f20 = textureatlassprite.func_94207_b((double)(8.0f + (-f23 - f22) * 16.0f));
            }
            float f43 = (f13 + f14 + f15 + f16) / 4.0f;
            float f44 = (f17 + f18 + f19 + f20) / 4.0f;
            float f45 = (float)atextureatlassprite[0].func_94211_a() / (atextureatlassprite[0].func_94212_f() - atextureatlassprite[0].func_94209_e());
            float f46 = (float)atextureatlassprite[0].func_94216_b() / (atextureatlassprite[0].func_94210_h() - atextureatlassprite[0].func_94206_g());
            float f47 = 4.0f / Math.max(f46, f45);
            f13 = MathHelper.func_219799_g((float)f47, (float)f13, (float)f43);
            f14 = MathHelper.func_219799_g((float)f47, (float)f14, (float)f43);
            f15 = MathHelper.func_219799_g((float)f47, (float)f15, (float)f43);
            f16 = MathHelper.func_219799_g((float)f47, (float)f16, (float)f43);
            f17 = MathHelper.func_219799_g((float)f47, (float)f17, (float)f44);
            f18 = MathHelper.func_219799_g((float)f47, (float)f18, (float)f44);
            f19 = MathHelper.func_219799_g((float)f47, (float)f19, (float)f44);
            f20 = MathHelper.func_219799_g((float)f47, (float)f20, (float)f44);
            int j = FluidRenderer.getLight(blockAccess, pos);
            float f25 = 1.0f * red;
            float f26 = 1.0f * green;
            float f27 = 1.0f * blue;
            FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeight, posZ + 0.0f, f25, f26, f27, alpha, f13, f17, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeightS, posZ + 1.0f, f25, f26, f27, alpha, f14, f18, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightSE, posZ + 1.0f, f25, f26, f27, alpha, f15, f19, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightE, posZ + 0.0f, f25, f26, f27, alpha, f16, f20, j);
            if (fluidState.func_205586_a((IBlockReader)blockAccess, pos.func_177984_a())) {
                FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeight, posZ + 0.0f, f25, f26, f27, alpha, f13, f17, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightE, posZ + 0.0f, f25, f26, f27, alpha, f16, f20, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightSE, posZ + 1.0f, f25, f26, f27, alpha, f15, f19, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeightS, posZ + 1.0f, f25, f26, f27, alpha, f14, f18, j);
            }
        }
        if (isWaterDown) {
            float f34 = atextureatlassprite[0].func_94209_e();
            float f35 = atextureatlassprite[0].func_94212_f();
            float f37 = atextureatlassprite[0].func_94206_g();
            float f39 = atextureatlassprite[0].func_94210_h();
            int i1 = FluidRenderer.getLight(blockAccess, pos.func_177977_b());
            float f40 = 0.5f * red;
            float f41 = 0.5f * green;
            float f42 = 0.5f * blue;
            FluidRenderer.vertex(iVertexBuilder, posX, posY + waterDepth, posZ + 1.0f, f40, f41, f42, alpha, f34, f39, i1);
            FluidRenderer.vertex(iVertexBuilder, posX, posY + waterDepth, posZ, f40, f41, f42, alpha, f34, f37, i1);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + waterDepth, posZ, f40, f41, f42, alpha, f35, f37, i1);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + waterDepth, posZ + 1.0f, f40, f41, f42, alpha, f35, f39, i1);
            needDepthRendering = true;
        }
        for (int l = 0; l < 4; ++l) {
            Block block;
            boolean connectingWater;
            Direction direction;
            float offsetZ;
            float z;
            float offsetX;
            float x;
            float fHeight;
            float height;
            if (l == 0) {
                height = fluidHeight;
                fHeight = fluidHeightE;
                x = posX;
                offsetX = posX + 1.0f;
                z = posZ + 0.001f;
                offsetZ = posZ + 0.001f;
                direction = Direction.NORTH;
                connectingWater = isWaterNorth;
            } else if (l == 1) {
                height = fluidHeightSE;
                fHeight = fluidHeightS;
                x = posX + 1.0f;
                offsetX = posX;
                z = posZ + 1.0f - 0.001f;
                offsetZ = posZ + 1.0f - 0.001f;
                direction = Direction.SOUTH;
                connectingWater = isWaterSouth;
            } else if (l == 2) {
                height = fluidHeightS;
                fHeight = fluidHeight;
                x = posX + 0.001f;
                offsetX = posX + 0.001f;
                z = posZ + 1.0f;
                offsetZ = posZ;
                direction = Direction.WEST;
                connectingWater = isWaterWest;
            } else {
                height = fluidHeightE;
                fHeight = fluidHeightSE;
                x = posX + 1.0f - 0.001f;
                offsetX = posX + 1.0f - 0.001f;
                z = posZ;
                offsetZ = posZ + 1.0f;
                direction = Direction.EAST;
                connectingWater = isWaterEast;
            }
            if (!connectingWater || FluidRenderer.needsSideRendering((IBlockReader)blockAccess, pos, direction, Math.max(height, fHeight))) continue;
            needDepthRendering = true;
            BlockPos blockpos = pos.func_177972_a(direction);
            TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
            if (!isLava && ((block = blockAccess.func_180495_p(blockpos).func_177230_c()) == Blocks.field_150359_w || block instanceof StainedGlassBlock)) {
                textureatlassprite2 = ModelBakery.field_207769_g.func_229314_c_();
            }
            float f48 = textureatlassprite2.func_94214_a(0.0);
            float f49 = textureatlassprite2.func_94214_a(8.0);
            float f50 = textureatlassprite2.func_94207_b((double)((1.0f - height) * 16.0f * 0.5f));
            float f28 = textureatlassprite2.func_94207_b((double)((1.0f - fHeight) * 16.0f * 0.5f));
            float f29 = textureatlassprite2.func_94207_b(8.0);
            int k = FluidRenderer.getLight(blockAccess, blockpos);
            float f30 = l < 2 ? 0.8f : 0.6f;
            float r = 1.0f * f30 * red;
            float g = 1.0f * f30 * green;
            float b = 1.0f * f30 * blue;
            FluidRenderer.vertex(iVertexBuilder, x, posY + height, z, r, g, b, alpha, f48, f50, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + fHeight, offsetZ, r, g, b, alpha, f49, f28, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + waterDepth, offsetZ, r, g, b, alpha, f49, f29, k);
            FluidRenderer.vertex(iVertexBuilder, x, posY + waterDepth, z, r, g, b, alpha, f48, f29, k);
            if (textureatlassprite2 == ModelBakery.field_207769_g.func_229314_c_()) continue;
            FluidRenderer.vertex(iVertexBuilder, x, posY + waterDepth, z, r, g, b, alpha, f48, f29, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + waterDepth, offsetZ, r, g, b, alpha, f49, f29, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + fHeight, offsetZ, r, g, b, alpha, f49, f28, k);
            FluidRenderer.vertex(iVertexBuilder, x, posY + height, z, r, g, b, alpha, f48, f50, k);
        }
        return needDepthRendering;
    }

    private static boolean isAdjacentFluidSameAs(IBlockReader blockAccess, BlockPos pos, Direction direction, FluidState fluid) {
        BlockPos blockpos = pos.func_177972_a(direction);
        FluidState ifluidstate = blockAccess.func_204610_c(blockpos);
        return ifluidstate.func_206886_c().func_207187_a(fluid.func_206886_c());
    }

    private static void vertex(IVertexBuilder iVertexBuilder, float x, float y, float z, float red, float green, float blue, float alpha, float textX, float textY, int light) {
        iVertexBuilder.func_225582_a_((double)x, (double)y, (double)z).func_227885_a_(red, green, blue, alpha).func_225583_a_(textX, textY).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static int getLight(IBlockDisplayReader p_228795_1_, BlockPos p_228795_2_) {
        int i = WorldRenderer.func_228421_a_((IBlockDisplayReader)p_228795_1_, (BlockPos)p_228795_2_);
        int j = WorldRenderer.func_228421_a_((IBlockDisplayReader)p_228795_1_, (BlockPos)p_228795_2_.func_177984_a());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(i1, j1) << 16;
    }

    private static boolean needsSideRendering(IBlockReader blockAccess, BlockPos pos, Direction direction, float fluidHeight) {
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = blockAccess.func_180495_p(blockpos);
        if (blockstate.func_200132_m()) {
            VoxelShape voxelshape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidHeight, (double)1.0);
            VoxelShape voxelshape1 = blockstate.func_196951_e(blockAccess, blockpos);
            return VoxelShapes.func_197875_a((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)direction);
        }
        return false;
    }

    private static float getFluidHeight(IBlockReader blockAccess, BlockPos pos, Fluid fluid) {
        int occurances = 0;
        float totalHeight = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (blockAccess.func_204610_c(blockpos.func_177984_a()).func_206886_c().func_207187_a(fluid)) {
                return 1.0f;
            }
            FluidState ifluidstate = blockAccess.func_204610_c(blockpos);
            if (ifluidstate.func_206886_c().func_207187_a(fluid)) {
                float f1 = ifluidstate.func_215679_a(blockAccess, blockpos);
                if (f1 >= 0.8f) {
                    totalHeight += f1 * 10.0f;
                    occurances += 10;
                    continue;
                }
                totalHeight += f1;
                ++occurances;
                continue;
            }
            if (blockAccess.func_180495_p(blockpos).func_185904_a().func_76220_a()) continue;
            ++occurances;
        }
        return totalHeight / (float)occurances;
    }
}

