/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.field_190927_a;

    private ItemStackUtils() {
    }

    public static List<ItemStack> getItemStacksOfTileEntity(NBTTagCompound compound, World world) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)compound);
        if (tileEntity instanceof TileEntityFlowerPot) {
            items.add(((TileEntityFlowerPot)tileEntity).func_184403_b());
        } else if (tileEntity instanceof TileEntityLockable) {
            for (int i = 0; i < ((TileEntityLockable)tileEntity).func_70302_i_(); ++i) {
                ItemStack stack = ((TileEntityLockable)tileEntity).func_70301_a(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                items.add(stack);
            }
        } else if (tileEntity instanceof TileEntityBed) {
            items.add(new ItemStack(Items.field_151104_aV, 1, ((TileEntityBed)tileEntity).func_193048_a().func_176765_a()));
        } else if (tileEntity instanceof TileEntityBanner) {
            items.add(((TileEntityBanner)tileEntity).func_190615_l());
        }
        return items;
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack == EMPTY || stack.func_190916_E() <= 0;
    }

    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_190916_E();
    }
}

