/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.compat.optifine;

import com.ldtteam.structures.client.BlueprintTessellator;
import com.ldtteam.structurize.Structurize;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OptifineCompat {
    private static OptifineCompat ourInstance = new OptifineCompat();
    private Method isShadersEnabledMethod;
    private Method preRenderChunkLayerMethod;
    private Method postRenderChunkLayerMethod;
    private Method setupArrayPointersVboMethod;
    private Method calcNormalForLayerMethod;
    private Method beginUpdateChunksMethod;
    private Method endUpdateChunksMethod;
    private boolean currentShadowPassFieldValue = false;
    private Field isShadowPassField;
    private boolean enableOptifine = false;

    public static OptifineCompat getInstance() {
        return ourInstance;
    }

    private OptifineCompat() {
    }

    public void intialize() {
        try {
            this.setupReflectedMethodReferences();
            Structurize.getLogger().info("Optifine found. Enabling compat.");
            this.enableOptifine = true;
        }
        catch (ClassNotFoundException e) {
            Structurize.getLogger().info("Optifine not found. Disabling compat.");
            this.enableOptifine = false;
        }
        catch (NoSuchMethodException e) {
            Structurize.getLogger().error("Optifine found. But could not access related methods.", (Throwable)e);
            this.enableOptifine = false;
        }
        catch (NoSuchFieldException e) {
            Structurize.getLogger().error("Optifine found. But could not access related fields", (Throwable)e);
            this.enableOptifine = false;
        }
    }

    private void setupReflectedMethodReferences() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        Class<?> configClass = Class.forName("Config");
        Class<?> shaderRenderClass = Class.forName("net.optifine.shaders.ShadersRender");
        Class<?> sVertexBuilderClass = Class.forName("net.optifine.shaders.SVertexBuilder");
        Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
        this.isShadersEnabledMethod = configClass.getMethod("isShaders", new Class[0]);
        this.isShadersEnabledMethod.setAccessible(true);
        this.preRenderChunkLayerMethod = shaderRenderClass.getMethod("preRenderChunkLayer", BlockRenderLayer.class);
        this.preRenderChunkLayerMethod.setAccessible(true);
        this.postRenderChunkLayerMethod = shaderRenderClass.getMethod("postRenderChunkLayer", BlockRenderLayer.class);
        this.postRenderChunkLayerMethod.setAccessible(true);
        this.setupArrayPointersVboMethod = shaderRenderClass.getMethod("setupArrayPointersVbo", new Class[0]);
        this.setupArrayPointersVboMethod.setAccessible(true);
        this.calcNormalForLayerMethod = sVertexBuilderClass.getMethod("calcNormalChunkLayer", BufferBuilder.class);
        this.calcNormalForLayerMethod.setAccessible(true);
        this.beginUpdateChunksMethod = shadersClass.getMethod("beginUpdateChunks", new Class[0]);
        this.beginUpdateChunksMethod.setAccessible(true);
        this.endUpdateChunksMethod = shadersClass.getMethod("endUpdateChunks", new Class[0]);
        this.endUpdateChunksMethod.setAccessible(true);
        this.isShadowPassField = shadersClass.getField("isShadowPass");
        this.isShadowPassField.setAccessible(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void preBlueprintDraw() {
        if (!this.enableOptifine) {
            return;
        }
        try {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                this.currentShadowPassFieldValue = (Boolean)this.isShadowPassField.get(null);
                this.isShadowPassField.set(null, false);
                this.beginUpdateChunksMethod.invoke(null, new Object[0]);
                this.preRenderChunkLayerMethod.invoke(null, BlockRenderLayer.TRANSLUCENT);
            }
        }
        catch (IllegalAccessException e) {
            Structurize.getLogger().error("Failed to access Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
        catch (InvocationTargetException e) {
            Structurize.getLogger().error("Failed to invoke Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void postBlueprintDraw() {
        if (!this.enableOptifine) {
            return;
        }
        try {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                this.postRenderChunkLayerMethod.invoke(null, BlockRenderLayer.TRANSLUCENT);
                this.endUpdateChunksMethod.invoke(null, new Object[0]);
                this.isShadowPassField.set(null, this.currentShadowPassFieldValue);
            }
        }
        catch (IllegalAccessException e) {
            Structurize.getLogger().error("Failed to access Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
        catch (InvocationTargetException e) {
            Structurize.getLogger().error("Failed to invoke Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean setupArrayPointers() {
        if (!this.enableOptifine) {
            return false;
        }
        try {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                this.setupArrayPointersVboMethod.invoke(null, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException e) {
            Structurize.getLogger().error("Failed to access Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
        catch (InvocationTargetException e) {
            Structurize.getLogger().error("Failed to invoke Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void beforeBuilderUpload(BlueprintTessellator tessellator) {
        if (!this.enableOptifine) {
            return;
        }
        try {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                Structurize.getLogger().info("Recalculating normals in Optifine mode.");
                this.calcNormalForLayerMethod.invoke(null, tessellator.getBuilder());
            }
        }
        catch (IllegalAccessException e) {
            Structurize.getLogger().error("Failed to access Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
        catch (InvocationTargetException e) {
            Structurize.getLogger().error("Failed to invoke Optifine related rendering methods.", (Throwable)e);
            Structurize.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
    }
}

