/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.configuration.Configurations;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class StructureLoadingUtils {
    public static List<String> originFolders = new ArrayList<String>();

    private StructureLoadingUtils() {
    }

    @Nullable
    private static InputStream getStreamFromFolder(@Nullable File folder, String structureName) {
        if (folder == null) {
            return null;
        }
        File blueprintFile = new File(folder.getPath() + "/" + structureName + ".blueprint");
        try {
            if (folder.exists()) {
                if (!blueprintFile.toURI().normalize().getPath().startsWith(folder.toURI().normalize().getPath())) {
                    Log.getLogger().error("Structure: Illegal structure name \"" + structureName + "\"");
                    return null;
                }
                if (blueprintFile.exists()) {
                    return new FileInputStream(blueprintFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.getLogger().error("Structure.getStreamFromFolder", (Throwable)e);
        }
        return null;
    }

    private static List<InputStream> getStreamsFromJar(String structureName) {
        ArrayList<InputStream> streamsFromJar = new ArrayList<InputStream>();
        for (String origin : originFolders) {
            streamsFromJar.add(MinecraftServer.class.getResourceAsStream("/assets/" + origin + '/' + structureName + ".blueprint"));
        }
        return streamsFromJar;
    }

    public static byte[] getStreamAsByteArray(InputStream stream) {
        if (stream == null) {
            Log.getLogger().info("Structure.getStreamAsByteArray: stream is null this should not happen");
            return new byte[0];
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            Log.getLogger().trace((Object)e);
            return new byte[0];
        }
    }

    @Nullable
    public static InputStream getStream(String structureName) {
        InputStream inputstream;
        block5: {
            StructureName sn;
            block6: {
                block4: {
                    sn = new StructureName(structureName);
                    inputstream = null;
                    if (!"cache".equals(sn.getPrefix())) break block4;
                    for (File cachedFile : StructureLoadingUtils.getCachedSchematicsFolders()) {
                        InputStream stream = StructureLoadingUtils.getStreamFromFolder(cachedFile, structureName);
                        if (stream == null) continue;
                        return stream;
                    }
                    break block5;
                }
                if (!"scans".equals(sn.getPrefix())) break block6;
                for (File cachedFile : StructureLoadingUtils.getClientSchematicsFolders()) {
                    InputStream stream = StructureLoadingUtils.getStreamFromFolder(cachedFile, structureName);
                    if (stream == null) continue;
                    return stream;
                }
                break block5;
            }
            if (!"schematics".equals(sn.getPrefix())) {
                return null;
            }
            inputstream = StructureLoadingUtils.getStreamFromFolder(Structurize.proxy.getSchematicsFolder(), structureName);
            if (inputstream != null || Configurations.gameplay.ignoreSchematicsFromJar) break block5;
            for (InputStream stream : StructureLoadingUtils.getStreamsFromJar(structureName)) {
                if (stream == null) continue;
                inputstream = stream;
            }
        }
        return inputstream;
    }

    public static List<File> getCachedSchematicsFolders() {
        ArrayList<File> cachedSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                if (Manager.getServerUUID() != null) {
                    cachedSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin + "/" + Manager.getServerUUID()));
                    continue;
                }
                Log.getLogger().error("Manager.getServerUUID() => null this should not happen");
                return null;
            }
            cachedSchems.add(new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n() + "/" + "structurize"));
        }
        return cachedSchems;
    }

    public static List<File> getClientSchematicsFolders() {
        ArrayList<File> clientSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            clientSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin));
        }
        return clientSchems;
    }
}

