/*
 * Decompiled with CFR 0.152.
 */
package thut.api.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import thut.api.ThutBlocks;
import thut.api.maths.Vector3;

public abstract class BlockFluid
extends BlockFluidBase {
    public static List<Block> defaultReplacements = new ArrayList<Block>();
    public boolean solidifiable = false;

    public static void init() {
        defaultReplacements.add((Block)Blocks.field_150480_ab);
        defaultReplacements.add(Blocks.field_150433_aE);
        defaultReplacements.add(Blocks.field_150464_aj);
        defaultReplacements.add(Blocks.field_150442_at);
        defaultReplacements.add(Blocks.field_150448_aq);
        defaultReplacements.add(Blocks.field_150478_aa);
        defaultReplacements.add(Blocks.field_150318_D);
        defaultReplacements.add(Blocks.field_150319_E);
        defaultReplacements.add(Blocks.field_150469_bN);
        defaultReplacements.add(Blocks.field_150459_bM);
        defaultReplacements.add(Blocks.field_150392_bi);
        defaultReplacements.add(Blocks.field_150408_cc);
        defaultReplacements.add(Blocks.field_150321_G);
        defaultReplacements.add(Blocks.field_150395_bd);
        defaultReplacements.add(Blocks.field_150436_aH);
        defaultReplacements.add(Blocks.field_150473_bD);
        for (Block b : ThutBlocks.getAllBlocks()) {
            if (!(b instanceof BlockFlower) && !(b instanceof BlockSign) && !(b instanceof BlockRedstoneTorch) && !(b instanceof BlockLeaves) && !(b instanceof BlockRedstoneComparator) && !(b instanceof BlockStem) && !(b instanceof BlockCarpet) && !b.func_149688_o().func_76222_j()) continue;
            defaultReplacements.add(b);
        }
    }

    public BlockFluid(Fluid fluid, Material material) {
        super(fluid, material);
        FluidRegistry.registerFluid((Fluid)fluid);
        this.setQuantaPerBlock(16);
        if (fluid.getViscosity() == Integer.MAX_VALUE) {
            this.setRenderPass(0);
            this.func_149675_a(false);
        }
    }

    public int func_149660_a(World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int placeamount = 1;
        if (this.getFluid().getViscosity() < Integer.MAX_VALUE) {
            placeamount = 16;
        }
        return placeamount - 1;
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        ItemStack item = player.func_70694_bm();
        int meta = worldObj.func_72805_g(x, y, z);
        boolean ret = false;
        if (item != null) {
            Block itemID = Block.func_149634_a((Item)item.func_77973_b());
            int itemMeta = item.func_77960_j();
            Block id = worldObj.func_147439_a(x, y, z);
            if (id instanceof BlockFluid) {
                BlockFluid block = (BlockFluid)id;
                Vector3 vec = Vector3.getNewVectorFromPool().set(x, y, z);
                if (meta != 15 && itemID == this) {
                    ret = this.placedStack(worldObj, item, x, y, z, EnumFacing.func_82600_a((int)side), block, player);
                }
                vec.freeVectorFromPool();
            }
            if (!worldObj.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("" + meta));
            }
        }
        worldObj.field_72999_e = true;
        worldObj.func_147439_a(x, y, z).func_149674_a(worldObj, x, y, z, worldObj.field_73012_v);
        worldObj.field_72999_e = false;
        return ret;
    }

    public boolean placedStack(World worldObj, ItemStack stack, int x, int y, int z, EnumFacing side, BlockFluid block, EntityPlayer player) {
        Block id = worldObj.func_147439_a(x, y, z);
        Block id1 = worldObj.func_147439_a(x + side.func_82601_c(), y + side.func_96559_d(), z + side.func_82599_e());
        Block itemID = Block.func_149634_a((Item)stack.func_77973_b());
        if (itemID == null) {
            return false;
        }
        int meta = worldObj.func_72805_g(x, y, z);
        int meta1 = worldObj.func_72805_g(x + side.func_82601_c(), y + side.func_96559_d(), z + side.func_82599_e());
        int placementamount = 1;
        int initialamount = meta;
        int newMeta = placementamount + initialamount;
        int remainder = placementamount - (15 - meta);
        Block block1 = id1;
        if (id1 == Blocks.field_150350_a || block1.func_149688_o().func_76222_j()) {
            worldObj.func_147465_d(x, y, z, (Block)this, Math.min(newMeta, 15), 3);
            if (newMeta < 0) {
                worldObj.func_147465_d(x + side.func_82601_c(), y + side.func_96559_d(), z + side.func_82599_e(), itemID, remainder, 3);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77979_a(1);
            }
            return true;
        }
        return false;
    }

    public int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z)) {
            return 0;
        }
        if (!(world.func_147439_a(x, y, z) instanceof BlockFluid)) {
            return -1;
        }
        int quantaRemaining = world.func_72805_g(x, y, z) + 1;
        return quantaRemaining;
    }

    public boolean func_149678_a(int meta, boolean fullHit) {
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE || !this.func_149688_o().func_76222_j()) {
            return true;
        }
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    public int getMaxRenderHeightMeta() {
        return this.quantaPerBlock;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int n;
        int quanta;
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE) {
            return;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            Vector3 vec = Vector3.getNewVectorFromPool().set(x, y, z);
            Block block = vec.getBlock((IBlockAccess)world, dir);
            if (block.func_149653_t() && !world.func_147477_a(x, y, z, block)) {
                world.func_147464_a(vec.intX() + dir.func_82601_c(), vec.intY() + dir.func_96559_d(), vec.intZ() + dir.func_82599_e(), block, block.func_149738_a(world));
            }
            vec.freeVectorFromPool();
        }
        int original = quanta = this.getQuantaValue((IBlockAccess)world, x, y, z);
        if ((quanta = this.tryToFlowVerticallyInto(world, x, y, z, quanta)) <= 1) {
            if (original == quanta) {
                Vector3 vec = Vector3.getNewVectorFromPool().set(x, y, z);
                this.doHardenTick(world, vec);
                vec.freeVectorFromPool();
            }
            return;
        }
        if (this.displaceIfPossible(world, x, y, z - 1)) {
            world.func_147449_b(x, y, z - 1, Blocks.field_150350_a);
        }
        if (this.displaceIfPossible(world, x, y, z + 1)) {
            world.func_147449_b(x, y, z + 1, Blocks.field_150350_a);
        }
        if (this.displaceIfPossible(world, x - 1, y, z)) {
            world.func_147449_b(x - 1, y, z, Blocks.field_150350_a);
        }
        if (this.displaceIfPossible(world, x + 1, y, z)) {
            world.func_147449_b(x + 1, y, z, Blocks.field_150350_a);
        }
        int[] dir = new int[]{this.getQuantaValue((IBlockAccess)world, x, y, z - 1), this.getQuantaValue((IBlockAccess)world, x, y, z + 1), this.getQuantaValue((IBlockAccess)world, x - 1, y, z), this.getQuantaValue((IBlockAccess)world, x + 1, y, z)};
        for (int i = 0; i < 4; ++i) {
            if (dir[i] >= 0) continue;
            dir[i] = 16;
        }
        int[][] dirs = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}};
        int lowest = n = Math.abs(new Random().nextInt()) % 4;
        int low = 16;
        for (int i = 0; i < 4; ++i) {
            if (dir[(n + i) % 4] >= low) continue;
            lowest = (n + i) % 4;
            low = dir[(n + i) % 4];
        }
        boolean odd = (quanta + low) % 2 == 1;
        int diff = (quanta + low + (odd ? 1 : 0)) / 2 - low;
        if (low < 16 && diff > this.getFlowDifferential() && quanta != low) {
            dir = dirs[lowest];
            Vector3 from = Vector3.getNewVectorFromPool().set(x, y, z);
            Vector3 to = Vector3.getNewVectorFromPool().set(from).add(dir[0], 0.0, dir[1]);
            int oldMetaHere = quanta - 1;
            int oldMetaThere = low - 1;
            int newMetaHere = oldMetaHere - diff;
            int newMetaThere = oldMetaThere + diff;
            this.flowInto(world, from, to, newMetaThere, newMetaHere);
            quanta = newMetaHere + 1;
            to.freeVectorFromPool();
            from.freeVectorFromPool();
        }
        if (original == quanta) {
            Vector3 vec = Vector3.getNewVectorFromPool().set(x, y, z);
            this.doHardenTick(world, vec);
            vec.freeVectorFromPool();
        }
    }

    public int tryToFlowVerticallyInto(World world, int x, int y, int z, int amtToInput) {
        int otherY = y + this.densityDir;
        if (otherY < 0 || otherY >= world.func_72800_K()) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            return 0;
        }
        int amt = this.getQuantaValue((IBlockAccess)world, x, otherY, z);
        if (amt == this.quantaPerBlock) {
            return amtToInput;
        }
        if (amt >= 0) {
            Vector3 to = Vector3.getNewVectorFromPool().set(x, otherY, z);
            Vector3 from = Vector3.getNewVectorFromPool().set(x, y, z);
            to.y = otherY;
            int diff = 16 - amt;
            diff = Math.min(diff, amtToInput);
            int oldMetaHere = amtToInput - 1;
            int oldMetaThere = amt - 1;
            int newMetaHere = oldMetaHere - diff;
            int newMetaThere = oldMetaThere + diff;
            int[] dir = new int[]{this.getQuantaValue((IBlockAccess)world, x, otherY, z - 1), this.getQuantaValue((IBlockAccess)world, x, otherY, z + 1), this.getQuantaValue((IBlockAccess)world, x - 1, otherY, z), this.getQuantaValue((IBlockAccess)world, x + 1, otherY, z), this.getQuantaValue((IBlockAccess)world, x, otherY, z)};
            boolean sideways = false;
            for (int i = 0; i < 5; ++i) {
                if (dir[i] <= 0) continue;
                sideways = true;
            }
            this.flowInto(world, from, to, newMetaThere, newMetaHere, !sideways);
            to.freeVectorFromPool();
            from.freeVectorFromPool();
            return amtToInput -= diff;
        }
        int density_other = BlockFluid.getDensity((IBlockAccess)world, (int)x, (int)otherY, (int)z);
        if (density_other == Integer.MAX_VALUE) {
            if (this.displaceIfPossible(world, x, otherY, z)) {
                Vector3 to = Vector3.getNewVectorFromPool().set(x, otherY, z);
                Vector3 from = Vector3.getNewVectorFromPool().set(x, y, z);
                this.flowInto(world, from, to, amtToInput - 1, -1);
                to.freeVectorFromPool();
                from.freeVectorFromPool();
                return 0;
            }
            return amtToInput;
        }
        if (this.densityDir < 0) {
            if (density_other < this.density) {
                BlockFluidBase block = (BlockFluidBase)world.func_147439_a(x, otherY, z);
                int otherData = world.func_72805_g(x, otherY, z);
                world.func_147465_d(x, otherY, z, (Block)this, amtToInput - 1, 3);
                world.func_147465_d(x, y, z, (Block)block, otherData, 3);
                return 0;
            }
        } else if (density_other > this.density) {
            BlockFluidBase block = (BlockFluidBase)world.func_147439_a(x, otherY, z);
            int otherData = world.func_72805_g(x, otherY, z);
            world.func_147465_d(x, otherY, z, (Block)this, amtToInput - 1, 3);
            world.func_147465_d(x, y, z, (Block)block, otherData, 3);
            return 0;
        }
        return amtToInput;
    }

    public FluidStack drain(World world, int x, int y, int z, boolean doDrain) {
        if (doDrain) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
        return new FluidStack(this.getFluid(), MathHelper.func_76141_d((float)(this.getQuantaPercentage((IBlockAccess)world, x, y, z) * 1000.0f)));
    }

    public boolean canDrain(World world, int x, int y, int z) {
        return true;
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            return false;
        }
        if (defaultReplacements.contains(block)) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                return true;
            }
            return false;
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockFluid.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE && !material.func_76224_d()) {
            block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            return true;
        }
        return false;
    }

    public void flowInto(World world, Vector3 from, Vector3 to, int metaTo, int metaFrom) {
        this.flowInto(world, from, to, metaTo, metaFrom, false);
    }

    public void flowInto(World world, Vector3 from, Vector3 to, int metaTo, int metaFrom, boolean instant) {
        Fluid f;
        Object blockTo = to.getBlock((IBlockAccess)world);
        if (blockTo instanceof IFluidBlock && (f = ((IFluidBlock)blockTo).getFluid()).getTemperature() <= this.getFluid().getTemperature()) {
            blockTo = this;
        }
        if (instant) {
            to.setBlock(world, (Block)blockTo, metaTo, 2);
            world.field_72999_e = true;
            blockTo.func_149674_a(world, to.intX(), to.intY(), to.intZ(), world.field_73012_v);
            world.field_72999_e = false;
            if (metaFrom >= 0) {
                world.func_72921_c(from.intX(), from.intY(), from.intZ(), metaFrom, 3);
            } else {
                from.setAir(world);
            }
        } else {
            to.setBlock(world, (Block)blockTo, metaTo, 3);
            if (metaFrom >= 0) {
                world.func_72921_c(from.intX(), from.intY(), from.intZ(), metaFrom, 3);
            } else {
                from.setAir(world);
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (this.getFluid().getViscosity() != Integer.MAX_VALUE) {
            return false;
        }
        if (meta == 15) {
            return true;
        }
        return side == ForgeDirection.DOWN;
    }

    public AxisAlignedBB[] getBoxes(World worldObj, int x, int y, int z) {
        double[] heights = this.getCornerHeights((IBlockAccess)worldObj, x, y, z);
        double hN = (heights[0] + heights[3]) / 2.0;
        double hS = (heights[1] + heights[2]) / 2.0;
        double hE = (heights[2] + heights[3]) / 2.0;
        double hW = (heights[0] + heights[1]) / 2.0;
        double hM = (hN + hS + hE + hW) / 4.0;
        AxisAlignedBB NW = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)heights[0], (double)0.25).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NW1 = AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.0, (double)0.5, (double)hN, (double)0.25).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NW2 = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.25, (double)0.25, (double)hW, (double)0.5).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NW3 = AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.25, (double)0.5, (double)hM, (double)0.5).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NE = AxisAlignedBB.func_72330_a((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)heights[3], (double)0.25).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NE1 = AxisAlignedBB.func_72330_a((double)0.75, (double)0.0, (double)0.25, (double)1.0, (double)hE, (double)0.5).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NE2 = AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.0, (double)0.75, (double)hN, (double)0.25).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB NE3 = AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.25, (double)0.75, (double)hM, (double)0.5).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SW = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.75, (double)0.25, (double)heights[1], (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SW1 = AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.75, (double)0.5, (double)hS, (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SW2 = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.5, (double)0.25, (double)hW, (double)0.75).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SW3 = AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.5, (double)0.5, (double)hM, (double)0.75).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SE = AxisAlignedBB.func_72330_a((double)0.75, (double)0.0, (double)0.75, (double)1.0, (double)heights[2], (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SE1 = AxisAlignedBB.func_72330_a((double)0.75, (double)0.0, (double)0.5, (double)1.0, (double)hE, (double)0.75).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SE2 = AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.75, (double)0.75, (double)hS, (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        AxisAlignedBB SE3 = AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.5, (double)0.75, (double)hM, (double)0.75).func_72317_d((double)x, (double)y, (double)z);
        return new AxisAlignedBB[]{NW, NW1, NW2, NW3, NE, NE1, NE2, NE3, SW, SW1, SW2, SW3, SE, SE1, SE2, SE3};
    }

    public double[] getCornerHeights(IBlockAccess world, int x, int y, int z) {
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        float flow11 = this.getFluidHeightForCollision(world, x, y, z);
        if (flow11 != 1.0f) {
            float flow00 = this.getFluidHeightForCollision(world, x - 1, y, z - 1);
            float flow01 = this.getFluidHeightForCollision(world, x - 1, y, z);
            float flow02 = this.getFluidHeightForCollision(world, x - 1, y, z + 1);
            float flow10 = this.getFluidHeightForCollision(world, x, y, z - 1);
            float flow12 = this.getFluidHeightForCollision(world, x, y, z + 1);
            float flow20 = this.getFluidHeightForCollision(world, x + 1, y, z - 1);
            float flow21 = this.getFluidHeightForCollision(world, x + 1, y, z);
            float flow22 = this.getFluidHeightForCollision(world, x + 1, y, z + 1);
            heightNW = this.getFluidHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            heightSW = this.getFluidHeightAverage(new float[]{flow01, flow02, flow12, flow11});
            heightSE = this.getFluidHeightAverage(new float[]{flow12, flow21, flow22, flow11});
            heightNE = this.getFluidHeightAverage(new float[]{flow10, flow20, flow21, flow11});
        } else {
            heightNW = flow11;
            heightSW = flow11;
            heightSE = flow11;
            heightNE = flow11;
        }
        return new double[]{heightNW, heightSW, heightSE, heightNE};
    }

    public float getFluidHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        for (float aFlow : flow) {
            if (aFlow >= 1.0f) {
                return aFlow;
            }
            if (!(aFlow >= 0.0f)) continue;
            total += aFlow;
            ++count;
        }
        return total / (float)count;
    }

    public float getFluidHeightForCollision(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block id = world.func_147439_a(x, y, z);
        if (id instanceof BlockFluid) {
            if (world.func_147439_a(x, y + 1, z) instanceof BlockFluid) {
                return 1.0f;
            }
            if (meta == this.getMaxRenderHeightMeta()) {
                return 1.0f;
            }
            return (float)(meta + 1) / 16.0f;
        }
        return 0.0f;
    }

    public void func_149743_a(World worldObj, int x, int y, int z, AxisAlignedBB aaBB, List list, Entity par7Entity) {
        int l = worldObj.func_72805_g(x, y, z);
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE || !this.func_149688_o().func_76222_j()) {
            float f = 0.0625f;
            if (aaBB.func_72326_a(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)((float)l * f), (double)1.0).func_72317_d((double)x, (double)y, (double)z))) {
                list.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)((float)l * f), (double)1.0).func_72317_d((double)x, (double)y, (double)z));
            }
            return;
        }
        if (worldObj.func_72805_g(x, y, z) == 15) {
            if (aaBB.func_72326_a(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)x, (double)y, (double)z))) {
                list.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)x, (double)y, (double)z));
            }
            return;
        }
        for (AxisAlignedBB box : this.getBoxes(worldObj, x, y, z)) {
            if (!aaBB.func_72326_a(box)) continue;
            list.add(box);
        }
    }

    public AxisAlignedBB func_149668_a(World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        int l = par1World.func_72805_g(x, y, z);
        float f = 0.0625f;
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE || !this.func_149688_o().func_76222_j()) {
            AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(f * (float)l), (double)1.0);
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(f * (float)l), (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        }
        if (!Vector3.getNewVectorFromPool().set(x, y - 1, z).isFluid(par1World) && !par1World.func_147437_c(x, y - 1, z)) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((float)y + (float)l * f), (double)((double)z + this.field_149757_G));
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0).func_72317_d((double)x, (double)y, (double)z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World worldObj, int x, int y, int z) {
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE || !this.func_149688_o().func_76222_j()) {
            int l = worldObj.func_72805_g(x, y, z) + 1;
            float f = 0.0625f;
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(f * (float)l), (double)1.0).func_72317_d((double)x, (double)y, (double)z);
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)x, (double)y, (double)z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        float f = (float)(l + 1) / 16.0f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return p_149646_5_ == 0 && this.field_149760_C > 0.0 ? true : (p_149646_5_ == 1 && this.field_149756_F < 1.0 ? true : (p_149646_5_ == 2 && this.field_149754_D > 0.0 ? true : (p_149646_5_ == 3 && this.field_149757_G < 1.0 ? true : (p_149646_5_ == 4 && this.field_149759_B > 0.0 ? true : (p_149646_5_ == 5 && this.field_149755_E < 1.0 ? true : !p_149646_1_.func_147439_a(p_149646_2_, p_149646_3_, p_149646_4_).func_149662_c())))));
    }

    public void doHardenTick(World worldObj, Vector3 vec) {
    }

    public int func_149645_b() {
        return 0;
    }

    public int getFlowDifferential() {
        return 0;
    }

    public static class WetConcrete
    extends Material {
        public WetConcrete(MapColor par1MapColor) {
            super(par1MapColor);
        }

        public boolean func_76224_d() {
            return true;
        }

        public boolean func_76220_a() {
            return false;
        }

        public boolean func_76222_j() {
            return true;
        }

        public boolean func_76218_k() {
            return true;
        }

        public boolean func_76230_c() {
            return false;
        }
    }
}

