/*
 * Decompiled with CFR 0.152.
 */
package thut.api.blocks.multiparts;

import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ByteClassLoader
extends ClassLoader {
    String resName;
    Class superClass;
    private byte[] genericClassBytes;

    public ByteClassLoader(Class superClass) {
        super(superClass.getClassLoader());
        this.resName = superClass.getSimpleName() + ".class";
        this.superClass = superClass;
    }

    public Class<?> loadClass(String name, byte[] jarBytes, boolean resolve) throws ClassNotFoundException {
        name = name.replace("/", ".");
        Class<?> clazz = null;
        try {
            clazz = super.loadClass(name, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                byte[] bytes = jarBytes;
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            catch (Exception e) {
                clazz = super.loadClass(name, resolve);
            }
        }
        return clazz;
    }

    public Class<?> generateClass(String identifier, String ... args) throws ClassNotFoundException {
        try {
            InputStream is = this.superClass.getResourceAsStream(this.resName);
            ClassReader reader = new ClassReader(is);
            this.genericClassBytes = (byte[])reader.b.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassReader reader = new ClassReader(this.genericClassBytes);
        byte[] genericMob = (byte[])reader.b.clone();
        byte[] old = (byte[])genericMob.clone();
        ClassNode changer = new ClassNode();
        reader.accept((ClassVisitor)changer, 0);
        changer.sourceFile = changer.sourceFile.replace(".java", "") + identifier + ".java";
        changer.name = changer.name + identifier;
        ClassWriter writer = new ClassWriter(3);
        changer.accept((ClassVisitor)writer);
        writer.visitEnd();
        genericMob = writer.toByteArray();
        ClassReader cr = new ClassReader(genericMob);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        Class<?> c = this.loadClass(classNode.name, genericMob, true);
        return c;
    }
}

