/*
 * Decompiled with CFR 0.152.
 */
package thut.api.blocks.multiparts;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thut.api.blocks.BlockFluid;
import thut.api.blocks.multiparts.IPartMeta;

public class PartFluid
extends McMetaPart
implements IPartMeta {
    public String name;
    public Block block;
    protected boolean hasTile = false;
    public TileEntity tile;

    public PartFluid() {
    }

    public PartFluid(int meta) {
        this.meta = (byte)meta;
    }

    public Cuboid6 getBounds() {
        return this.getBounds(this.meta);
    }

    public Cuboid6 getBounds(int meta) {
        float f = (float)(meta + 1) / 16.0f;
        return new Cuboid6(0.0, 0.0, 0.0, 1.0, (double)f, 1.0);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        return this.doesTick() ? Collections.emptyList() : Arrays.asList(this.getBounds());
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public String getType() {
        return this.name;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        boolean activate;
        World world = this.world();
        if (world.field_72995_K) {
            return true;
        }
        BlockCoord pos = new BlockCoord(part.field_72311_b, part.field_72312_c, part.field_72309_d);
        if (this.tile != null) {
            this.tile.func_145834_a(world);
        }
        if (!(activate = this.block.func_149727_a(world, part.field_72311_b, part.field_72312_c, part.field_72309_d, player, part.field_72310_e, (float)part.field_72307_f.field_72450_a, (float)part.field_72307_f.field_72448_b, (float)part.field_72307_f.field_72449_c)) && item != null) {
            item.func_77973_b().func_77648_a(item, player, world, part.field_72311_b, part.field_72312_c, part.field_72309_d, part.field_72310_e, (float)part.field_72307_f.field_72450_a, (float)part.field_72307_f.field_72448_b, (float)part.field_72307_f.field_72449_c);
            this.sendDescUpdate();
        }
        return true;
    }

    public void update() {
        super.update();
        if (this.world().field_72995_K || Math.random() > 0.05) {
            return;
        }
        World world = this.world();
        TileMultipart thisTile = this.tile();
        BlockCoord pos = this.getPos();
        this.block.func_149674_a(world, thisTile.field_145851_c, thisTile.field_145848_d, thisTile.field_145849_e, world.field_73012_v);
    }

    public boolean doesTick() {
        return ((BlockFluid)this.block).getFluid().getViscosity() != Integer.MAX_VALUE;
    }

    public void onAdded() {
        super.onAdded();
    }

    public void onWorldJoin() {
        super.onWorldJoin();
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        if (this.hasTile && this.tile != null) {
            NBTTagCompound tetag = new NBTTagCompound();
            this.tile.func_145841_b(tetag);
            tag.func_74782_a("tetag", (NBTBase)tetag);
        }
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (this.hasTile && this.tile != null) {
            this.tile.func_145839_a(tag.func_74775_l("tetag"));
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        if (this.hasTile && this.tile != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tile.func_145841_b(tag);
            packet.writeNBTTagCompound(tag);
        }
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        if (this.hasTile && this.tile != null) {
            NBTTagCompound tag = packet.readNBTTagCompound();
            this.tile.func_145839_a(tag);
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return PartFluid.getFluidTile(this.world(), this.getPos());
    }

    public static boolean isFluid(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) instanceof BlockFluid) {
            return true;
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartFluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static TileEntity getFluidTile(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) instanceof BlockFluid) {
            return world.func_147438_o(pos.x, pos.y, pos.z);
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartFluid)) continue;
                PartFluid fluid = (PartFluid)p;
                Block b = fluid.getBlock();
                if (fluid.tile == null) {
                    fluid.tile = ((ITileEntityProvider)b).func_149915_a(world, 0);
                    fluid.tile.func_145834_a(world);
                }
                return fluid.tile;
            }
        }
        return null;
    }

    public static Block getBlock(World world, BlockCoord pos) {
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartFluid)) continue;
                PartFluid fluid = (PartFluid)p;
                return fluid.getBlock();
            }
        }
        return world.func_147439_a(pos.x, pos.y, pos.z);
    }
}

