/*
 * Decompiled with CFR 0.152.
 */
package thut.api.blocks.multiparts.parts;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thut.api.ThutBlocks;
import thut.api.blocks.IRebar;
import thut.api.blocks.multiparts.Content;

public class PartRebar
extends McMetaPart {
    public TileEntity te;

    public PartRebar() {
    }

    public PartRebar(int meta) {
        super(meta);
        if (this.getBlock() != null) {
            this.te = this.getBlock().createTileEntity(this.getWorld(), 0);
        }
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.35, 0.35, 0.35, 0.65, 0.65, 0.65);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> list = new ArrayList<Cuboid6>();
        if (this.getBlock() instanceof IRebar && this.tile() != null) {
            boolean[] sides = ((IRebar)this.getBlock()).sides((IBlockAccess)this.getWorld(), this.getPos().x, this.getPos().y, this.getPos().z);
            boolean none = !sides[0] && !sides[1] && !sides[2] && !sides[3] && !sides[4] && !sides[5];
            for (ForgeDirection fside : ForgeDirection.VALID_DIRECTIONS) {
                int n = fside.ordinal();
                if (!sides[n]) continue;
                list.add(this.getBoundingBoxForSide(fside));
            }
        } else {
            list.add(this.getBounds());
        }
        return list;
    }

    public Cuboid6 getBoundingBoxForSide(ForgeDirection fside) {
        switch (fside) {
            case UP: {
                return new Cuboid6((double)0.35f, (double)0.4f, (double)0.35f, (double)0.65f, (double)0.95f, (double)0.65f);
            }
            case DOWN: {
                return new Cuboid6((double)0.35f, (double)0.05f, (double)0.35f, (double)0.65f, (double)0.6f, (double)0.65f);
            }
            case NORTH: {
                return new Cuboid6((double)0.35f, (double)0.35f, (double)0.05f, (double)0.65f, (double)0.65f, (double)0.6f);
            }
            case SOUTH: {
                return new Cuboid6((double)0.35f, (double)0.35f, (double)0.4f, (double)0.65f, (double)0.65f, (double)0.95f);
            }
            case EAST: {
                return new Cuboid6((double)0.4f, (double)0.35f, (double)0.35f, (double)0.95f, (double)0.65f, (double)0.65f);
            }
            case WEST: {
                return new Cuboid6((double)0.05f, (double)0.35f, (double)0.35f, (double)0.605f, (double)0.65f, (double)0.65f);
            }
        }
        return new Cuboid6((double)0.05f, (double)0.05f, (double)0.05f, (double)0.95f, (double)0.95f, (double)0.95f);
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        NBTTagCompound teTag = new NBTTagCompound();
        if (this.te != null) {
            this.te.func_145841_b(teTag);
        }
        tag.func_74782_a("teTag", (NBTBase)teTag);
    }

    public static boolean isRebar(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) == ThutBlocks.liftRail) {
            return true;
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRebar)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        World world = this.world();
        if (world.field_72995_K) {
            return true;
        }
        BlockCoord pos = new BlockCoord(part.field_72311_b, part.field_72312_c, part.field_72309_d);
        this.getBlock().func_149727_a(world, part.field_72311_b, part.field_72312_c, part.field_72309_d, player, part.field_72310_e, (float)part.field_72307_f.field_72450_a, (float)part.field_72307_f.field_72448_b, (float)part.field_72307_f.field_72449_c);
        return true;
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (this.getBlock() != null) {
            this.te = this.getBlock().createTileEntity(this.getWorld(), (int)this.meta);
        }
        NBTTagCompound teTag = tag.func_74775_l("teTag");
        if (this.te != null) {
            this.te.func_145839_a(teTag);
        }
    }

    public Block getBlock() {
        for (Block b : Content.parts.keySet()) {
            if (Content.parts.get(b) != ((Object)((Object)this)).getClass()) continue;
            return b;
        }
        return null;
    }

    public String getType() {
        for (String s : Content.parts2.keySet()) {
            if (Content.parts2.get(s) != ((Object)((Object)this)).getClass()) continue;
            return s;
        }
        return null;
    }
}

