/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import thut.api.TickHandler;
import thut.api.maths.Cruncher;
import thut.api.maths.Vector3;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 31;
    public static Block melt;
    public static Block dust;
    World field_77287_j;
    Vector3 centre;
    float strength;
    public boolean meteor = false;
    EntityPlayer owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    Map<EntityLivingBase, Float> damages = new HashMap<EntityLivingBase, Float>();
    List<Chunk> affected = new ArrayList<Chunk>();
    static final boolean[] toClear;
    static final ExplosionCustom instance;
    public static final Vector<ExplosionStuff> explosions;
    private static final Thread boomThread;
    static HashMap<Integer, Vector<TickHandler.BlockChange>> blocks;

    public ExplosionCustom(World par1World, Entity par2Entity, double par3, double par5, double par7, float par9) {
        super(par1World, par2Entity, par3, par5, par7, par9);
        this.field_77287_j = par1World;
        this.strength = par9;
        this.centre = Vector3.getNewVectorFromPool().set(par3, par5, par7);
    }

    public ExplosionCustom(World par1World, Entity par2Entity, Vector3 center, float par9) {
        super(par1World, par2Entity, center.x, center.y, center.z, par9);
        this.field_77287_j = par1World;
        this.strength = par9;
        this.centre = center.copy();
        if (!toClear[1]) {
            ExplosionCustom.toClear[1] = true;
        }
    }

    public boolean canBreak(Vector3 location) {
        boolean ret = true;
        if (this.owner != null) {
            BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(location.intX(), location.intY(), location.intZ(), this.field_77287_j, location.getBlock((IBlockAccess)this.field_77287_j), location.getBlockMetadata((IBlockAccess)this.field_77287_j), this.owner);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.isCanceled()) {
                return false;
            }
        }
        return ret;
    }

    public ExplosionCustom setMeteor(boolean meteor) {
        this.meteor = meteor;
        return this;
    }

    public void doExplosion() {
        boolean shouldBoom = true;
        this.field_77287_j.func_72908_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, "random.explode", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_77280_f >= 2.0f && this.field_82755_b) {
            this.field_77287_j.func_72869_a("hugeexplosion", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        } else {
            this.field_77287_j.func_72869_a("largeexplode", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        }
        explosions.addElement(new ExplosionStuff(this, MAX_RADIUS, this.strength, this.field_77287_j, this.centre));
    }

    public void doKineticImpactor(World worldObj, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        this.field_77281_g.clear();
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        double eid = Math.random();
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(worldObj);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            this.destroyInRangeV4(hitLocation, worldObj, (int)Math.max(blast, 10.0f), blast, true, false);
            return;
        }
        Vector3 absorbedLoc = Vector3.getNewVectorFromPool();
        float remainingEnergy = 0.0f;
        int id = hitLocation.getBlockId((IBlockAccess)worldObj);
        density -= resist;
        while (energy > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            id = hitLocation.getBlockId((IBlockAccess)worldObj);
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(worldObj), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!worldObj.func_72873_a(source.intX(), source.intY(), source.intZ(), MAX_RADIUS) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, this.centre, strength);
                ExplosionStuff boom = new ExplosionStuff(boo, (int)Math.max(30.0f, strength / 2.0f), strength, worldObj, source);
                explosions.add(boom);
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            this.destroyInRangeV4(absorbedLoc, worldObj, 50, remainingEnergy, true, false);
        }
        absorbedLoc.freeVectorFromPool();
    }

    public void func_77278_a() {
        byte z;
        byte y;
        byte x;
        this.field_77281_g.clear();
        if (this.field_77287_j.field_72995_K) {
            return;
        }
        this.field_77287_j.field_72984_F.func_76320_a("explosion");
        long startTime = System.nanoTime();
        double scaleFactor = 1.0;
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        byte linearFactor = Cruncher.size;
        byte size = Cruncher.size;
        double x0 = this.centre.x;
        double y0 = this.centre.y;
        double z0 = this.centre.z;
        int radius = Math.min((int)Math.sqrt((double)this.strength * 1.0 / 0.25), Cruncher.size);
        double radSq = radius * radius;
        boolean n = false;
        boolean l = false;
        boolean g = false;
        boolean f = false;
        Vector3 r = Vector3.getNewVectorFromPool();
        Vector3 rAbs = Vector3.getNewVectorFromPool();
        Vector3 rHat = Vector3.getNewVectorFromPool();
        Vector3 rTest = Vector3.getNewVectorFromPool();
        Vector3 rTestPrev = Vector3.getNewVectorFromPool();
        Vector3 rTestAbs = Vector3.getNewVectorFromPool();
        this.damages.clear();
        this.affected.clear();
        this.targets.clear();
        HashSet map = new HashSet();
        ArrayList<Vector3> removed = new ArrayList<Vector3>();
        HashMap damps = new HashMap();
        BitSet blocked = new BitSet();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        HashMap resists = new HashMap();
        int count = 0;
        for (int i : Cruncher.locs) {
            int index;
            byte[] s = new byte[]{(byte)((i & 0xFF) - size), (byte)((i / 256 & 0xFF) - size), (byte)((i / 65536 & 0xFF) - size)};
            x = s[0];
            y = s[1];
            z = s[2];
            double rSq = x * x + y * y + z * z;
            if (rSq > radSq) continue;
            r.set(x, y, z);
            rAbs.set(r).addTo(this.centre);
            if (rAbs.isAir((IBlockAccess)this.field_77287_j) && (x != 0 || y != 0 || z != 0) || (double)rAbs.getExplosionResistance(this.field_77287_j) > (double)this.strength * 1.0 || !this.canBreak(rAbs) || blocked.get(index = Cruncher.getIndex(rHat = r.normalize(), linearFactor))) continue;
            boolean stop = false;
            rTest.clear();
            rTestPrev.clear();
            double rMag = r.mag();
            float dj = 1.0f;
            float resist = 0.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = rHat.scalarMult(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs = rTest.add(this.centre);
                    resist += rTestAbs.getExplosionResistance(this.field_77287_j);
                    if (!this.canBreak(rTestAbs)) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                    if ((double)resist > (double)this.strength * 1.0 / rTest.magSq()) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                }
                rTestPrev.set(rTest);
                j += dj;
            }
            if (stop) continue;
            toRemove.add(i);
            int id = rAbs.getBlockId((IBlockAccess)this.field_77287_j);
            if (counts.containsKey(id)) {
                counts.put(id, (Integer)counts.get(id) + 1);
                continue;
            }
            counts.put(id, 1);
            if (id == 0) continue;
            ++count;
        }
        int num1 = 0;
        for (int j = 0; j < toRemove.size(); ++j) {
            int i = (Integer)toRemove.get(j);
            byte[] s = new byte[]{(byte)((i & 0xFF) - size), (byte)((i / 256 & 0xFF) - size), (byte)((i / 65536 & 0xFF) - size)};
            x = s[0];
            y = s[1];
            z = s[2];
            r.set(x, y, z);
            rAbs.set(r).addTo(this.centre);
            Chunk chunk = this.field_77287_j.func_72938_d(rAbs.intX(), rAbs.intZ());
            if (!this.affected.contains(chunk)) {
                this.affected.add(chunk);
            }
            Block block = rAbs.getBlock((IBlockAccess)this.field_77287_j);
            if (this.meteor) {
                this.doMeteorStuff(block, rAbs);
            } else {
                TickHandler.addBlockChange(rAbs, this.field_77287_j, Blocks.field_150350_a);
                ++num1;
            }
            if (radius < 32 && block != null && block.func_149659_a((Explosion)this) && !this.meteor) {
                float num = counts.containsKey(Block.func_149682_b((Block)block)) ? (float)((Integer)counts.get(Block.func_149682_b((Block)block))).intValue() : 0.0f;
                num = num > 64.0f ? 64.0f / num : 1.0f;
                float chance = 1.0f * num;
                block.func_149690_a(this.field_77287_j, rAbs.intX(), rAbs.intY(), rAbs.intZ(), rAbs.getBlockMetadata((IBlockAccess)this.field_77287_j), chance, 0);
            }
            if (block != null) {
                block.func_149723_a(this.field_77287_j, rAbs.intX(), rAbs.intY(), rAbs.intZ(), (Explosion)this);
            }
            this.addChunkPosition(rAbs);
            this.field_77287_j.func_147471_g(rAbs.intX(), rAbs.intY(), rAbs.intZ());
        }
        this.field_77287_j.field_72984_F.func_76319_b();
        removed.clear();
        r.freeVectorFromPool();
        rAbs.freeVectorFromPool();
        rHat.freeVectorFromPool();
        rTest.freeVectorFromPool();
        rTestPrev.freeVectorFromPool();
        rTestAbs.freeVectorFromPool();
    }

    public void doMeteorStuff(Block destroyed, Vector3 location) {
        if (!this.meteor) {
            TickHandler.addBlockChange(location, this.field_77287_j, Blocks.field_150350_a);
        }
        float resistance = location.getExplosionResistance(this.field_77287_j);
        if (melt == null) {
            melt = Blocks.field_150350_a;
        }
        if (dust == null) {
            dust = Blocks.field_150350_a;
        }
        if (resistance > 2.0f && !location.getBlockMaterial((IBlockAccess)this.field_77287_j).func_76224_d()) {
            int meta = (int)Math.min(resistance / 2.0f, 15.0f);
            TickHandler.addBlockChange(location, this.field_77287_j, melt, meta);
        } else {
            TickHandler.addBlockChange(location, this.field_77287_j, dust);
        }
    }

    public void addChunkPosition(Vector3 v) {
        this.field_77281_g.add(new ChunkPosition(v.intX(), v.intY(), v.intZ()));
    }

    public void func_77279_a(boolean par1) {
        double radius = MAX_RADIUS;
        double scaleFactor = 10.0;
        List targets = this.field_77287_j.func_72839_b(this.field_77283_e, this.centre.getAABB().func_72314_b(radius, radius, radius));
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        Vector3 v = Vector3.getNewVectorFromPool();
        for (Entity e : targets) {
            if (!this.centre.isVisible(this.field_77287_j, v.set(e))) {
                toRemove.add(e);
                continue;
            }
            if (!(e instanceof EntityLivingBase) || this.damages.containsKey((EntityLivingBase)e) || e == this.field_77283_e) continue;
            EntityLivingBase ent = (EntityLivingBase)e;
            float damage = (float)((double)this.strength * scaleFactor / this.centre.distToSq(v.set(e)));
            this.damages.put(ent, Float.valueOf(damage));
        }
        for (Entity e : toRemove) {
            targets.remove(e);
        }
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (int i1 = 0; i1 < targets.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)targets.get(i1);
            double d4 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)this.field_77280_f;
            if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d6 + (d7 = entity.field_70161_v - this.field_77282_d) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            double d10 = this.field_77287_j.func_72842_a(vec3, entity.field_70121_D);
            double d11 = (1.0 - d4) * d10;
            if (!(entity instanceof EntityPlayer)) continue;
            Vec3 vec = Vec3.func_72443_a((double)(d5 * d11), (double)(d6 * d11), (double)(d7 * d11));
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (!(this.centre.distanceTo(v.set(entity)) < 4096.0)) continue;
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new S27PacketExplosion(this.centre.x, this.centre.y, this.centre.z, this.strength, this.field_77281_g, vec));
        }
        for (Chunk c : this.affected) {
            c.func_76630_e();
        }
        if (!this.field_77287_j.field_72995_K) {
            for (EntityLivingBase e : this.damages.keySet()) {
                if (!((double)this.damages.get(e).floatValue() > 0.1)) continue;
                ExplosionVictimTicker.victims.addElement(new VictimStuff((Entity)e, this.damages.get(e).floatValue(), this));
            }
        }
        v.freeVectorFromPool();
    }

    public void destroyInRangeV4(Vector3 centre, World worldObj, int radi, double strength, boolean dust, boolean drop) {
        byte z;
        byte y;
        byte x;
        worldObj.field_72984_F.func_76320_a("explosion");
        long startTime = System.nanoTime();
        double scaleFactor = 250.0;
        byte linearFactor = Cruncher.size;
        worldObj.field_72984_F.func_76320_a("explosion");
        int radius = Math.min((int)Math.sqrt(strength * 250.0 / 0.25), Math.min(radi, Cruncher.size));
        double radSq = radius * radius;
        boolean n = false;
        boolean l = false;
        boolean g = false;
        boolean f = false;
        Vector3 r = Vector3.getNewVectorFromPool();
        Vector3 rAbs = Vector3.getNewVectorFromPool();
        Vector3 rHat = Vector3.getNewVectorFromPool();
        Vector3 rTest = Vector3.getNewVectorFromPool();
        Vector3 rTestPrev = Vector3.getNewVectorFromPool();
        Vector3 rTestAbs = Vector3.getNewVectorFromPool();
        this.damages.clear();
        this.affected.clear();
        this.targets.clear();
        HashSet map = new HashSet();
        ArrayList<Vector3> removed = new ArrayList<Vector3>();
        HashMap damps = new HashMap();
        BitSet blocked = new BitSet();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        HashMap resists = new HashMap();
        for (int i : Cruncher.locs) {
            int index;
            byte[] s = new byte[]{(byte)((i & 0xFF) - Cruncher.size), (byte)((i / 256 & 0xFF) - Cruncher.size), (byte)((i / 65536 & 0xFF) - Cruncher.size)};
            x = s[0];
            y = s[1];
            z = s[2];
            double rSq = x * x + y * y + z * z;
            if (rSq > radSq) continue;
            r.set(x, y, z);
            rAbs.set(r).addTo(centre);
            if (rAbs.isAir((IBlockAccess)worldObj) && (x != 0 || y != 0 || z != 0) || (double)rAbs.getExplosionResistance(worldObj) > strength * 250.0 / r.magSq() || !this.canBreak(rAbs) || blocked.get(index = Cruncher.getIndex(rHat = r.normalize(), linearFactor))) continue;
            boolean stop = false;
            double rMag = r.mag();
            float dj = 1.0f;
            float resist = 0.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = rHat.scalarMult(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs = rTest.add(centre);
                    resist += rTestAbs.getExplosionResistance(worldObj);
                    if (!this.canBreak(rTestAbs)) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                    if ((double)resist > strength * 250.0 / r.magSq()) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                }
                rTestPrev.set(rTest);
                j += dj;
            }
            if (stop) continue;
            toRemove.add(i);
        }
        long estimatedTime = System.nanoTime() - startTime;
        boolean count = false;
        for (int j = 0; j < toRemove.size(); ++j) {
            int i = (Integer)toRemove.get(j);
            byte[] s = new byte[]{(byte)((i & 0xFF) - Cruncher.size), (byte)((i / 256 & 0xFF) - Cruncher.size), (byte)((i / 65536 & 0xFF) - Cruncher.size)};
            x = s[0];
            y = s[1];
            z = s[2];
            r.set(x, y, z);
            rAbs.set(r).addTo(centre);
            Chunk chunk = worldObj.func_72938_d(rAbs.intX(), rAbs.intZ());
            if (!this.affected.contains(chunk)) {
                this.affected.add(chunk);
            }
            Block block = rAbs.getBlock((IBlockAccess)worldObj);
            if (drop && radius < 32 && block != null && block.func_149659_a(null)) {
                block.func_149690_a(worldObj, rAbs.intX(), rAbs.intY(), rAbs.intZ(), rAbs.getBlockMetadata((IBlockAccess)worldObj), 1.0f, 0);
            }
            if (block != null) {
                block.func_149723_a(worldObj, rAbs.intX(), rAbs.intY(), rAbs.intZ(), null);
            }
            if (this.meteor) {
                this.doMeteorStuff(block, rAbs);
            } else {
                TickHandler.addBlockChange(rAbs, worldObj, Blocks.field_150350_a);
            }
            this.addChunkPosition(rAbs);
            worldObj.func_147471_g(rAbs.intX(), rAbs.intY(), rAbs.intZ());
        }
        for (Chunk c : this.affected) {
            c.func_76630_e();
        }
        worldObj.field_72984_F.func_76319_b();
        removed.clear();
        r.freeVectorFromPool();
        rAbs.freeVectorFromPool();
        rHat.freeVectorFromPool();
        rTest.freeVectorFromPool();
        rTestPrev.freeVectorFromPool();
        rTestAbs.freeVectorFromPool();
    }

    List<Integer> getRemovedBlocks(double radius, double strength, World worldObj, Vector3 centre) {
        byte z;
        byte y;
        byte x;
        double scaleFactor = 150.0;
        byte linearFactor = Cruncher.size;
        double radSq = radius * radius;
        boolean n = false;
        boolean l = false;
        boolean g = false;
        boolean f = false;
        Vector3 r = Vector3.getNewVectorFromPool();
        Vector3 rAbs = Vector3.getNewVectorFromPool();
        Vector3 rHat = Vector3.getNewVectorFromPool();
        Vector3 rTest = Vector3.getNewVectorFromPool();
        Vector3 rTestPrev = Vector3.getNewVectorFromPool();
        Vector3 rTestAbs = Vector3.getNewVectorFromPool();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        HashSet map = new HashSet();
        ArrayList<Vector3> removed = new ArrayList<Vector3>();
        HashMap damps = new HashMap();
        BitSet blocked = new BitSet();
        HashMap resists = new HashMap();
        for (int i : Cruncher.locs) {
            int index;
            byte[] s = new byte[]{(byte)((i & 0xFF) - Cruncher.size), (byte)((i / 256 & 0xFF) - Cruncher.size), (byte)((i / 65536 & 0xFF) - Cruncher.size)};
            x = s[0];
            y = s[1];
            z = s[2];
            double rSq = x * x + y * y + z * z;
            if (rSq > radSq) continue;
            r.set(x, y, z);
            rAbs = r.add(centre);
            if (rAbs.isAir((IBlockAccess)worldObj) && (x != 0 || y != 0 || z != 0) || (double)ExplosionCustom.getExplosionResistance(rAbs, worldObj) > strength * 150.0 / r.magSq() || !this.canBreak(rAbs) || blocked.get(index = Cruncher.getIndex(rHat = r.normalize(), linearFactor))) continue;
            boolean stop = false;
            double rMag = r.mag();
            float dj = 1.0f;
            float resist = 0.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = rHat.scalarMult(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs = rTest.add(centre);
                    resist += ExplosionCustom.getExplosionResistance(rTestAbs, worldObj);
                    if (!this.canBreak(rTestAbs)) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                    if ((double)resist > strength * 150.0 / r.magSq()) {
                        blocked.set(index);
                        removed.add(r);
                        stop = true;
                        break;
                    }
                }
                rTestPrev.set(rTest);
                j += dj;
            }
            if (stop) continue;
            toRemove.add(i);
        }
        boolean count = false;
        for (int j = 0; j < toRemove.size(); ++j) {
            int i = (Integer)toRemove.get(j);
            byte[] s = new byte[]{(byte)((i & 0xFF) - Cruncher.size), (byte)((i / 256 & 0xFF) - Cruncher.size), (byte)((i / 65536 & 0xFF) - Cruncher.size)};
            x = s[0];
            y = s[1];
            z = s[2];
            r.set(x, y, z);
            rAbs.set(r).addTo(centre);
            Chunk chunk = worldObj.func_72938_d(rAbs.intX(), rAbs.intZ());
            if (!this.affected.contains(chunk)) {
                this.affected.add(chunk);
            }
            Block block = ExplosionCustom.getBlock(rAbs, worldObj);
            this.doMeteorStuff(block, rAbs);
        }
        this.func_77279_a(false);
        r.freeVectorFromPool();
        rAbs.freeVectorFromPool();
        rHat.freeVectorFromPool();
        rTest.freeVectorFromPool();
        rTestPrev.freeVectorFromPool();
        rTestAbs.freeVectorFromPool();
        return toRemove;
    }

    public static void clearInstance() {
        blocks.clear();
        ExplosionCustom.toClear[0] = true;
    }

    private static ExplosionCustom getInstance() {
        return instance;
    }

    static Block getBlock(Vector3 location, World worldObj) {
        TickHandler.BlockChange b1 = new TickHandler.BlockChange(location, worldObj, null);
        ExplosionCustom.getInstance();
        for (TickHandler.BlockChange b : ExplosionCustom.getListForWorld(worldObj)) {
            if (!b.equals(b1)) continue;
            return b.blockTo;
        }
        return location.getBlock((IBlockAccess)worldObj);
    }

    static float getExplosionResistance(Vector3 location, World worldObj) {
        TickHandler.BlockChange b1 = new TickHandler.BlockChange(location, worldObj, null);
        ExplosionCustom.getInstance();
        for (TickHandler.BlockChange b : ExplosionCustom.getListForWorld(worldObj)) {
            if (!b.equals(b1)) continue;
            return b.blockTo.getExplosionResistance(null, worldObj, (int)b.location.x, (int)b.location.y, (int)b.location.z, 0.0, 0.0, 0.0);
        }
        return location.getExplosionResistance(worldObj);
    }

    public static void addBlockChange(Vector3 location, World worldObj, Block blockTo, int meta) {
        ExplosionCustom.addBlockChange(new TickHandler.BlockChange(location, worldObj, blockTo, meta), worldObj);
    }

    public static void addBlockChange(TickHandler.BlockChange b1, World worldObj) {
        if (b1.location.y > 255.0) {
            return;
        }
        ExplosionCustom.getInstance();
        for (TickHandler.BlockChange b : ExplosionCustom.getListForWorld(worldObj)) {
            if (!b.equals(b1)) continue;
            return;
        }
        ExplosionCustom.toClear[0] = false;
        ExplosionCustom.getInstance();
        ExplosionCustom.getListForWorld(worldObj).add(b1);
    }

    public static Vector<TickHandler.BlockChange> getListForWorld(World worldObj) {
        ExplosionCustom.getInstance();
        Vector<TickHandler.BlockChange> ret = blocks.get(worldObj.field_73011_w.field_76574_g);
        if (ret == null) {
            ret = new Vector();
            ExplosionCustom.getInstance();
            blocks.put(worldObj.field_73011_w.field_76574_g, ret);
        }
        return ret;
    }

    static {
        toClear = new boolean[]{false, false};
        instance = new ExplosionCustom(null, null, Vector3.getNewVectorFromPool(), 0.0f);
        explosions = new Vector();
        boomThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    boolean boomed = false;
                    if (explosions.size() > 0) {
                        ExplosionStuff boom = explosions.get(0);
                        boom.doBoom();
                        explosions.remove(0);
                        boomed = true;
                    }
                    if (toClear[0]) {
                        explosions.clear();
                        ExplosionCustom.toClear[0] = false;
                    }
                    if (boomed) continue;
                    try {
                        boomThread;
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        boomThread.setName("explosionThread");
        System.out.println("Starting explosion thread");
        boomThread.start();
        blocks = new HashMap();
    }

    public static class ExplosionVictimTicker {
        public static Vector<VictimStuff> victims = new Vector();
        private static HashSet toRemove = new HashSet();

        @SubscribeEvent
        public void tick(TickEvent.WorldTickEvent evt) {
            if (evt.phase == TickEvent.Phase.END) {
                for (VictimStuff v : victims) {
                    ExplosionVictimTicker.applyDamage(v);
                    toRemove.add(v);
                }
                victims.removeAll(toRemove);
                toRemove.clear();
            }
        }

        public static void applyDamage(VictimStuff v) {
            boolean damagePlayerTest = true;
            System.out.println(v.entity + " " + v.damage);
            if (v.entity != null && !v.entity.field_70128_L) {
                v.entity.func_70097_a(DamageSource.func_94539_a((Explosion)v.explosion), v.damage);
            }
        }
    }

    public static class VictimStuff {
        final Entity entity;
        final float damage;
        final Explosion explosion;

        public VictimStuff(Entity hit, float d, Explosion e) {
            this.entity = hit;
            this.damage = d;
            this.explosion = e;
        }

        public boolean equals(Object o) {
            if (o instanceof VictimStuff) {
                return ((VictimStuff)o).entity == this.entity;
            }
            return super.equals(o);
        }
    }

    public static class ExplosionStuff {
        final ExplosionCustom boom;
        final double radius;
        final double strength;
        final World worldObj;
        final Vector3 centre;

        public ExplosionStuff(ExplosionCustom boom, double radius, double strength, World worldObj, Vector3 centre) {
            this.boom = boom;
            this.radius = radius;
            this.strength = strength;
            this.worldObj = worldObj;
            this.centre = centre;
        }

        public void doBoom() {
            this.boom.getRemovedBlocks(this.radius, this.strength, this.worldObj, this.centre);
        }
    }
}

