/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import thut.api.maths.Cruncher;
import thut.api.maths.Matrix3;

public class Vector3 {
    public double x;
    public double y;
    public double z;
    public static final int length = 3;
    Vector3 v;
    Vector3 v1;
    Vector3 vHat;
    private static Vector3[] pool = new Vector3[100000];
    static int poolIndex = 0;
    public static final Vector3 secondAxis = Vector3.getNewVectorFromPool().set(0.0, 1.0, 0.0);
    public static final Vector3 secondAxisNeg = Vector3.getNewVectorFromPool().set(0.0, -1.0, 0.0);
    public static final Vector3 firstAxis = Vector3.getNewVectorFromPool().set(1.0, 0.0, 0.0);
    public static final Vector3 firstAxisNeg = Vector3.getNewVectorFromPool().set(-1.0, 0.0, 0.0);
    public static final Vector3 thirdAxis = Vector3.getNewVectorFromPool().set(0.0, 0.0, 1.0);
    public static final Vector3 thirdAxisNeg = Vector3.getNewVectorFromPool().set(0.0, 0.0, -1.0);
    public static final Vector3 empty = Vector3.getNewVectorFromPool();
    public static Vector3 vecMult = Vector3.getNewVectorFromPool();
    public static double[][] rotBox = new double[3][3];
    public static Map<String, Fluid> fluids;
    static Vector3 move1;
    static Vector3 move2;

    public Vector3() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector3 getNewVectorFromPool() {
        Vector3[] vector3Array = pool;
        synchronized (pool) {
            if (poolIndex > 0) {
                Vector3 ret = pool[poolIndex - 1];
                --poolIndex;
                if (ret != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return ret;
                }
                System.err.println("someone put null in the pool");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new Vector3();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeVectorFromPool() {
        Vector3[] vector3Array = pool;
        synchronized (pool) {
            if (poolIndex < pool.length - 1) {
                Vector3.pool[Vector3.poolIndex] = this;
                ++poolIndex;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private Vector3(double pitch, double yaw) {
        this.x = 1.0;
        this.y = Math.toRadians(pitch);
        this.z = Math.toRadians(yaw);
    }

    private Vector3(Vec3 vec) {
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
    }

    private Vector3(Entity e, boolean bool) {
        if (e != null && bool) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)(e.field_70131_O / 2.0f);
            this.z = e.field_70161_v;
        } else if (e != null) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)e.func_70047_e();
            this.z = e.field_70161_v;
        }
    }

    private Vector3(Object a, Object b) {
        this();
        Vector3 A = Vector3.getNewVectorFromPool().set(a);
        Vector3 B = Vector3.getNewVectorFromPool().set(b);
        this.set(B.subtract(A));
    }

    private Vector3(Object a) {
        this();
        this.set(a);
    }

    public void moveEntity(Entity e) {
        e.func_70107_b(this.x, this.y, this.z);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.z) || Double.isNaN(this.y);
    }

    public boolean isEmpty() {
        return this.x == 0.0 && this.z == 0.0 && this.y == 0.0;
    }

    public List<Entity> livingEntityAtPoint(World worldObj) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = worldObj.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e)) continue;
            ret.add(e);
        }
        return ret;
    }

    public List<Entity> livingEntityAtPointExcludingEntity(World worldObj, Entity entity) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = worldObj.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e) || e == entity) continue;
            ret.add(e);
        }
        return ret;
    }

    public void addVelocities(Entity e) {
        e.func_70024_g(this.x, this.y, this.z);
    }

    public void setVelocities(Entity e) {
        e.field_70159_w = this.x;
        e.field_70181_x = this.y;
        e.field_70179_y = this.z;
    }

    public boolean setBlockId(World worldObj, int id, int meta, int flag) {
        return this.setBlock(worldObj, Block.func_149729_e((int)id), meta, flag);
    }

    public boolean setBlock(World worldObj, Block id, int meta) {
        return this.setBlock(worldObj, id, meta, 3);
    }

    public boolean setBlock(World worldObj, Block id, int meta, int flag) {
        if (worldObj.func_72899_e(this.intX(), this.intY(), this.intZ())) {
            worldObj.func_147465_d(this.intX(), this.intY(), this.intZ(), id, meta, flag);
            return true;
        }
        return false;
    }

    public boolean doChunksExist(World world, int distance) {
        return world.func_72904_c(this.intX() - distance, this.intY() - distance, this.intZ() - distance, this.intX() + distance, this.intY() + distance, this.intZ() + distance);
    }

    public boolean setBlock(World worldObj, Block id) {
        return this.setBlock(worldObj, id, 0, 3);
    }

    public void setAir(World worldObj) {
        this.setBlock(worldObj, Blocks.field_150350_a);
    }

    public boolean inAABB(AxisAlignedBB aabb) {
        if (this.y >= aabb.field_72337_e || this.y <= aabb.field_72338_b) {
            return false;
        }
        if (this.z >= aabb.field_72334_f || this.z <= aabb.field_72339_c) {
            return false;
        }
        return !(this.x >= aabb.field_72336_d) && !(this.x <= aabb.field_72340_a);
    }

    public Vector3 offset(EnumFacing side) {
        return this.add(Vector3.getNewVectorFromPool().set(side));
    }

    public Vector3 offsetBy(EnumFacing side) {
        return this.addTo(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
    }

    public double distToEntity(Entity e) {
        return this.distanceTo(Vector3.entity(e));
    }

    public double distanceTo(Vector3 vec) {
        return this.subtract(vec).mag();
    }

    public boolean equals(Object vec) {
        if (!(vec instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)vec;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public boolean sameBlock(Vector3 vec) {
        return this.intX() == vec.intX() && this.intY() == vec.intY() && this.intZ() == vec.intZ();
    }

    public Vector3 set(Vector3 vec) {
        if (vec != null) {
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
        }
        return this;
    }

    public Vector3 set(EnumFacing dir) {
        this.x = dir.func_82601_c();
        this.y = dir.func_96559_d();
        this.z = dir.func_82599_e();
        return this;
    }

    public Vector3 set(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public double get(int i) {
        assert (i < 3);
        return i == 0 ? this.x : (i == 1 ? this.y : this.z);
    }

    public void set(int i, double j) {
        if (i == 0) {
            this.x = j;
        } else if (i == 1) {
            this.y = j;
        } else if (i == 2) {
            this.z = j;
        }
    }

    public void add(int i, double j) {
        if (i == 0) {
            this.x += j;
        } else if (i == 1) {
            this.y += j;
        } else if (i == 2) {
            this.z += j;
        }
    }

    public float getExplosionResistance(World worldObj) {
        Block block = this.getBlock((IBlockAccess)worldObj);
        if (block != null && !block.isAir((IBlockAccess)worldObj, this.intX(), this.intY(), this.intZ())) {
            return block.getExplosionResistance((Entity)null, worldObj, (int)this.x, (int)this.y, (int)this.z, 0.0, 0.0, 0.0);
        }
        return 0.0f;
    }

    public int intX() {
        return MathHelper.func_76128_c((double)this.x);
    }

    public int intY() {
        return MathHelper.func_76128_c((double)this.y);
    }

    public int intZ() {
        return MathHelper.func_76128_c((double)this.z);
    }

    public static Vector3 entity(Entity e) {
        if (e != null) {
            return Vector3.getNewVectorFromPool().set(e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
        }
        return null;
    }

    public static int Int(double x) {
        return MathHelper.func_76128_c((double)x);
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public Vector3 normalize() {
        double vmag = this.mag();
        if (this.vHat == null) {
            this.vHat = Vector3.getNewVectorFromPool();
        }
        if (vmag == 0.0) {
            return this.vHat.clear();
        }
        this.vHat.set(this).scalarMultBy(1.0 / vmag);
        return this.vHat;
    }

    public Vector3 toSpherical() {
        if (this.v == null) {
            this.v = Vector3.getNewVectorFromPool();
        }
        Vector3 vectorSpher = this.v;
        vectorSpher.x = this.mag();
        vectorSpher.y = Math.acos(this.get(1) / vectorSpher.x) - 1.5707963267948966;
        vectorSpher.z = Math.atan2(this.get(2), this.x);
        return vectorSpher;
    }

    public Vector3 horizonalPerp() {
        if (this.v == null) {
            this.v = Vector3.getNewVectorFromPool();
        }
        Vector3 vectorH = this.v.set(this.x, 0.0, this.z);
        return vectorH.rotateAboutLine(secondAxis, 1.5707963267948966, this.v).normalize();
    }

    public Vector3 add(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVectorFromPool();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) + vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 subtract(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVectorFromPool();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) - vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 addTo(Vector3 b) {
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public Vector3 subtractFrom(Vector3 b) {
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public double mag() {
        double vmag = Math.sqrt(this.magSq());
        return vmag;
    }

    public double magSq() {
        double vmag = 0.0;
        int i = 0;
        while (true) {
            if (i >= 3) break;
            vmag += this.get(i) * this.get(i);
            ++i;
        }
        return vmag;
    }

    public Vector3 scalarMult(double constant) {
        Vector3 newVector = Vector3.getNewVectorFromPool();
        int i = 0;
        while (true) {
            if (i >= 3) break;
            newVector.set(i, constant * this.get(i));
            ++i;
        }
        return newVector;
    }

    public Vector3 matrixMult(Matrix3 Matrix) {
        Vector3 newVect = vecMult.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newVect.add(i, Matrix.get(i).get(j) * this.get(j));
            }
        }
        return newVect;
    }

    public Vector3 rotateAboutLine(Vector3 line, double angle, Vector3 ret) {
        if (line.magSq() != 1.0) {
            line = line.normalize();
        }
        if (ret == null) {
            ret = Vector3.getNewVectorFromPool();
        }
        double[][] mat = rotBox;
        mat[0][0] = line.get(0) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[0][1] = line.get(0) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[0][2] = line.get(0) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][0] = line.get(1) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][1] = line.get(1) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[1][2] = line.get(1) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][0] = line.get(2) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][1] = line.get(2) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][2] = line.get(2) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        double x = this.x;
        double y = this.y;
        double z = this.z;
        ret.x = mat[0][0] * x + mat[0][1] * y + mat[0][2] * z;
        ret.y = mat[1][0] * x + mat[1][1] * y + mat[1][2] * z;
        ret.z = mat[2][0] * x + mat[2][1] * y + mat[2][2] * z;
        return ret;
    }

    public Vector3 rotateAboutAngles(double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        if (this.isEmpty() || pitch == 0.0 && yaw == 0.0) {
            return this;
        }
        temp.set(this);
        if (yaw != 0.0) {
            this.rotateAboutLine(secondAxis, yaw, temp);
        }
        if (pitch != 0.0) {
            this.rotateAboutLine(this.horizonalPerp(), pitch, temp);
        }
        if (temp.isNaN()) {
            return temp.clear();
        }
        return temp;
    }

    public static void rotateAboutAngles(Vector3[] points, double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        for (int i = 0; i < points.length; ++i) {
            points[i] = points[i].rotateAboutAngles(pitch, yaw, temp, temp1);
        }
    }

    public static double vectorDot(Vector3 vector1, Vector3 vector2) {
        double dot = 0.0;
        int i = 0;
        while (true) {
            if (i >= 3) break;
            dot += vector1.get(i) * vector2.get(i);
            ++i;
        }
        return dot;
    }

    public double dot(Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += this.get(i) * vector2.get(i);
        }
        return dot;
    }

    public static Vector3 findMidPoint(List<Vector3> points) {
        Vector3 mid = Vector3.getNewVectorFromPool();
        for (int j = 0; j < points.size(); ++j) {
            mid.addTo(points.get(j));
        }
        if (points.size() > 0) {
            mid.scalarMultBy(1.0 / (double)points.size());
        }
        return mid;
    }

    public double distTo(Vector3 pointB) {
        return this.subtract(pointB).mag();
    }

    public double distToSq(Vector3 pointB) {
        return this.subtract(pointB).magSq();
    }

    public Vector3 copy() {
        Vector3 newVector = Vector3.getNewVectorFromPool().set(this.x, this.y, this.z);
        return newVector;
    }

    public Vector3 setToVelocity(Entity e) {
        this.set(e.field_70159_w, e.field_70181_x, e.field_70179_y);
        return this;
    }

    public void writeToNBT(NBTTagCompound nbt, String tag) {
        nbt.func_74780_a(tag + "x", this.x);
        nbt.func_74780_a(tag + "y", this.y);
        nbt.func_74780_a(tag + "z", this.z);
    }

    public static Vector3 readFromNBT(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag + "x")) {
            return null;
        }
        Vector3 ret = Vector3.getNewVectorFromPool();
        ret.x = nbt.func_74769_h(tag + "x");
        ret.y = nbt.func_74769_h(tag + "y");
        ret.z = nbt.func_74769_h(tag + "z");
        return ret;
    }

    public void writeToBuff(ByteBuf data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
    }

    public static Vector3 readFromBuff(ByteBuf dat) {
        Vector3 ret = Vector3.getNewVectorFromPool();
        ret.x = dat.readDouble();
        ret.y = dat.readDouble();
        ret.z = dat.readDouble();
        return ret;
    }

    public Vector3 findNextSolidBlock(IBlockAccess worldObj, Vector3 direction, double range) {
        return Vector3.findNextSolidBlock(worldObj, this, direction, range);
    }

    public static Vector3 findNextSolidBlock(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        boolean n = false;
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        for (double i = 0.0; i < range; i += 1.0) {
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            if (ytest > 255.0) {
                return null;
            }
            if (Vector3.Int(xtest) != Vector3.Int(xprev) || Vector3.Int(ytest) != Vector3.Int(yprev) || Vector3.Int(ztest) != Vector3.Int(zprev)) {
                Vector3 test = Vector3.getNewVectorFromPool().set(xtest, ytest, ztest);
                Block block = worldObj.func_147439_a(Vector3.Int(xtest), Vector3.Int(ytest), Vector3.Int(ztest));
                boolean clear = test.clearOfBlocks(worldObj);
                if (!clear) {
                    return Vector3.getNewVectorFromPool().set(Vector3.Int(xtest), Vector3.Int(ytest), Vector3.Int(ztest));
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public static boolean isVisibleRange(World worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        boolean n = false;
        double closest = range;
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, (IBlockAccess)worldObj);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static Vector3 getNextSurfacePoint(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, worldObj);
            if (!check) {
                return Vector3.getNewVectorFromPool().set(xtest, ytest, ztest);
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public static Vector3 getNextSurfacePoint2(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        Vector3 temp = Vector3.getNewVectorFromPool();
        for (double i = 0.0; i < range; i += 0.5) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isNotSurfaceBlock((World)worldObj, temp.set(xtest, ytest, ztest));
            if (!check) {
                return Vector3.getNewVectorFromPool().set(xtest, ytest, ztest);
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public boolean isVisible(World world, Vector3 location) {
        Vector3 direction = location.subtract(this);
        double range = direction.mag();
        return Vector3.isVisibleRange(world, this, direction, range);
    }

    public static boolean isVisibleEntityFromEntity(Entity looker, Entity target) {
        if (looker == null || target == null) {
            return false;
        }
        Vector3 look = Vector3.entity(looker);
        Vector3 t = Vector3.entity(target);
        return Vector3.isVisibleRange(looker.field_70170_p, t, look, look.distanceTo(t));
    }

    public Entity firstEntityExcluding(double range, Vector3 direction, World worldObj, boolean effect, Entity excluded) {
        direction = direction.normalize();
        boolean n = false;
        double xprev = this.x;
        double yprev = this.y;
        double zprev = this.z;
        double blocked = 0.0;
        for (double i = 0.0; i < range; i += 0.0625) {
            int z0;
            int y0;
            int x0;
            List targets;
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = this.x + dx;
            double ytest = this.y + dy;
            double ztest = this.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, (IBlockAccess)worldObj);
            blocked = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (!check) break;
            if (effect && worldObj.field_72995_K) {
                worldObj.func_72869_a("flame", xtest, ytest, ztest, 0.0, 0.0, 0.0);
            }
            if (((int)xtest != (int)xprev || (int)ytest != (int)yprev || (int)ztest != (int)zprev) && (targets = worldObj.func_72839_b(excluded, AxisAlignedBB.func_72330_a((double)(x0 = xtest > 0.0 ? (int)xtest : (int)xtest - 1), (double)(y0 = ytest > 0.0 ? (int)ytest : (int)ytest - 1), (double)(z0 = ztest > 0.0 ? (int)ztest : (int)ztest - 1), (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)))) != null && targets.size() > 0) {
                ArrayList<Entity> ret = new ArrayList<Entity>();
                for (Entity e : targets) {
                    if (!(e instanceof EntityLivingBase) || e == excluded.field_70154_o || e == excluded.field_70153_n) continue;
                    ret.add(e);
                }
                if (ret != null && ret.size() > 0) {
                    return (Entity)ret.get(0);
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public boolean isClearOfBlocks(IBlockAccess worldObj) {
        boolean ret = false;
        Block b = worldObj.func_147439_a(this.intX(), this.intY(), this.intZ());
        ret = ret || this.isAir(worldObj);
        ret = ret || this.getBlockMaterial(worldObj).func_76224_d();
        boolean bl = ret = ret || this.getBlockMaterial(worldObj).func_76222_j();
        if (!ret) {
            ret = Vector3.isPointClearBlocks(this.x, this.y, this.z, worldObj);
        }
        return ret;
    }

    public boolean isEntityClearOfBlocks(IBlockAccess worldObj, Entity e) {
        int j;
        int i;
        boolean ret = false;
        if (this.v == null) {
            this.v = Vector3.getNewVectorFromPool();
        }
        if (this.v1 == null) {
            this.v1 = Vector3.getNewVectorFromPool();
        }
        this.v.set(this);
        ret = this.v.addTo(this.v1.set(0.0, e.field_70131_O, 0.0)).isClearOfBlocks(worldObj);
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && this.v.set(this).addTo(this.v1.set((float)i * e.field_70130_N / 2.0f, 0.0, (float)j * e.field_70130_N / 2.0f)).isClearOfBlocks(worldObj);
            }
        }
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && this.v.set(this).addTo(this.v1.set((float)i * e.field_70130_N / 2.0f, e.field_70131_O, (float)j * e.field_70130_N / 2.0f)).isClearOfBlocks(worldObj);
            }
        }
        return ret;
    }

    public static boolean isPointClearBlocks(double x, double y, double z, IBlockAccess worldObj) {
        int x0 = MathHelper.func_76128_c((double)x);
        int y0 = MathHelper.func_76128_c((double)y);
        int z0 = MathHelper.func_76128_c((double)z);
        Block block = worldObj.func_147439_a(x0, y0, z0);
        if (worldObj.func_147439_a(x0, y0, z0).func_149721_r()) {
            return false;
        }
        if (block == null || block == Blocks.field_150350_a || !block.func_149703_v()) {
            return true;
        }
        ArrayList aabbs = new ArrayList();
        Vector3 v = Vector3.getNewVectorFromPool().set(x, y, z);
        if (worldObj instanceof World) {
            block.func_149743_a((World)worldObj, x0, y0, z0, v.getAABB().func_72314_b(-0.03, -0.03, -0.03), aabbs, null);
        }
        v.freeVectorFromPool();
        if (aabbs.size() == 0) {
            return true;
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            if (y <= aabb.field_72337_e && y >= aabb.field_72338_b) {
                return false;
            }
            if (z <= aabb.field_72334_f && z >= aabb.field_72339_c) {
                return false;
            }
            if (!(x <= aabb.field_72336_d) || !(x >= aabb.field_72340_a)) continue;
            return false;
        }
        return true;
    }

    public boolean clearOfBlocks(IBlockAccess worldMap) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        Block block = worldMap.func_147439_a(x0, y0, z0);
        if (worldMap.func_147439_a(x0, y0, z0).func_149721_r()) {
            return false;
        }
        if (block == null || block == Blocks.field_150350_a || !block.func_149688_o().func_76230_c() || !block.func_149703_v()) {
            return true;
        }
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        if (worldMap instanceof World) {
            block.func_149743_a((World)worldMap, x0, y0, z0, AxisAlignedBB.func_72330_a((double)this.x, (double)this.y, (double)this.z, (double)this.x, (double)this.y, (double)this.z), aabbs, null);
        } else {
            aabbs.add(AxisAlignedBB.func_72330_a((double)((double)x0 + block.func_149704_x()), (double)((double)y0 + block.func_149665_z()), (double)((double)z0 + block.func_149706_B()), (double)((double)x0 + block.func_149753_y()), (double)((double)y0 + block.func_149669_A()), (double)((double)z0 + block.func_149693_C())));
        }
        if (aabbs.size() == 0) {
            return true;
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            if (this.y <= aabb.field_72337_e && this.y >= aabb.field_72338_b) {
                return false;
            }
            if (this.z <= aabb.field_72334_f && this.z >= aabb.field_72339_c) {
                return false;
            }
            if (!(this.x <= aabb.field_72336_d) || !(this.x >= aabb.field_72340_a)) continue;
            return false;
        }
        return true;
    }

    public boolean isPointClearOfEntity(double x, double y, double z, Entity e) {
        AxisAlignedBB aabb = e.field_70121_D;
        if (y <= aabb.field_72337_e && y >= aabb.field_72338_b) {
            return false;
        }
        if (z <= aabb.field_72334_f && z >= aabb.field_72339_c) {
            return false;
        }
        return !(x <= aabb.field_72336_d) || !(x >= aabb.field_72340_a);
    }

    public boolean isFluid(World world) {
        boolean ret = false;
        int id = this.getBlockId((IBlockAccess)world);
        int meta = this.getBlockMetadata((IBlockAccess)world);
        boolean fluidCheck = false;
        if (fluids == null) {
            fluids = FluidRegistry.getRegisteredFluids();
        }
        return ret;
    }

    public Vector3 clear() {
        return this.set(0.0, 0.0, 0.0);
    }

    public Block getBlock(IBlockAccess worldMap) {
        return worldMap.func_147439_a(this.intX(), this.intY(), this.intZ());
    }

    public Block getBlock(IBlockAccess worldObj, EnumFacing side) {
        return worldObj.func_147439_a(this.intX() + side.func_82601_c(), this.intY() + side.func_96559_d(), this.intZ() + side.func_82599_e());
    }

    public int getBlockId(IBlockAccess worldObj) {
        return Block.func_149682_b((Block)worldObj.func_147439_a(this.intX(), this.intY(), this.intZ()));
    }

    public int getBlockMetadata(IBlockAccess worldObj) {
        return worldObj.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public Material getBlockMaterial(IBlockAccess worldObj) {
        return worldObj.func_147439_a(this.intX(), this.intY(), this.intZ()).func_149688_o();
    }

    public boolean isAir(IBlockAccess worldObj) {
        if (worldObj instanceof World) {
            return worldObj.func_147439_a(this.intX(), this.intY(), this.intZ()) == null || this.getBlockMaterial(worldObj) == null || worldObj.func_147439_a(this.intX(), this.intY(), this.intZ()).isAir((IBlockAccess)((World)worldObj), this.intX(), this.intY(), this.intZ()) || this.getBlockMaterial(worldObj) == Material.field_151579_a;
        }
        return this.getBlockMaterial(worldObj) == null || this.getBlockMaterial(worldObj) == Material.field_151579_a;
    }

    public TileEntity getTileEntity(IBlockAccess worldObj) {
        return worldObj.func_147438_o(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess worldObj, EnumFacing side) {
        return worldObj.func_147438_o(this.intX() + side.func_82601_c(), this.intY() + side.func_96559_d(), this.intZ() + side.func_82599_e());
    }

    public void breakBlock(World worldObj, boolean drop) {
        if (this.getBlock((IBlockAccess)worldObj) != null) {
            worldObj.func_147480_a(this.intX(), this.intY(), this.intZ(), drop);
        }
    }

    public void breakBlock(World worldObj, int fortune, boolean drop) {
        if (this.getBlock((IBlockAccess)worldObj) != null) {
            if (drop) {
                this.getBlock((IBlockAccess)worldObj).func_149697_b(worldObj, this.intX(), this.intY(), this.intZ(), this.getBlockMetadata((IBlockAccess)worldObj), fortune);
            }
            worldObj.func_147480_a(this.intX(), this.intY(), this.intZ(), false);
        }
    }

    public boolean isSideSolid(IBlockAccess worldObj, EnumFacing side) {
        boolean ret = worldObj.isSideSolid(this.intX(), this.intY(), this.intZ(), this.fromEnum(side), false);
        return ret;
    }

    private ForgeDirection fromEnum(EnumFacing side) {
        switch (side) {
            case UP: {
                return ForgeDirection.UP;
            }
            case DOWN: {
                return ForgeDirection.DOWN;
            }
            case EAST: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.EAST;
            }
            case NORTH: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public List<Entity> firstEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World worldObj, Entity excluded) {
        direction = direction.normalize();
        boolean n = false;
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        double blocked = 0.0;
        Vector3 temp = Vector3.getNewVectorFromPool();
        for (double i = 0.0; i < (double)range; i += 0.0625) {
            double z0;
            double y0;
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, (IBlockAccess)worldObj);
            blocked = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (!check) break;
            double x0 = xtest > 0.0 ? (int)xtest : (int)xtest - 1;
            List targets = worldObj.func_72839_b(excluded, AxisAlignedBB.func_72330_a((double)(x0 - size), (double)((y0 = (double)(ytest > 0.0 ? (int)ytest : (int)ytest - 1)) - size), (double)((z0 = (double)(ztest > 0.0 ? (int)ztest : (int)ztest - 1)) - size), (double)(x0 + size), (double)(y0 + size), (double)(z0 + size)));
            if (targets != null && targets.size() > 0) {
                ArrayList<Entity> ret = new ArrayList<Entity>();
                for (Entity e : targets) {
                    if (!(e instanceof EntityLiving)) continue;
                    ret.add(e);
                }
                if (ret != null && ret.size() > 0) {
                    return ret;
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World worldObj, Entity excluded) {
        double dz;
        double ztest;
        double dy;
        double ytest;
        double dx;
        double xtest;
        boolean check;
        direction = direction.normalize();
        boolean n = false;
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Vector3 temp = Vector3.getNewVectorFromPool();
        for (double i = 0.0; i < (double)range && (check = Vector3.isPointClearBlocks(xtest = source.x + (dx = i * direction.x), ytest = source.y + (dy = i * direction.y), ztest = source.z + (dz = i * direction.z), (IBlockAccess)worldObj)); i += 0.0625) {
            double x0 = xtest;
            double y0 = ytest;
            double z0 = ztest;
            List targets = worldObj.func_72839_b(excluded, AxisAlignedBB.func_72330_a((double)(x0 - size), (double)(y0 - size), (double)(z0 - size), (double)(x0 + size), (double)(y0 + size), (double)(z0 + size)));
            if (targets == null || targets.size() <= 0) continue;
            for (Entity e : targets) {
                if (!(e instanceof EntityLivingBase) || ret.contains(e) || e == excluded.field_70153_n) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    public AxisAlignedBB getAABB() {
        return Matrix3.getAABB(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public void setBiome(BiomeGenBase biome, World worldObj) {
        int chunkZ;
        int x = this.intX();
        int z = this.intZ();
        Chunk chunk = worldObj.func_72938_d(x, z);
        byte[] biomes = chunk.func_76605_m();
        byte newBiome = (byte)biome.field_76756_M;
        int chunkX = Math.abs(x & 0xF);
        int point = chunkX + 16 * (chunkZ = Math.abs(z & 0xF));
        if (biomes[point] != newBiome) {
            biomes[point] = newBiome;
            chunk.func_76616_a(biomes);
            chunk.func_76630_e();
        }
    }

    public int getBiomeID(World worldObj) {
        return this.getBiome((World)worldObj).field_76756_M;
    }

    public BiomeGenBase getBiome(World worldObj) {
        return worldObj.func_72807_a(this.intX(), this.intZ());
    }

    public int getTopBlockY(World world) {
        int ret = world.func_72940_L();
        for (int i = world.func_72940_L(); i > 0; --i) {
            ret = i;
            if (!world.isSideSolid(this.intX(), i, this.intZ(), ForgeDirection.UP)) continue;
            return i;
        }
        return ret;
    }

    public Vector3 getTopBlockPos(World world) {
        int y = this.getTopBlockY(world);
        return Vector3.getNewVectorFromPool().set(this.intX(), y, this.intZ());
    }

    public int[] getMinMaxY(World world, int range) {
        int[] ret = new int[2];
        int minY = 255;
        int maxY = 0;
        boolean count = false;
        for (int i = 0; i < range; ++i) {
            for (int j = 0; j < range; ++j) {
                if (this.getMaxY(world, this.intX() + i, this.intZ() + j) < minY) {
                    minY = this.getMaxY(world, this.intX() + i, this.intZ() + j);
                }
                if (this.getMaxY(world, this.intX() + i, this.intZ() + j) <= maxY) continue;
                maxY = this.getMaxY(world, this.intX() + i, this.intZ() + j);
            }
        }
        ret[0] = minY;
        ret[1] = maxY;
        return ret;
    }

    public int getMaxY(World world) {
        return this.getMaxY(world, this.intX(), this.intZ());
    }

    public int getMaxY(World world, int x, int z) {
        Vector3 temp = Vector3.getNewVectorFromPool().set(x, this.y, z);
        int y = temp.getTopBlockY(world);
        if (Vector3.Int(y) == this.intY()) {
            return y;
        }
        while (Vector3.isNotSurfaceBlock(world, temp)) {
            temp.y = --y;
        }
        return y;
    }

    public boolean canSeeSky(World world) {
        return (double)this.getTopBlockY(world) <= this.y;
    }

    public boolean isOnSurface(World world) {
        return (double)this.getMaxY(world) <= this.y;
    }

    public int blockCount(World world, Block block, int range) {
        int ret = 0;
        if (this.v == null) {
            this.v = this.copy();
        }
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    Vector3 test = this.v.set(this).addTo(i, j, k);
                    if (test.getBlock((IBlockAccess)world) != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public int blockCount2(World world, Block block, int range) {
        int ret = 0;
        if (this.v == null) {
            this.v = this.copy();
        }
        for (int i = -range / 2; i <= range / 2; ++i) {
            for (int j = -range / 2; j <= range / 2; ++j) {
                for (int k = -range / 2; k <= range / 2; ++k) {
                    int i1 = MathHelper.func_76128_c((double)((double)this.intX() / 16.0));
                    int k1 = MathHelper.func_76128_c((double)((double)this.intZ() / 16.0));
                    int j1 = MathHelper.func_76128_c((double)((double)this.intY() / 16.0));
                    int i2 = MathHelper.func_76128_c((double)((double)(this.intX() + i) / 16.0));
                    int k2 = MathHelper.func_76128_c((double)((double)(this.intZ() + k) / 16.0));
                    int j2 = MathHelper.func_76128_c((double)((double)(this.intY() + j) / 16.0));
                    if (i1 != i2 || k1 != k2 || j1 != j2) continue;
                    this.v.set(this);
                    Vector3 test = this.v.addTo(i, j, k);
                    if (test.getBlock((IBlockAccess)world) != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public static boolean isNotSurfaceBlock(World world, Vector3 v) {
        Block b = v.getBlock((IBlockAccess)world);
        if (b instanceof IFluidBlock) {
            Fluid f = ((IFluidBlock)b).getFluid();
            return f.getViscosity() < Integer.MAX_VALUE;
        }
        boolean ret = (b == null || v.getBlockMaterial((IBlockAccess)world).func_76222_j() || v.isClearOfBlocks((IBlockAccess)world) || !b.func_149721_r() || b.isLeaves((IBlockAccess)world, v.intX(), v.intY(), v.intZ()) || b.isWood((IBlockAccess)world, v.intX(), v.intY(), v.intZ())) && v.y > 1.0;
        return ret;
    }

    public Vector3 add(double i, double j, double k) {
        return Vector3.getNewVectorFromPool().set(this.x + i, j + this.y, k + this.z);
    }

    public Vector3 addTo(double i, double j, double k) {
        this.x += i;
        this.y += j;
        this.z += k;
        return this;
    }

    public int getLightValue(World world) {
        return world.func_72957_l(this.intX(), this.intY(), this.intZ());
    }

    public static boolean movePointOutOfBlocks(Vector3 v, World world) {
        Vector3 v1 = move1.set(v);
        Vector3 v2 = move2.set(v);
        long start = System.nanoTime();
        if (!v.clearOfBlocks((IBlockAccess)world)) {
            long end;
            double time;
            int n = 0;
            block0: while (!v.clearOfBlocks((IBlockAccess)world)) {
                for (EnumFacing side : EnumFacing.values()) {
                    v2.set(v);
                    if (v.offsetBy(side).clearOfBlocks((IBlockAccess)world)) break block0;
                    v.set(v2);
                }
                boolean step = true;
                if (n < 3) {
                    v.offset(EnumFacing.UP);
                } else if (n < 6) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.NORTH);
                } else if (n < 9) {
                    if (!step) {
                        step = true;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.SOUTH);
                } else if (n < 12) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.EAST);
                } else if (n < 15) {
                    if (!step) {
                        step = true;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.WEST);
                } else if (n < 18) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.DOWN);
                }
                if (++n <= 24) continue;
                break;
            }
            if ((time = (double)(end = System.nanoTime() - start) / 1.0E9) > 0.001) {
                System.out.println("Took " + time + "s to check");
            }
            return v.clearOfBlocks((IBlockAccess)world);
        }
        return true;
    }

    public Vector3 scalarMultBy(double i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public Vector3 set(Object o) {
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            this.set(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        } else if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            this.set(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        } else if (o instanceof double[]) {
            double[] d = (double[])o;
            this.set(d[0], d[1], d[2]);
        } else if (o instanceof EnumFacing) {
            EnumFacing side = (EnumFacing)o;
            this.set(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
        } else if (o instanceof Vector3) {
            this.set((Vector3)o);
        } else if (o instanceof ChunkCoordinates) {
            ChunkCoordinates c = (ChunkCoordinates)o;
            this.set(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        } else if (o instanceof ICommandSender) {
            ICommandSender c = (ICommandSender)o;
            this.set(c.func_82114_b().field_71574_a, c.func_82114_b().field_71572_b, c.func_82114_b().field_71573_c);
        } else if (o instanceof PathPoint) {
            PathPoint p = (PathPoint)o;
            this.set(p.field_75839_a, p.field_75837_b, p.field_75838_c);
        } else if (o instanceof Vec3) {
            Vec3 p = (Vec3)o;
            this.set(p.field_72450_a, p.field_72448_b, p.field_72449_c);
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            this.set(p[0], p[1], p[2]);
        }
        return this;
    }

    public Vector3 set(Entity e, boolean b) {
        if (e != null && b) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)(e.field_70131_O / 2.0f);
            this.z = e.field_70161_v;
        } else if (e != null) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)e.func_70047_e();
            this.z = e.field_70161_v;
        }
        return this;
    }

    public Vector3 reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 findClosestVisibleObject(World world, boolean water, int sightDistance, Object matching) {
        int size = Math.min(sightDistance, Cruncher.size);
        BitSet blocked = new BitSet();
        ArrayList list = new ArrayList();
        Block seekingBlock = null;
        Class seekingClass = null;
        boolean isInterface = false;
        boolean blockList = false;
        if (matching instanceof Block) {
            seekingBlock = (Block)matching;
        }
        if (matching instanceof Class && (seekingClass = (Class)matching).isInterface()) {
            isInterface = true;
        }
        if (matching instanceof Collection && ((Collection)matching).toArray()[0] instanceof Block) {
            blockList = true;
            list.addAll((Collection)matching);
        }
        Vector3 r = Vector3.getNewVectorFromPool();
        Vector3 rAbs = Vector3.getNewVectorFromPool();
        Vector3 rHat = Vector3.getNewVectorFromPool();
        Vector3 rTest = Vector3.getNewVectorFromPool();
        Vector3 rTestPrev = Vector3.getNewVectorFromPool();
        Vector3 rTestAbs = Vector3.getNewVectorFromPool();
        Vector3 ret = Vector3.getNewVectorFromPool();
        block0: for (int i : Cruncher.locs) {
            int index;
            byte[] s = new byte[]{(byte)((i & 0xFF) - Cruncher.size), (byte)((i / 256 & 0xFF) - Cruncher.size), (byte)((i / 65536 & 0xFF) - Cruncher.size)};
            byte dx = s[0];
            byte dy = s[1];
            byte dz = s[2];
            r.set(dx, dy, dz);
            rAbs.set(r).addTo(this);
            rHat.set(r.normalize());
            if (r.mag() > (double)size || rAbs.isAir((IBlockAccess)world) && (dx != 0 || dy != 0 || dz != 0) || blocked.get(index = Cruncher.getIndex(rHat, Cruncher.size))) continue;
            boolean stop = false;
            rTest.clear();
            rTestPrev.clear();
            double rMag = r.mag();
            float dj = 1.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = rHat.scalarMult(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs.set(rTest).addTo(this);
                    Block b = rTestAbs.getBlock((IBlockAccess)world);
                    if (isInterface) {
                        list.clear();
                        for (Class<?> o : b.getClass().getInterfaces()) {
                            list.add(o);
                        }
                    }
                    if (seekingBlock != null && b == seekingBlock) {
                        ret.set(rTestAbs);
                        r.freeVectorFromPool();
                        rAbs.freeVectorFromPool();
                        rHat.freeVectorFromPool();
                        rTest.freeVectorFromPool();
                        rTestPrev.freeVectorFromPool();
                        rTestAbs.freeVectorFromPool();
                        return ret;
                    }
                    if (!isInterface && seekingClass != null && b.getClass().isAssignableFrom(seekingClass)) {
                        ret.set(rTestAbs);
                        r.freeVectorFromPool();
                        rAbs.freeVectorFromPool();
                        rHat.freeVectorFromPool();
                        rTest.freeVectorFromPool();
                        rTestPrev.freeVectorFromPool();
                        rTestAbs.freeVectorFromPool();
                        return ret;
                    }
                    if (seekingClass != null && list.contains(seekingClass)) {
                        ret.set(rTestAbs);
                        r.freeVectorFromPool();
                        rAbs.freeVectorFromPool();
                        rHat.freeVectorFromPool();
                        rTest.freeVectorFromPool();
                        rTestPrev.freeVectorFromPool();
                        rTestAbs.freeVectorFromPool();
                        return ret;
                    }
                    if (blockList && list.contains(b)) {
                        ret.set(rTestAbs);
                        r.freeVectorFromPool();
                        rAbs.freeVectorFromPool();
                        rHat.freeVectorFromPool();
                        rTest.freeVectorFromPool();
                        rTestPrev.freeVectorFromPool();
                        rTestAbs.freeVectorFromPool();
                        return ret;
                    }
                    if (!rTestAbs.isClearOfBlocks((IBlockAccess)world)) {
                        blocked.set(index);
                        continue block0;
                    }
                    if (!water && b.func_149688_o() == Material.field_151586_h) {
                        blocked.set(index);
                        continue block0;
                    }
                }
                j += dj;
            }
        }
        r.freeVectorFromPool();
        rAbs.freeVectorFromPool();
        rHat.freeVectorFromPool();
        rTest.freeVectorFromPool();
        rTestPrev.freeVectorFromPool();
        rTestAbs.freeVectorFromPool();
        ret.freeVectorFromPool();
        return null;
    }

    public boolean inMatBox(Matrix3 box) {
        Vector3 min = box.get(0);
        Vector3 max = box.get(1);
        boolean ycheck = false;
        boolean xcheck = false;
        boolean zcheck = false;
        if (this.y <= max.y && this.y >= min.y) {
            ycheck = true;
        }
        if (this.z <= max.z && this.z >= min.z) {
            zcheck = true;
        }
        if (this.x <= max.x && this.x >= min.x) {
            xcheck = true;
        }
        return ycheck && zcheck && xcheck;
    }

    static {
        move1 = Vector3.getNewVectorFromPool();
        move2 = Vector3.getNewVectorFromPool();
    }
}

