/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class Vector4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 1.0f;
    }

    public Vector4(double posX, double posY, double posZ, float w) {
        this.x = (float)posX;
        this.y = (float)posY;
        this.z = (float)posZ;
        this.w = w;
    }

    public Vector4(String toParse) {
        String[] vals = toParse.split(" ");
        if (vals.length == 4) {
            this.x = Float.parseFloat(vals[0]);
            this.y = Float.parseFloat(vals[1]);
            this.z = Float.parseFloat(vals[2]);
            this.w = Float.parseFloat(vals[3]);
        }
    }

    public Vector4 set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4 addAngles(Vector4 toAdd) {
        Vector4 ret = this.copy();
        Vector4 temp = new Vector4(toAdd.x, toAdd.y, toAdd.z, toAdd.w);
        if (Float.isNaN(temp.x) || Float.isNaN(temp.y) || Float.isNaN(temp.z)) {
            new Exception().printStackTrace();
        }
        temp.toQuaternion();
        ret.toQuaternion();
        return ret.add(temp).toAxisAngle();
    }

    public Vector4 add(Vector4 b) {
        Vector4 quat = new Vector4();
        quat.w = this.w * b.w - this.x * b.x - this.y * b.y - this.z * b.z;
        quat.x = b.w * this.x + b.x * this.w + b.y * this.z - b.z * this.y;
        quat.y = b.w * this.y + b.y * this.w + b.z * this.x - b.x * this.z;
        quat.z = b.w * this.z + b.z * this.w + b.x * this.y - b.y * this.x;
        return quat;
    }

    public Vector4 subtractAngles(Vector4 toAdd) {
        Vector4 temp = new Vector4(toAdd.x, toAdd.y, toAdd.z, -toAdd.w);
        return this.addAngles(temp);
    }

    public Vector4 scalarMult(float scalar) {
        Vector4 ret = new Vector4(this.x, this.y, this.z, this.w);
        ret.w = this.w * scalar;
        return ret;
    }

    public Vector4 copy() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public void glRotate() {
        GL11.glRotatef((float)this.w, (float)this.x, (float)this.y, (float)this.z);
    }

    public Vector4 toQuaternion() {
        double aw = Math.toRadians(this.w);
        float ax = this.x;
        float ay = this.y;
        float az = this.z;
        this.w = (float)Math.cos(aw / 2.0);
        this.x = (float)((double)ax * Math.sin(aw / 2.0));
        this.y = (float)((double)ay * Math.sin(aw / 2.0));
        this.z = (float)((double)az * Math.sin(aw / 2.0));
        return this;
    }

    public Vector4 normalize() {
        float s = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        s = (float)Math.sqrt(s);
        this.x /= s;
        this.y /= s;
        this.z /= s;
        this.w /= s;
        return this;
    }

    public Vector4 toAxisAngle() {
        float qw = this.w;
        float qx = this.x;
        float qy = this.y;
        float qz = this.z;
        this.w = (float)Math.toDegrees(2.0 * Math.acos(qw));
        float s = (float)Math.sqrt(1.0f - qw * qw);
        if (s == 0.0f) {
            System.err.println("Error " + this);
        }
        if (s > 1.0E-4f) {
            this.x = qx / s;
            this.y = qy / s;
            this.z = qz / s;
        }
        this.x = (float)((double)this.x / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.y = (float)((double)this.y / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.z = (float)((double)this.z / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        return this;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("x", this.x);
        nbt.func_74776_a("y", this.y);
        nbt.func_74776_a("z", this.z);
        nbt.func_74776_a("w", this.w);
    }

    public Vector4(Entity e) {
        this(e.field_70165_t, e.field_70163_u, e.field_70161_v, e.field_71093_bK);
    }

    public Vector4(NBTTagCompound nbt) {
        this();
        this.x = nbt.func_74760_g("x");
        this.y = nbt.func_74760_g("y");
        this.z = nbt.func_74760_g("z");
        this.w = nbt.func_74760_g("w");
    }

    public boolean withinDistance(float distance, Vector4 toCheck) {
        return (int)this.w == (int)toCheck.w && toCheck.x >= this.x - distance && toCheck.z >= this.z - distance && toCheck.y >= this.y - distance && toCheck.y <= this.y + distance && toCheck.x <= this.x + distance && toCheck.z <= this.z + distance;
    }

    public boolean isEmpty() {
        return this.x == 0.0f && this.z == 0.0f && this.y == 0.0f;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z + " w:" + this.w;
    }

    public String toIntString() {
        return "x:" + (int)this.x + " y:" + (int)this.y + " z:" + (int)this.z;
    }
}

