/*
 * Decompiled with CFR 0.152.
 */
package thut.concrete.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import org.lwjgl.opengl.GL11;
import thut.api.blocks.BlockFluid;
import thut.api.blocks.IRebar;
import thut.api.render.RenderIRebar;
import thut.concrete.client.render.RenderCuboid;
import thut.concrete.common.blocks.fluids.BlockLiquidREConcrete;
import thut.concrete.common.blocks.fluids.BlockREConcrete;

public class RenderFluid
implements ISimpleBlockRenderingHandler {
    public static final int ID = RenderingRegistry.getNextAvailableRenderId();
    RenderIRebar rebarRenderer = new RenderIRebar();
    static final float LIGHT_Y_NEG = 0.5f;
    static final float LIGHT_Y_POS = 1.0f;
    static final float LIGHT_XZ_NEG = 0.8f;
    static final float LIGHT_XZ_POS = 0.6f;
    static final double RENDER_OFFSET = 0.0;

    public float getFluidHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 1.0f) {
                return flow[i];
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        return total / (float)count;
    }

    public float getFluidHeightForRender(IBlockAccess world, int x, int y, int z, BlockFluid block) {
        int meta = world.func_72805_g(x, y, z);
        Block id = world.func_147439_a(x, y, z);
        if (id instanceof BlockFluid) {
            if (world.func_147439_a(x, y + 1, z) instanceof BlockFluid) {
                return 1.0f;
            }
            if (meta == 15) {
                return 1.0f;
            }
            return (float)(meta + 1) / 16.0f;
        }
        return 0.0f;
    }

    public float getOverLayHeightForRender(IBlockAccess world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        Block id = world.func_147439_a(x, y, z);
        if (world.func_147439_a(x, y, z) == block) {
            if (meta > 7 || world.func_147439_a(x, y + 1, z) == block) {
                return 1.0f;
            }
            if (meta == 0) {
                return 0.875f;
            }
            return 0.875f * (float)(8 - meta) / 8.0f;
        }
        return 0.0f;
    }

    public float getOverlayHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                return flow[i];
            }
            if (!(flow[i] > 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return total / (float)count;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean same;
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        if (!(block instanceof BlockFluid)) {
            return false;
        }
        int bMeta = world.func_72805_g(x, y, z);
        if (bMeta == 15) {
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (block instanceof IRebar) {
            BlockFluid blo;
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            IRebar b = (IRebar)block;
            boolean rebar = true;
            int meta = world.func_72805_g(x, y, z);
            boolean[] sides = b.sides(world, x, y, z);
            IIcon icon = block.func_149691_a(0, 0);
            if (block instanceof BlockLiquidREConcrete) {
                blo = (BlockLiquidREConcrete)block;
                icon = blo.theIcon;
                rebar = meta != 15;
            } else if (block instanceof BlockREConcrete) {
                blo = (BlockREConcrete)block;
                icon = ((BlockREConcrete)blo).theIcon;
                boolean bl = rebar = meta != 15;
            }
            if (rebar) {
                this.rebarRenderer.tessAddRebar(tessellator, icon, x, y, z, sides, true);
            }
            IIcon[] icons = new IIcon[6];
            for (int i = 0; i < 6; ++i) {
                icons[i] = block.func_149673_e(world, x, y, z, i);
            }
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        int color = block.func_149720_d(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        BlockFluid theFluid = (BlockFluid)block;
        boolean renderTop = world.func_147439_a(x, y + 1, z) != theFluid;
        boolean renderBottom = block.func_149646_a(world, x, y - 1, z, 0) && world.func_147439_a(x, y - 1, z) != theFluid;
        boolean[] renderSides = new boolean[]{block.func_149646_a(world, x, y, z - 1, 2), block.func_149646_a(world, x, y, z + 1, 3), block.func_149646_a(world, x - 1, y, z, 4), block.func_149646_a(world, x + 1, y, z, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float flow11 = this.getFluidHeightForRender(world, x, y, z, theFluid);
        if (flow11 != 1.0f) {
            float flow00 = this.getFluidHeightForRender(world, x - 1, y, z - 1, theFluid);
            float flow01 = this.getFluidHeightForRender(world, x - 1, y, z, theFluid);
            float flow02 = this.getFluidHeightForRender(world, x - 1, y, z + 1, theFluid);
            float flow10 = this.getFluidHeightForRender(world, x, y, z - 1, theFluid);
            float flow12 = this.getFluidHeightForRender(world, x, y, z + 1, theFluid);
            float flow20 = this.getFluidHeightForRender(world, x + 1, y, z - 1, theFluid);
            float flow21 = this.getFluidHeightForRender(world, x + 1, y, z, theFluid);
            float flow22 = this.getFluidHeightForRender(world, x + 1, y, z + 1, theFluid);
            heightNW = this.getFluidHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            heightSW = this.getFluidHeightAverage(new float[]{flow01, flow02, flow12, flow11});
            heightSE = this.getFluidHeightAverage(new float[]{flow12, flow21, flow22, flow11});
            heightNE = this.getFluidHeightAverage(new float[]{flow10, flow20, flow21, flow11});
        } else {
            heightNW = flow11;
            heightSW = flow11;
            heightSE = flow11;
            heightNE = flow11;
        }
        boolean bl = same = heightNE == heightSE && heightSE == heightSW && heightNW == heightSW && heightNW == heightNE;
        if (same) {
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        if (renderer.field_147837_f || renderTop) {
            double v3;
            double u3;
            double v4;
            double u4;
            double v1;
            double u1;
            double v2;
            double u2;
            rendered = true;
            IIcon iconStill = block.func_149673_e(world, x, y, z, 1);
            float flowDir = (float)BlockFluidBase.getFlowDirection((IBlockAccess)world, (int)x, (int)y, (int)z);
            if (flowDir > -999.0f) {
                iconStill = block.func_149673_e(world, x, y, z, 1);
            }
            if (flowDir < -999.0f) {
                u2 = iconStill.func_94214_a(0.0);
                v2 = iconStill.func_94207_b(0.0);
                u1 = u2;
                v1 = iconStill.func_94207_b(16.0);
                u4 = iconStill.func_94214_a(16.0);
                v4 = v1;
                u3 = u4;
                v3 = v2;
            } else {
                float xFlow = MathHelper.func_76126_a((float)flowDir) * 0.25f;
                float zFlow = MathHelper.func_76134_b((float)flowDir) * 0.25f;
                u2 = iconStill.func_94214_a((double)(8.0f + (-zFlow - xFlow) * 16.0f));
                v2 = iconStill.func_94207_b((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                u1 = iconStill.func_94214_a((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                v1 = iconStill.func_94207_b((double)(8.0f + (zFlow + xFlow) * 16.0f));
                u4 = iconStill.func_94214_a((double)(8.0f + (zFlow + xFlow) * 16.0f));
                v4 = iconStill.func_94207_b((double)(8.0f + (zFlow - xFlow) * 16.0f));
                u3 = iconStill.func_94214_a((double)(8.0f + (zFlow - xFlow) * 16.0f));
                v3 = iconStill.func_94207_b((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            }
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
            tessellator.func_78374_a((double)(x + 0), (double)y + heightNW, (double)(z + 0), u2, v2);
            tessellator.func_78374_a((double)(x + 0), (double)y + heightSW, (double)(z + 1), u1, v1);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightSE, (double)(z + 1), u4, v4);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightNE, (double)(z + 0), u3, v3);
        }
        if (renderer.field_147837_f || renderBottom) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y - 1, z));
            tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
            renderer.func_147768_a(block, (double)x, (double)y, (double)z, block.func_149673_e(world, x, y, z, 0));
        }
        for (int side = 0; side < 4; ++side) {
            double tz2;
            double tz1;
            double tx2;
            double tx1;
            double ty2;
            double ty1;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                }
            }
            IIcon iconFlow = block.func_149673_e(world, x, y, z, side + 2);
            if (!renderer.field_147837_f && !renderSides[side]) continue;
            rendered = true;
            if (side == 0) {
                ty1 = heightNW;
                ty2 = heightNE;
                tx1 = x;
                tx2 = x + 1;
                tz1 = z;
                tz2 = z;
            } else if (side == 1) {
                ty1 = heightSE;
                ty2 = heightSW;
                tx1 = x + 1;
                tx2 = x;
                tz1 = z + 1;
                tz2 = z + 1;
            } else if (side == 2) {
                ty1 = heightSW;
                ty2 = heightNW;
                tx1 = x;
                tx2 = x;
                tz1 = z + 1;
                tz2 = z;
            } else {
                ty1 = heightNE;
                ty2 = heightSE;
                tx1 = x + 1;
                tx2 = x + 1;
                tz1 = z;
                tz2 = z + 1;
            }
            float u1Flow = iconFlow.func_94214_a(0.0);
            float u2Flow = iconFlow.func_94214_a(8.0);
            float v1Flow = iconFlow.func_94207_b((1.0 - ty1) * 16.0 * 0.5);
            float v2Flow = iconFlow.func_94207_b((1.0 - ty2) * 16.0 * 0.5);
            float v3Flow = iconFlow.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_149677_c(world, x2, y, z2));
            float sideLighting = 1.0f;
            sideLighting = side < 2 ? 0.8f : 0.6f;
            tessellator.func_78386_a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            tessellator.func_78374_a(tx1, (double)y + ty1, tz1, (double)u2Flow, (double)v1Flow);
            tessellator.func_78374_a(tx2, (double)y + ty2, tz2, (double)u1Flow, (double)v2Flow);
            tessellator.func_78374_a(tx2, (double)(y + 0), tz2, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(tx1, (double)(y + 0), tz1, (double)u2Flow, (double)v3Flow);
        }
        renderer.field_147855_j = 0.0;
        renderer.field_147857_k = 1.0;
        return rendered;
    }

    public boolean renderFluidOverLay(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer) {
        boolean same;
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        Tessellator tessellator = Tessellator.field_78398_a;
        int color = block.func_149720_d(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int bMeta = world.func_72805_g(x, y, z);
        Block up = world.func_147439_a(x, y + 1, z);
        boolean renderTop = world.func_147439_a(x, y + 1, z) != block;
        boolean renderBottom = false;
        boolean[] renderSides = new boolean[]{world.func_147439_a(x, y, z - 1) != block, world.func_147439_a(x, y, z + 1) != block, world.func_147439_a(x - 1, y, z) != block, world.func_147439_a(x + 1, y, z) != block};
        if (up == Blocks.field_150355_j || up == Blocks.field_150358_i) {
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
            for (int side = 0; side < 4; ++side) {
                double tz2;
                double tz1;
                double tx2;
                double tx1;
                double ty2;
                double ty1;
                int x2 = x;
                int z2 = z;
                switch (side) {
                    case 0: {
                        --z2;
                        break;
                    }
                    case 1: {
                        ++z2;
                        break;
                    }
                    case 2: {
                        --x2;
                        break;
                    }
                    case 3: {
                        ++x2;
                    }
                }
                IIcon iconFlow = block.func_149691_a(side + 2, bMeta);
                if (!renderer.field_147837_f && !renderSides[side]) continue;
                if (side == 0) {
                    ty1 = 1.0;
                    ty2 = 1.0;
                    tx1 = x;
                    tx2 = x + 1;
                    tz1 = (double)z + 0.0;
                    tz2 = (double)z + 0.0;
                } else if (side == 1) {
                    ty1 = 1.0;
                    ty2 = 1.0;
                    tx1 = x + 1;
                    tx2 = x;
                    tz1 = (double)(z + 1) - 0.0;
                    tz2 = (double)(z + 1) - 0.0;
                } else if (side == 2) {
                    ty1 = 1.0;
                    ty2 = 1.0;
                    tx1 = (double)x + 0.0;
                    tx2 = (double)x + 0.0;
                    tz1 = z + 1;
                    tz2 = z;
                } else {
                    ty1 = 1.0;
                    ty2 = 1.0;
                    tx1 = (double)(x + 1) - 0.0;
                    tx2 = (double)(x + 1) - 0.0;
                    tz1 = z;
                    tz2 = z + 1;
                }
                float u1Flow = iconFlow.func_94214_a(0.0);
                float u2Flow = iconFlow.func_94214_a(8.0);
                float v1Flow = iconFlow.func_94207_b((1.0 - ty1) * 16.0 * 0.5);
                float v2Flow = iconFlow.func_94207_b((1.0 - ty2) * 16.0 * 0.5);
                float v3Flow = iconFlow.func_94207_b(8.0);
                tessellator.func_78380_c(block.func_149677_c(world, x2, y, z2));
                float sideLighting = 1.0f;
                sideLighting = side < 2 ? 0.8f : 0.6f;
                tessellator.func_78386_a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
                tessellator.func_78374_a(tx1, (double)y + ty1, tz1, (double)u2Flow, (double)v1Flow);
                tessellator.func_78374_a(tx2, (double)y + ty2, tz2, (double)u1Flow, (double)v2Flow);
                tessellator.func_78374_a(tx2, (double)(y + 0), tz2, (double)u1Flow, (double)v3Flow);
                tessellator.func_78374_a(tx1, (double)(y + 0), tz1, (double)u2Flow, (double)v3Flow);
            }
            return true;
        }
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float flow11 = this.getOverLayHeightForRender(world, x, y, z, block);
        if (flow11 != 1.0f) {
            float flow00 = this.getOverLayHeightForRender(world, x - 1, y, z - 1, block);
            float flow01 = this.getOverLayHeightForRender(world, x - 1, y, z, block);
            float flow02 = this.getOverLayHeightForRender(world, x - 1, y, z + 1, block);
            float flow10 = this.getOverLayHeightForRender(world, x, y, z - 1, block);
            float flow12 = this.getOverLayHeightForRender(world, x, y, z + 1, block);
            float flow20 = this.getOverLayHeightForRender(world, x + 1, y, z - 1, block);
            float flow21 = this.getOverLayHeightForRender(world, x + 1, y, z, block);
            float flow22 = this.getOverLayHeightForRender(world, x + 1, y, z + 1, block);
            heightNW = this.getOverlayHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            heightSW = this.getOverlayHeightAverage(new float[]{flow01, flow02, flow12, flow11});
            heightSE = this.getOverlayHeightAverage(new float[]{flow12, flow21, flow22, flow11});
            heightNE = this.getOverlayHeightAverage(new float[]{flow10, flow20, flow21, flow11});
        } else {
            heightNW = flow11;
            heightSW = flow11;
            heightSE = flow11;
            heightNE = flow11;
        }
        boolean bl = same = heightNW == heightSW && heightSE == heightNE && heightNW == heightNE;
        if (same && bMeta == 0) {
            rendered = true;
            renderer.func_147784_q(block, x, y, z);
            return rendered;
        }
        if (renderer.field_147837_f || renderTop) {
            double v3;
            double u3;
            double v4;
            double u4;
            double v1;
            double u1;
            double v2;
            double u2;
            rendered = true;
            IIcon iconStill = block.func_149691_a(1, bMeta);
            float flowDir = (float)BlockFluidBase.getFlowDirection((IBlockAccess)world, (int)x, (int)y, (int)z);
            heightNW -= (double)0.001f;
            heightSW -= (double)0.001f;
            heightSE -= (double)0.001f;
            heightNE -= (double)0.001f;
            if (flowDir < -999.0f) {
                u2 = iconStill.func_94214_a(0.0);
                v2 = iconStill.func_94207_b(0.0);
                u1 = u2;
                v1 = iconStill.func_94207_b(16.0);
                u4 = iconStill.func_94214_a(16.0);
                v4 = v1;
                u3 = u4;
                v3 = v2;
            } else {
                float xFlow = MathHelper.func_76126_a((float)flowDir) * 0.25f;
                float zFlow = MathHelper.func_76134_b((float)flowDir) * 0.25f;
                u2 = iconStill.func_94214_a((double)(8.0f + (-zFlow - xFlow) * 16.0f));
                v2 = iconStill.func_94207_b((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                u1 = iconStill.func_94214_a((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                v1 = iconStill.func_94207_b((double)(8.0f + (zFlow + xFlow) * 16.0f));
                u4 = iconStill.func_94214_a((double)(8.0f + (zFlow + xFlow) * 16.0f));
                v4 = iconStill.func_94207_b((double)(8.0f + (zFlow - xFlow) * 16.0f));
                u3 = iconStill.func_94214_a((double)(8.0f + (zFlow - xFlow) * 16.0f));
                v3 = iconStill.func_94207_b((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            }
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
            tessellator.func_78374_a((double)(x + 0), (double)y + heightNW, (double)(z + 0), u2, v2);
            tessellator.func_78374_a((double)(x + 0), (double)y + heightSW, (double)(z + 1), u1, v1);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightSE, (double)(z + 1), u4, v4);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightNE, (double)(z + 0), u3, v3);
        }
        if (renderer.field_147837_f || renderBottom) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y - 1, z));
            tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
            renderer.func_147768_a(block, (double)x, (double)y + 0.0, (double)z, block.func_149691_a(0, bMeta));
        }
        for (int side = 0; side < 4; ++side) {
            double tz2;
            double tz1;
            double tx2;
            double tx1;
            double ty2;
            double ty1;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                }
            }
            IIcon iconFlow = block.func_149691_a(side + 2, bMeta);
            if (!renderer.field_147837_f && !renderSides[side]) continue;
            rendered = true;
            if (side == 0) {
                ty1 = heightNW;
                ty2 = heightNE;
                tx1 = x;
                tx2 = x + 1;
                tz1 = (double)z + 0.0;
                tz2 = (double)z + 0.0;
            } else if (side == 1) {
                ty1 = heightSE;
                ty2 = heightSW;
                tx1 = x + 1;
                tx2 = x;
                tz1 = (double)(z + 1) - 0.0;
                tz2 = (double)(z + 1) - 0.0;
            } else if (side == 2) {
                ty1 = heightSW;
                ty2 = heightNW;
                tx1 = (double)x + 0.0;
                tx2 = (double)x + 0.0;
                tz1 = z + 1;
                tz2 = z;
            } else {
                ty1 = heightNE;
                ty2 = heightSE;
                tx1 = (double)(x + 1) - 0.0;
                tx2 = (double)(x + 1) - 0.0;
                tz1 = z;
                tz2 = z + 1;
            }
            float u1Flow = iconFlow.func_94214_a(0.0);
            float u2Flow = iconFlow.func_94214_a(8.0);
            float v1Flow = iconFlow.func_94207_b((1.0 - ty1) * 16.0 * 0.5);
            float v2Flow = iconFlow.func_94207_b((1.0 - ty2) * 16.0 * 0.5);
            float v3Flow = iconFlow.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_149677_c(world, x2, y, z2));
            float sideLighting = 1.0f;
            sideLighting = side < 2 ? 0.8f : 0.6f;
            tessellator.func_78386_a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            tessellator.func_78374_a(tx1, (double)y + ty1, tz1, (double)u2Flow, (double)v1Flow);
            tessellator.func_78374_a(tx2, (double)y + ty2, tz2, (double)u1Flow, (double)v2Flow);
            tessellator.func_78374_a(tx2, (double)(y + 0), tz2, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(tx1, (double)(y + 0), tz1, (double)u2Flow, (double)v3Flow);
        }
        renderer.field_147855_j = 0.0;
        renderer.field_147857_k = 1.0;
        return rendered;
    }

    public int getRenderId() {
        return ID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.25, (double)-0.25, (double)-0.25);
        GL11.glPushAttrib((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushAttrib((int)64);
        RenderHelper.func_74518_a();
        Tessellator t = Tessellator.field_78398_a;
        t.func_78371_b(7);
        new RenderCuboid(t, new IIcon[]{block.func_149691_a(0, metadata)}, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        t.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

