/*
 * Decompiled with CFR 0.152.
 */
package thut.concrete.common.blocks.fluids;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import thut.api.ThutBlocks;
import thut.api.blocks.BlockFluid;
import thut.api.blocks.IRebar;
import thut.api.blocks.multiparts.parts.PartRebar;
import thut.api.maths.Vector3;
import thut.concrete.client.render.RenderFluid;
import thut.concrete.common.blocks.fluids.BlockREConcrete;
import thut.concrete.common.blocks.technical.BlockRebar;

public class BlockLiquidREConcrete
extends BlockFluid
implements IRebar {
    public int colourid;
    static Material wetConcrete = new BlockFluid.WetConcrete(MapColor.field_151665_m);
    Integer[][] data;
    boolean[] side = new boolean[6];
    @SideOnly(value=Side.CLIENT)
    public IIcon theIcon;
    public boolean solidifiable;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockLiquidREConcrete() {
        super(new Fluid("REliquidRock").setDensity(4000).setViscosity(2000), Material.field_151573_f);
        this.func_149663_c("REconcreteLiquid");
        this.func_149752_b(10.0f);
        this.func_149711_c(10.0f);
        ThutBlocks.liquidREConcrete = this;
        this.setTemperature(310);
        this.solidifiable = true;
        this.func_149675_a(true);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)ThutBlocks.rebar);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    @Override
    public boolean func_149678_a(int meta, boolean fullHit) {
        if (this.getFluid().getViscosity() == Integer.MAX_VALUE) {
            return true;
        }
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    @Override
    public void func_149743_a(World worldObj, int x, int y, int z, AxisAlignedBB aaBB, List list, Entity par7Entity) {
        this.side = this.sides((IBlockAccess)worldObj, x, y, z);
        if (!(this.side[0] || this.side[1] || this.side[2] || this.side[3] || this.side[4] || this.side[5])) {
            this.side = new boolean[]{true, true, true, true, false, false};
        }
        for (ForgeDirection fside : ForgeDirection.VALID_DIRECTIONS) {
            AxisAlignedBB coll = this.getBoundingBoxForSide(fside).func_72317_d((double)x, (double)y, (double)z);
            if (!aaBB.func_72326_a(coll) || !this.side[fside.ordinal()]) continue;
            list.add(coll);
        }
    }

    @Override
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, (float)(meta + 1) / 16.0f, 1.0f);
    }

    public AxisAlignedBB getBoundingBoxForSide(ForgeDirection fside) {
        switch (fside) {
            case UP: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.4f, (double)0.35f, (double)0.65f, (double)1.0, (double)0.65f);
            }
            case DOWN: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.0, (double)0.35f, (double)0.65f, (double)0.6f, (double)0.65f);
            }
            case NORTH: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.35f, (double)0.0, (double)0.65f, (double)0.65f, (double)0.6f);
            }
            case SOUTH: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.35f, (double)0.4f, (double)0.65f, (double)0.65f, (double)1.0);
            }
            case EAST: {
                return AxisAlignedBB.func_72330_a((double)0.4f, (double)0.35f, (double)0.35f, (double)1.0, (double)0.65f, (double)0.65f);
            }
            case WEST: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.35f, (double)0.35f, (double)0.6f, (double)0.65f, (double)0.65f);
            }
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    private void setBlockBoundsForSide(int x, int y, int z, ForgeDirection side) {
        switch (side) {
            case UP: {
                this.func_149676_a(0.35f, 0.4f, 0.35f, 0.65f, 1.0f, 0.65f);
                break;
            }
            case DOWN: {
                this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.6f, 0.65f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.35f, 0.35f, 0.0f, 0.65f, 0.65f, 0.6f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.35f, 0.35f, 0.4f, 0.65f, 0.65f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.4f, 0.35f, 0.35f, 1.0f, 0.65f, 0.65f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.0f, 0.35f, 0.35f, 0.6f, 0.65f, 0.65f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void flowInto(World world, Vector3 from, Vector3 to, int metaTo, int metaFrom, boolean instant) {
        Block newBTo;
        Block bTo = to.getBlock((IBlockAccess)world);
        TileEntity te = to.getTileEntity((IBlockAccess)world);
        TileMultipart tile = (TileMultipart)(te instanceof TileMultipart ? te : null);
        boolean rightBlock = false;
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRebar)) continue;
                rightBlock = true;
                break;
            }
        }
        Block block = newBTo = bTo instanceof BlockRebar || bTo instanceof BlockLiquidREConcrete || bTo instanceof BlockREConcrete || rightBlock ? ThutBlocks.liquidREConcrete : ThutBlocks.liquidConcrete;
        if (instant) {
            to.setBlock(world, newBTo, metaTo, 2);
            world.field_72999_e = true;
            this.func_149674_a(world, to.intX(), to.intY(), to.intZ(), world.field_73012_v);
            world.field_72999_e = false;
            if (metaFrom >= 0) {
                world.func_147464_a(from.intX(), from.intY(), from.intZ(), (Block)this, this.tickRate);
            } else {
                from.setBlock(world, ThutBlocks.rebar);
            }
        } else {
            to.setBlock(world, newBTo, metaTo, 3);
            if (metaFrom >= 0) {
                world.func_72921_c(from.intX(), from.intY(), from.intZ(), metaFrom, 3);
            } else {
                from.setBlock(world, ThutBlocks.rebar);
            }
        }
    }

    @Override
    public int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        TileMultipart tile = (TileMultipart)(te instanceof TileMultipart ? te : null);
        Block b = world.func_147439_a(x, y, z);
        boolean rightBlock = false;
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRebar)) continue;
                rightBlock = true;
                b = ((PartRebar)p).getBlock();
                break;
            }
        }
        if (b instanceof BlockRebar || rightBlock) {
            return 0;
        }
        if (b != this && b != ThutBlocks.reConcrete) {
            return -1;
        }
        int quantaRemaining = world.func_72805_g(x, y, z) + 1;
        return quantaRemaining;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("concrete:wetConcrete_8");
        this.theIcon = par1IconRegister.func_94245_a("concrete:rebar");
        this.iconArray = new IIcon[16];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = par1IconRegister.func_94245_a("concrete:wetConcrete_" + i);
        }
    }

    @Override
    public boolean[] sides(IBlockAccess worldObj, int x, int y, int z) {
        boolean[] side = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            Block block = worldObj.func_147439_a(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
            boolean rightBlock = false;
            TileEntity te = worldObj.func_147438_o(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
            TileMultipart tile = (TileMultipart)(te instanceof TileMultipart ? te : null);
            if (tile != null) {
                for (TMultiPart p : tile.partList()) {
                    if (!(p instanceof PartRebar)) continue;
                    rightBlock = true;
                    break;
                }
            }
            side[i] = block instanceof IRebar || rightBlock;
        }
        return side;
    }

    @Override
    public void doHardenTick(World worldObj, Vector3 vec) {
        Vector3 down = vec.offset(EnumFacing.DOWN);
        Block below = down.getBlock((IBlockAccess)worldObj);
        int meta = down.getBlockMetadata((IBlockAccess)worldObj);
        if (below == Blocks.field_150349_c) {
            down.setBlock(worldObj, Blocks.field_150346_d, 0, 2);
        }
        if (down.getBlock((IBlockAccess)worldObj) instanceof BlockFluid && meta != 15) {
            return;
        }
        if (below == this) {
            return;
        }
        vec.setBlock(worldObj, ThutBlocks.reConcrete, vec.getBlockMetadata((IBlockAccess)worldObj), 2);
    }

    @Override
    public IIcon getIcon(Block block) {
        return this.field_149761_L;
    }

    @Override
    public int func_149645_b() {
        return RenderFluid.ID;
    }

    @Override
    public boolean[] getInventorySides() {
        return null;
    }

    @Override
    public BlockCoord placeBlock(World worldObj, int x, int y, int z, Block block2, int rebarMeta, ForgeDirection side) {
        return null;
    }
}

