/*
 * Decompiled with CFR 0.152.
 */
package thut.concrete.common.blocks.technical;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thut.api.ThutBlocks;
import thut.api.blocks.tileentity.TileEntityMultiBlockPartFluids;
import thut.api.blocks.tileentity.TileEntityMultiCoreFluids;
import thut.concrete.common.ConcreteCore;
import thut.concrete.common.blocks.tileentity.crafting.TileEntityMixer;

public class BlockMixer
extends Block
implements ITileEntityProvider {
    public BlockMixer() {
        super(Material.field_151573_f);
        this.func_149663_c("blockMixer");
        this.func_149672_a(field_149769_e);
        this.func_149711_c(3.5f);
        this.func_149647_a(ConcreteCore.tabThut);
        ThutBlocks.mixer = this;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            return meta == 0 ? 0 : 15;
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.func_72805_g(x, y, z);
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity t = world.func_147438_o(x, y, z);
        if (t instanceof TileEntityMultiBlockPartFluids) {
            TileEntityMultiBlockPartFluids dummy = (TileEntityMultiBlockPartFluids)t;
            if (dummy != null && dummy.getCore() != null) {
                TileEntityMultiCoreFluids core = dummy.getCore();
                return core.func_145838_q().func_149727_a(world, core.field_145851_c, core.field_145848_d, core.field_145849_e, player, par6, par7, par8, par9);
            }
            return true;
        }
        TileEntityMixer tileEntity = (TileEntityMixer)t;
        if (tileEntity != null) {
            if (!tileEntity.getIsValid() && tileEntity.checkIfProperlyFormed()) {
                tileEntity.convertDummies();
            }
            System.out.println(Arrays.toString(tileEntity.tankCapacities()));
            if (tileEntity.getIsValid()) {
                player.openGui((Object)ConcreteCore.instance, 0, world, x, y, z);
            }
        }
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("concrete:brick");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return this.field_149761_L;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (!(t instanceof TileEntityMixer)) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        TileEntityMixer te = (TileEntityMixer)t;
        ForgeDirection side = this.getFacingfromEntity(entity);
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return par9;
    }

    public ForgeDirection getFacingfromEntity(EntityLivingBase e) {
        ForgeDirection side = null;
        double angle = e.field_70177_z % 360.0f;
        if (angle > 315.0 || angle <= 45.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return ForgeDirection.WEST;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return ForgeDirection.NORTH;
        }
        if (angle > 225.0 && angle <= 315.0) {
            return ForgeDirection.EAST;
        }
        return side;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        return this.field_149761_L;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0 || metadata == 1) {
            return this.func_149915_a(world, 0);
        }
        if (metadata == 2 || metadata == 3) {
            return new TileEntityMultiBlockPartFluids();
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntityMultiBlockPartFluids p;
        TileEntity t = world.func_147438_o(x, y, z);
        if (t instanceof TileEntityMultiBlockPartFluids && (p = (TileEntityMultiBlockPartFluids)t).getCore() != null) {
            p.getCore().invalidateMultiblock();
        }
        if (!((t = world.func_147438_o(x, y, z)) instanceof TileEntityMixer)) {
            return;
        }
        TileEntityMixer tileEntity = (TileEntityMixer)t;
        if (tileEntity != null) {
            tileEntity.invalidateMultiblock();
        }
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private static int getSideFromFacing(int facing) {
        return ForgeDirection.getOrientation((int)(facing + 2)).ordinal();
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        System.out.println(par1 + " " + par3);
        if (par1 == 2) {
            return Item.func_150898_a((Block)Blocks.field_150336_V);
        }
        if (par1 == 3) {
            return Item.func_150898_a((Block)Blocks.field_150417_aV);
        }
        return super.func_149650_a(par1, par2Random, par3);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            return new ItemStack(Blocks.field_150336_V);
        }
        if (meta == 3) {
            return new ItemStack(Blocks.field_150417_aV);
        }
        return new ItemStack((Block)this);
    }

    private void dropItems(World world, int x, int y, int z) {
        Random prng = new Random();
        TileEntityMixer tileEntity = (TileEntityMixer)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return;
        }
        for (int slot = 0; slot < tileEntity.func_70302_i_(); ++slot) {
            ItemStack item = tileEntity.func_70301_a(slot);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = prng.nextFloat() * 0.8f + 0.1f;
            float ry = prng.nextFloat() * 0.8f + 0.1f;
            float rz = prng.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), item.func_77946_l());
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMixer();
    }
}

