/*
 * Decompiled with CFR 0.152.
 */
package thut.concrete.common.blocks.tileentity.crafting;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import thut.api.ThutBlocks;
import thut.api.blocks.tileentity.TileEntityMultiBlockPartFluids;
import thut.api.blocks.tileentity.TileEntityMultiCoreFluids;
import thut.concrete.common.handlers.RecipeHandler;

public class TileEntityMixer
extends TileEntityMultiCoreFluids {
    private static final int[] liquidSlot = new int[]{8};
    private static final int[] gravelSlots = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] sandSlots = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] cementSlots = new int[]{7, 16};
    private static final int[] allSides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] itemSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16};
    private ItemStack[] furnaceItems = new ItemStack[17];
    protected FluidTank tankWater = new FluidTank(64000);
    protected FluidTank tankConcrete = new FluidTank(64000);
    long time = 0L;

    public int[] func_94128_d(int var1) {
        return allSides;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.furnaceItems.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.furnaceItems[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.furnaceItems[slot] != null) {
            ItemStack itemStack = this.furnaceItems[slot].func_77979_a(count);
            if (this.furnaceItems[slot].field_77994_a <= 0) {
                this.furnaceItems[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.furnaceItems[slot] != null) {
            ItemStack stack = this.furnaceItems[slot];
            this.furnaceItems[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.furnaceItems[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "thutconcrete.container.mixer";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        if (var1 != 8) {
            System.out.println(var1);
            for (ItemStack s : RecipeHandler.validMixerInputs) {
                if (!s.func_77969_a(var2)) continue;
                return true;
            }
        }
        if (var1 == 8) {
            return var2.func_77973_b() instanceof IFluidContainerItem || var2.func_77973_b() == Items.field_151131_as;
        }
        return false;
    }

    @Override
    public boolean checkIfProperlyFormed() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -2; k < 1; ++k) {
                    int z;
                    int y;
                    int x;
                    Block b;
                    if (i == j && i == k && i == 0 || (b = this.field_145850_b.func_147439_a(x = i + this.field_145851_c, y = k + this.field_145848_d, z = j + this.field_145849_e)) == Blocks.field_150417_aV) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void convertDummies() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -2; k < 1; ++k) {
                    TileEntityMultiBlockPartFluids dummyTE;
                    if (i == j && i == k && i == 0) continue;
                    int x = i + this.field_145851_c;
                    int z = j + this.field_145849_e;
                    int y = k + this.field_145848_d;
                    this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150417_aV);
                    TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                    if (te instanceof TileEntityMultiBlockPartFluids) {
                        dummyTE = (TileEntityMultiBlockPartFluids)te;
                    } else {
                        if (te != null) {
                            te.func_145843_s();
                            this.field_145850_b.func_147475_p(x, y, z);
                        }
                        dummyTE = new TileEntityMultiBlockPartFluids();
                        dummyTE.type = 1;
                        dummyTE.revertID = Blocks.field_150417_aV;
                        this.field_145850_b.func_147455_a(x, y, z, (TileEntity)dummyTE);
                    }
                    dummyTE.type = 1;
                    dummyTE.revertID = Blocks.field_150417_aV;
                    dummyTE.setCore(this);
                }
            }
        }
        this.isValidMultiblock = true;
    }

    @Override
    protected void revertDummies() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -2; k < 1; ++k) {
                    if (i == j && i == k && i == 0) continue;
                    int x = i + this.field_145851_c;
                    int z = j + this.field_145849_e;
                    int y = k + this.field_145848_d;
                    Block b = this.field_145850_b.func_147439_a(x, y, z);
                    TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                    if (b != ThutBlocks.mixer) continue;
                    this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150417_aV);
                }
            }
        }
        this.isValidMultiblock = false;
    }

    public int[] tankCapacities() {
        return new int[]{this.tankWater.getFluidAmount(), this.tankConcrete.getFluidAmount()};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return from == ForgeDirection.UP ? this.tankWater.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tankWater.getFluid())) {
            return null;
        }
        return this.tankWater.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return from != ForgeDirection.UP ? this.tankConcrete.drain(maxDrain, doDrain) : this.tankWater.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        FluidStack f;
        boolean valid = false;
        Iterator<FluidStack> iterator = RecipeHandler.validInputFluids.iterator();
        while (iterator.hasNext() && !(valid = (f = iterator.next()).getFluid().getName().equalsIgnoreCase(fluid.getName()))) {
        }
        return from == ForgeDirection.UP && valid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (from == ForgeDirection.UP) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.tankWater.getInfo();
        } else {
            FluidTankInfo[] fluidTankInfoArray3 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray3;
            fluidTankInfoArray3[0] = this.tankConcrete.getInfo();
        }
        return fluidTankInfoArray;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isValidMultiblock = tagCompound.func_74767_n("isValidMultiblock");
        NBTTagList itemsTag = (NBTTagList)tagCompound.func_74781_a("Items");
        this.furnaceItems = new ItemStack[17];
        if (itemsTag != null) {
            for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
                byte slot;
                NBTTagCompound slotTag = itemsTag.func_150305_b(i);
                if (slotTag == null || (slot = slotTag.func_74771_c("Slot")) < 0 || slot >= this.furnaceItems.length) continue;
                this.furnaceItems[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
            }
        }
        NBTTagCompound concrete = tagCompound.func_74775_l("concrete");
        NBTTagCompound water = tagCompound.func_74775_l("water");
        this.tankConcrete.readFromNBT(concrete);
        this.tankWater.readFromNBT(water);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isValidMultiblock", this.isValidMultiblock);
        NBTTagList itemsList = new NBTTagList();
        for (int i = 0; i < this.furnaceItems.length; ++i) {
            if (this.furnaceItems[i] != null) {
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a("Slot", (byte)i);
                this.furnaceItems[i].func_77955_b(slotTag);
                itemsList.func_74742_a((NBTBase)slotTag);
            }
            tagCompound.func_74782_a("Items", (NBTBase)itemsList);
        }
        NBTTagCompound concrete = new NBTTagCompound();
        NBTTagCompound water = new NBTTagCompound();
        this.tankConcrete.writeToNBT(concrete);
        this.tankWater.writeToNBT(water);
        tagCompound.func_74782_a("concrete", (NBTBase)concrete);
        tagCompound.func_74782_a("water", (NBTBase)water);
    }

    public void func_145845_h() {
        if (!this.isValidMultiblock || this.time % 20L != 0L) {
            ++this.time;
            return;
        }
        this.checkFluidSlot();
        if (this.tankConcrete.getFluidAmount() < 64000) {
            for (RecipeHandler.MixerRecipe rec : RecipeHandler.mixerRecipes) {
                if (!this.checkInventory(rec)) continue;
                this.makeRecipe(rec);
            }
        }
        ++this.time;
    }

    void makeRecipe(RecipeHandler.MixerRecipe rec) {
        for (ItemStack s : rec.solids) {
            this.consume(itemSlots, s);
        }
        this.tankWater.drain(rec.liquid.amount, true);
        this.tankConcrete.fill(rec.output.copy(), true);
    }

    boolean checkInventory(RecipeHandler.MixerRecipe rec) {
        boolean hasItems = true;
        for (ItemStack s : rec.solids) {
            if (!hasItems) break;
            int num = this.count(itemSlots, s);
            hasItems = hasItems && num >= s.field_77994_a;
        }
        if (!hasItems) {
            return false;
        }
        if (rec.liquid == null) {
            return true;
        }
        FluidStack f = this.tankWater.getFluid();
        if (f == null) {
            return false;
        }
        if (!f.isFluidEqual(rec.liquid)) {
            return false;
        }
        f = this.tankConcrete.getFluid();
        if (f == null) {
            return true;
        }
        if (f.amount <= 64000 - rec.output.amount) {
            return this.tankWater.getFluid().amount >= rec.liquid.amount;
        }
        return false;
    }

    void checkFluidSlot() {
        ItemStack fluid = this.func_70301_a(8);
        if (fluid != null && (fluid.func_77973_b() == Items.field_151131_as || fluid.func_77973_b() instanceof IFluidContainerItem)) {
            if (fluid.func_77973_b() == Items.field_151131_as && this.tankWater.getFluidAmount() < 64000) {
                this.tankWater.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                this.func_70299_a(8, new ItemStack(Items.field_151133_ar));
            }
            if (fluid.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem container = (IFluidContainerItem)fluid.func_77973_b();
                FluidStack temp = container.getFluid(fluid);
                if ((temp == null || temp.isFluidEqual(this.tankConcrete.getFluid())) && this.tankConcrete.getFluidAmount() > 0) {
                    int existing = temp != null ? temp.amount : 0;
                    int freeSpace = container.getCapacity(fluid) - existing;
                    FluidStack out = this.tankConcrete.drain(freeSpace, true);
                    container.fill(fluid, out, true);
                } else if (temp != null) {
                    for (FluidStack f : RecipeHandler.validInputFluids) {
                        if (!f.isFluidEqual(temp) || this.tankWater.getFluidAmount() > 64000 - temp.amount) continue;
                        this.tankWater.fill(temp.copy(), true);
                        container.drain(fluid, temp.amount, true);
                    }
                }
            }
        }
    }

    int count(int[] slots, ItemStack item) {
        int ret = 0;
        for (int i : slots) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !stack.func_77969_a(item)) continue;
            ret += stack.field_77994_a;
        }
        return ret;
    }

    boolean consume(int[] slots, ItemStack item) {
        return this.consume(slots, item, item.field_77994_a);
    }

    boolean consume(int[] slots, ItemStack item, int amount) {
        for (int i : slots) {
            ItemStack stack = this.func_70301_a(i);
            if (amount == 0) {
                return true;
            }
            if (stack == null || !stack.func_77969_a(item)) continue;
            if (stack.field_77994_a >= amount) {
                stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
                return true;
            }
            amount -= stack.field_77994_a;
            this.func_70299_a(i, null);
        }
        return amount == 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbttagcompound = pkt.func_148857_g();
        this.func_145839_a(nbttagcompound);
    }
}

