/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.parts;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thut.api.ThutBlocks;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;

public class PartRail
extends McMetaPart {
    Block rail = ThutBlocks.liftRail;
    public TileEntityLiftAccess te;

    public PartRail() {
    }

    public PartRail(int meta) {
        super(meta);
        this.te = new TileEntityLiftAccess();
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.35, 0.05, 0.35, 0.65, 0.95, 0.65);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        World world = this.world();
        if (world.field_72995_K) {
            return true;
        }
        BlockCoord pos = new BlockCoord(part.field_72311_b, part.field_72312_c, part.field_72309_d);
        this.rail.func_149727_a(world, part.field_72311_b, part.field_72312_c, part.field_72309_d, player, part.field_72310_e, (float)part.field_72307_f.field_72450_a, (float)part.field_72307_f.field_72448_b, (float)part.field_72307_f.field_72449_c);
        return true;
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.te = new TileEntityLiftAccess();
        NBTTagCompound teTag = tag.func_74775_l("teTag");
        this.te.func_145839_a(teTag);
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        NBTTagCompound teTag = new NBTTagCompound();
        if (this.te != null) {
            this.te.func_145841_b(teTag);
        }
        tag.func_74782_a("teTag", (NBTBase)teTag);
    }

    public Block getBlock() {
        return this.rail;
    }

    public String getType() {
        return "tt_rail";
    }

    public static boolean isRail(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) == ThutBlocks.liftRail) {
            return true;
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRail)) continue;
                return true;
            }
        }
        return false;
    }

    public static TileEntity getRailTile(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) == ThutBlocks.liftRail) {
            return world.func_147438_o(pos.x, pos.y, pos.z);
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRail)) continue;
                PartRail rail = (PartRail)p;
                if (rail.te == null) {
                    rail.te = new TileEntityLiftAccess();
                }
                rail.te.func_145834_a(world);
                return rail.te;
            }
        }
        return null;
    }
}

