/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thut.api.ThutBlocks;
import thut.api.blocks.multiparts.parts.PartRebar;
import thut.api.entity.IMultibox;
import thut.api.maths.Matrix3;
import thut.api.maths.Vector3;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.handlers.ConfigHandler;
import thut.tech.common.items.ItemLinker;

public class EntityLift
extends EntityLivingBase
implements IEntityAdditionalSpawnData,
IMultibox {
    public double size = 1.0;
    public double speedUp = ConfigHandler.LiftSpeedUp;
    public double speedDown = -ConfigHandler.LiftSpeedDown;
    public static int ACCELERATIONTICKS = 20;
    public double acceleration = 0.05;
    public boolean up = true;
    public boolean toMoveY = false;
    public boolean moved = false;
    public boolean axis = true;
    public boolean hasPassenger = false;
    public static boolean AUGMENTG = true;
    int n = 0;
    int passengertime = 10;
    boolean first = true;
    Random r = new Random();
    public UUID id = UUID.randomUUID();
    private static HashMap<UUID, EntityLift> lifts = new HashMap();
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    public boolean called = false;
    TileEntityLiftAccess current;
    Matrix3 mainBox = new Matrix3();
    Matrix3 tempBox = new Matrix3();
    public HashMap<String, Matrix3> boxes = new HashMap();
    public HashMap<String, Vector3> offsets = new HashMap();
    public int[] floors = new int[64];
    Matrix3 base = new Matrix3();
    Matrix3 top = new Matrix3();
    Matrix3 wall1 = new Matrix3();
    AxisAlignedBB collisionBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public ItemStack[][] blocks = null;

    public EntityLift(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = -1;
        }
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public EntityLift(World world, double x, double y, double z, double size) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r.setSeed(100L);
        this.size = Math.max(size, 1.0);
        this.func_70105_a((float)this.size, 1.0f);
        lifts.put(this.id, this);
    }

    public void func_70071_h_() {
        this.field_70167_r = this.field_70163_u;
        if ((int)this.size != (int)this.field_70130_N) {
            this.func_70105_a((float)this.size, 1.0f);
        }
        if (this.first) {
            this.checkRails(0.0);
            this.first = false;
        }
        this.clearLiquids();
        if (this.field_70181_x == 0.0) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        if (!this.checkBlocks(0.0)) {
            this.toMoveY = false;
        }
        this.called = this.getDestY() > 0;
        this.toMoveY = this.called;
        this.up = (double)this.getDestY() > this.field_70163_u;
        this.accelerate();
        if (this.toMoveY) {
            this.doMotion();
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        this.checkCollision();
        this.passengertime = this.hasPassenger ? 20 : this.passengertime - 1;
        ++this.n;
    }

    public void passengerCheck() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        this.hasPassenger = list.size() > 0;
    }

    public void call(int floor) {
        if (floor == 0 || floor > 64) {
            return;
        }
        if (this.floors[floor - 1] > 0) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    public void accelerate() {
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = !this.toMoveY ? (this.field_70181_x *= 0.5) : (this.up ? Math.min(this.speedUp, this.field_70181_x + this.acceleration * this.speedUp) : Math.max(this.speedDown, this.field_70181_x + this.acceleration * this.speedDown));
    }

    public void doMotion() {
        if (this.up) {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x >= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedUp / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedUp / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            if (this.current != null) {
                this.current.setCalled(false);
                this.field_70170_p.field_72999_e = true;
                this.current.func_145838_q().func_149674_a(this.field_70170_p, this.current.field_145851_c, this.current.field_145848_d, this.current.field_145849_e, this.field_70170_p.field_73012_v);
                this.field_70170_p.field_72999_e = false;
                this.current = null;
            }
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        } else {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x <= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedDown / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedDown / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            if (this.current != null) {
                this.current.setCalled(false);
                this.field_70170_p.field_72999_e = true;
                this.current.func_145838_q().func_149674_a(this.field_70170_p, this.current.field_145851_c, this.current.field_145848_d, this.current.field_145849_e, this.field_70170_p.field_73012_v);
                this.field_70170_p.field_72999_e = false;
                this.current = null;
            }
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        }
        this.toMoveY = false;
        this.moved = false;
    }

    public boolean checkBlocks(double dir) {
        boolean ret = true;
        Vector3 thisloc = Vector3.getNewVectorFromPool().set(this).addTo(0.0, dir, 0.0);
        if (this.called) {
            if (dir > 0.0 && thisloc.y > (double)this.getDestY()) {
                thisloc.freeVectorFromPool();
                return false;
            }
            if (dir < 0.0 && thisloc.y < (double)this.getDestY()) {
                thisloc.freeVectorFromPool();
                return false;
            }
        }
        int rad = (int)Math.floor(this.size / 2.0);
        Vector3 v = Vector3.getNewVectorFromPool();
        for (int i = -rad; i <= rad; ++i) {
            for (int j = -rad; j <= rad; ++j) {
                Vector3 checkTop = v.set(thisloc).add(i, 4.0, j);
                Vector3 checkBottom = v.set(thisloc).add(i, 1.0, j);
                ret = ret && v.set(thisloc).addTo(i, 0.0, j).clearOfBlocks((IBlockAccess)this.field_70170_p);
                boolean bl = ret = ret && v.set(thisloc).addTo(i, 5.0, j).clearOfBlocks((IBlockAccess)this.field_70170_p);
                if (checkTop.isFluid(this.field_70170_p)) {
                    checkTop.setAir(this.field_70170_p);
                }
                if (checkBottom.isFluid(this.field_70170_p)) {
                    checkBottom.setAir(this.field_70170_p);
                }
                checkTop.freeVectorFromPool();
                checkBottom.freeVectorFromPool();
            }
        }
        ret = ret && this.checkRails(dir);
        return ret;
    }

    public void clearLiquids() {
        int rad = (int)Math.floor(this.size / 2.0);
        Vector3 thisloc = Vector3.getNewVectorFromPool().set(this);
        Vector3 v = Vector3.getNewVectorFromPool();
        for (int i = -rad; i <= rad; ++i) {
            for (int j = -rad; j <= rad; ++j) {
                Vector3 check = v.set(thisloc).addTo(i, 5.0, j);
                if (check.isFluid(this.field_70170_p)) {
                    check.setBlock(this.field_70170_p, ThutBlocks.field_150350_a, 0);
                }
                if ((check = v.set(thisloc).addTo(i, 0.0, j)).isFluid(this.field_70170_p)) {
                    check.setBlock(this.field_70170_p, ThutBlocks.field_150350_a, 0);
                }
                check.freeVectorFromPool();
            }
        }
        v.freeVectorFromPool();
        thisloc.freeVectorFromPool();
    }

    public boolean checkRails(double dir) {
        int rad = (int)(1.0 + Math.floor(this.size / 2.0));
        int[][] sides = new int[][]{{rad, 0}, {-rad, 0}, {0, rad}, {0, -rad}};
        boolean ret = true;
        boolean rightBlock = false;
        BlockCoord posA = new BlockCoord();
        BlockCoord posB = new BlockCoord();
        for (int i = 0; i < 2; ++i) {
            posA.set((int)Math.floor(this.field_70165_t) + sides[this.axis ? 2 : 0][0], (int)Math.floor(this.field_70163_u + dir + (double)i), (int)Math.floor(this.field_70161_v) + sides[this.axis ? 2 : 0][1]);
            rightBlock = PartRebar.isRebar(this.field_70170_p, posA);
            ret = ret && rightBlock;
            posB.set((int)Math.floor(this.field_70165_t) + sides[this.axis ? 3 : 1][0], (int)Math.floor(this.field_70163_u + dir + (double)i), (int)Math.floor(this.field_70161_v) + sides[this.axis ? 3 : 1][1]);
            rightBlock = PartRebar.isRebar(this.field_70170_p, posB);
            boolean bl = ret = ret && rightBlock;
            if (!ret) continue;
            TileEntityLiftAccess teA = (TileEntityLiftAccess)EntityLift.getRailTile(this.field_70170_p, posA);
            TileEntityLiftAccess teB = (TileEntityLiftAccess)EntityLift.getRailTile(this.field_70170_p, posB);
            if (teA != null && teA.lift == null) {
                teA.setLift(this);
            }
            if (teB == null || teB.lift != null) continue;
            teB.setLift(this);
        }
        if (!ret && dir == 0.0) {
            this.axis = !this.axis;
        }
        return ret;
    }

    private boolean consumePower() {
        boolean power = false;
        int sizeFactor = this.size == 1.0 ? 4 : (this.size == 3.0 ? 23 : 55);
        double energyCost = 0.0;
        if (energyCost <= 0.0) {
            return true;
        }
        if (!power) {
            this.toMoveY = false;
        }
        return power;
    }

    @Override
    public void checkCollision() {
        List list = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (this.size + 1.0)), (double)this.field_70163_u, (double)(this.field_70161_v - (this.size + 1.0)), (double)(this.field_70165_t + (this.size + 1.0)), (double)(this.field_70163_u + 6.0), (double)(this.field_70161_v + (this.size + 1.0))));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.field_70153_n != null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    public void func_70108_f(Entity entity) {
        Vector3 r;
        Vector3 rotation;
        boolean collided = false;
        Vector3 v = Vector3.getNewVectorFromPool();
        Vector3 v1 = Vector3.getNewVectorFromPool();
        Vector3 v2 = Vector3.getNewVectorFromPool().set(this);
        AxisAlignedBB box = Matrix3.getAABB(this.field_70165_t - this.size / 2.0, this.field_70163_u, this.field_70161_v - this.size / 2.0, this.field_70165_t + this.size / 2.0, this.field_70163_u + 1.0, this.field_70161_v + this.size / 2.0);
        boolean push = box.func_72326_a(entity.field_70121_D);
        boolean bl = collided = push || collided;
        if (push) {
            entity.field_70143_R = 0.0f;
            entity.field_70122_E = true;
            entity.field_70181_x = Math.max(this.field_70181_x, entity.field_70181_x);
            if (entity.field_70163_u > this.field_70163_u + 1.0) {
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u + 1.0 + (double)entity.field_70129_M, entity.field_70161_v);
            } else if (entity.field_70181_x > this.field_70181_x) {
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u - (double)entity.field_70131_O, entity.field_70161_v);
            }
        }
        Matrix3.freeAABB(box);
        if (!collided) {
            rotation = this.mainBox.boxRotation();
            v.clear();
            v1.clear();
            r = v.set(entity).subtract(v1.set(this));
            if (rotation.y != 0.0 || rotation.z != 0.0) {
                r = r.rotateAboutAngles(rotation.y, rotation.z, v2, v1);
            }
            if (r.inMatBox(this.mainBox)) {
                entity.func_70107_b(entity.field_70165_t + this.field_70159_w, entity.field_70163_u, entity.field_70161_v + this.field_70179_y);
            }
            r.freeVectorFromPool();
        }
        boolean bl2 = collided = (push = (box = Matrix3.getAABB(this.field_70165_t - this.size / 2.0, this.field_70163_u + 4.5, this.field_70161_v - this.size / 2.0, this.field_70165_t + this.size / 2.0, this.field_70163_u + 5.5, this.field_70161_v + this.size / 2.0)).func_72326_a(entity.field_70121_D)) || collided;
        if (push) {
            entity.field_70143_R = 0.0f;
            entity.field_70122_E = true;
            entity.field_70181_x = Math.max(this.field_70181_x, entity.field_70181_x);
            if (entity.field_70163_u > this.field_70163_u + 5.5) {
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u + 5.5 + (double)entity.field_70129_M, entity.field_70161_v);
            } else if (entity.field_70181_x > this.field_70181_x) {
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u + 4.5 - (double)entity.field_70131_O, entity.field_70161_v);
            }
        }
        Matrix3.freeAABB(box);
        if (!collided) {
            rotation = this.mainBox.boxRotation();
            v.clear();
            v1.clear();
            r = v.set(entity).subtract(v1.set(this).add(0.0, 4.5, 0.0));
            if (rotation.y != 0.0 || rotation.z != 0.0) {
                r = r.rotateAboutAngles(rotation.y, rotation.z, v2, v1);
            }
            if (r.addTo(0.0, -4.5, 0.0).inMatBox(this.mainBox)) {
                entity.func_70107_b(entity.field_70165_t + this.field_70159_w, entity.field_70163_u, entity.field_70161_v + this.field_70179_y);
            }
            r.freeVectorFromPool();
        }
        v.freeVectorFromPool();
        v1.freeVectorFromPool();
        v2.freeVectorFromPool();
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemStack item = player.func_70694_bm();
        if (player.func_70093_af() && item != null && item.func_77973_b() instanceof ItemLinker) {
            if (item.field_77990_d == null) {
                item.func_77982_d(new NBTTagCompound());
            }
            item.field_77990_d.func_74778_a("lift", this.id.toString());
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("lift set"));
            }
            return true;
        }
        if (player.func_70093_af() && item != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b().func_77658_a().equals(Items.field_151055_y.func_77658_a()))) {
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("killed lift"));
            }
            this.func_70106_y();
            return true;
        }
        if (item != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver"))) {
            this.axis = !this.axis;
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.blocks != null) {
                ItemStack[][] itemStackArray = this.blocks;
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack[] barr;
                    for (ItemStack b : barr = itemStackArray[i]) {
                        this.func_70099_a(b, 0.5f);
                    }
                }
            } else {
                int iron;
                int n = this.size == 1.0 ? 0 : (iron = this.size == 3.0 ? 8 : 24);
                if (iron > 0) {
                    this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150339_S), iron);
                }
                this.func_145779_a(Item.func_150898_a((Block)ThutBlocks.lift), 1);
            }
        }
        super.func_70106_y();
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.size);
        data.writeLong(this.id.getMostSignificantBits());
        data.writeLong(this.id.getLeastSignificantBits());
        for (int i = 0; i < 64; ++i) {
            data.writeInt(this.floors[i]);
        }
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            this.writeBlocks(tag);
            buff.func_150786_a(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.size = data.readDouble();
        this.id = new UUID(data.readLong(), data.readLong());
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = data.readInt();
        }
        lifts.put(this.id, this);
        this.func_70105_a((float)this.size, 1.0f);
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag = buff.func_150793_b();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readBlocks(tag);
    }

    public void setFoor(TileEntityLiftAccess te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.field_145848_d - 2;
        } else if (te.floor != 0) {
            this.floors[te.floor - 1] = -1;
            this.floors[floor - 1] = te.field_145848_d - 2;
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.axis = nbt.func_74767_n("axis");
        this.size = nbt.func_74769_h("size");
        this.id = new UUID(nbt.func_74763_f("higher"), nbt.func_74763_f("lower"));
        lifts.put(this.id, this);
        this.readList(nbt);
        this.readBlocks(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("axis", this.axis);
        nbt.func_74780_a("size", this.size);
        nbt.func_74772_a("lower", this.id.getLeastSignificantBits());
        nbt.func_74772_a("higher", this.id.getMostSignificantBits());
        this.writeList(nbt);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeList(NBTTagCompound nbt) {
        for (int i = 0; i < 64; ++i) {
            nbt.func_74768_a("floors " + i, this.floors[i]);
        }
    }

    public void readList(NBTTagCompound nbt) {
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = nbt.func_74762_e("floors " + i);
            if (this.floors[i] != 0) continue;
            this.floors[i] = -1;
        }
    }

    public void writeBlocks(NBTTagCompound nbt) {
        if (this.blocks != null) {
            nbt.func_74768_a("BlocksLength", this.blocks.length);
            int size = this.blocks.length;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    ItemStack b = this.blocks[i][j];
                    nbt.func_74768_a("block" + i + "," + j, Item.func_150891_b((Item)b.func_77973_b()));
                    nbt.func_74768_a("meta", b.func_77960_j());
                }
            }
        }
    }

    public void readBlocks(NBTTagCompound nbt) {
        if (nbt.func_74764_b("BlocksLength")) {
            int size = nbt.func_74762_e("BlocksLength");
            this.blocks = new ItemStack[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    ItemStack b;
                    int n = nbt.func_74762_e("block" + i + "," + j);
                    this.blocks[i][j] = b = new ItemStack(Item.func_150899_d((int)n), 1, nbt.func_74762_e("meta"));
                }
            }
        } else {
            int size = (int)Math.round(this.size);
            this.blocks = new ItemStack[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    this.blocks[i][j] = new ItemStack(Blocks.field_150339_S);
                }
            }
        }
    }

    public static EntityLift getLiftFromUUID(UUID uuid) {
        return lifts.get(uuid);
    }

    @Override
    public void setBoxes() {
        Matrix3 m2;
        this.mainBox.boxMin().set(-this.size / 2.0, 0.0, -this.size / 2.0);
        this.mainBox.boxMax().set(this.size / 2.0, 1.0, this.size / 2.0);
        if (!this.boxes.containsKey("base")) {
            m2 = new Matrix3();
            this.boxes.put("base", m2);
        } else {
            m2 = this.boxes.get("base");
        }
        m2.boxMin().clear();
        m2.boxMax().set(this.size, 1.0, this.size);
        m2.boxRotation().clear();
        this.boxes.put("base", m2);
    }

    @Override
    public void setOffsets() {
        Vector3 v2;
        if (!this.offsets.containsKey("base")) {
            v2 = Vector3.getNewVectorFromPool();
            this.offsets.put("base", v2);
        } else {
            v2 = this.offsets.get("base");
        }
        v2.set(0.0 - this.size / 2.0, 0.0, 0.0 - this.size / 2.0);
    }

    @Override
    public Matrix3 bounds(Vector3 target) {
        this.tempBox.boxMin().set(-this.size / 2.0, 0.0, -this.size / 2.0);
        this.tempBox.boxMax().set(this.size / 2.0, 1.0, this.size / 2.0);
        return this.tempBox;
    }

    public boolean attackEntityFrom(DamageSource source, int damage) {
        return damage > 15;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(2, (Object)0);
        this.field_70180_af.func_75682_a(3, (Object)0);
        this.field_70180_af.func_75682_a(4, (Object)-1);
    }

    public ItemStack func_70694_bm() {
        return null;
    }

    public ItemStack func_71124_b(int var1) {
        return null;
    }

    public void func_70062_b(int var1, ItemStack var2) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    public int getDestinationFloor() {
        return this.field_70180_af.func_75679_c(2);
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_75692_b(2, (Object)destinationFloor);
    }

    public int getCurrentFloor() {
        return this.field_70180_af.func_75679_c(3);
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_75692_b(3, (Object)currentFloor);
    }

    public int getDestY() {
        return this.field_70180_af.func_75679_c(4);
    }

    public void setDestY(int dest) {
        this.field_70180_af.func_75692_b(4, (Object)dest);
    }

    public AxisAlignedBB func_70046_E() {
        this.collisionBox.field_72336_d = this.collisionBox.field_72340_a = this.field_70165_t;
        this.collisionBox.field_72337_e = this.collisionBox.field_72338_b = this.field_70163_u;
        this.collisionBox.field_72334_f = this.collisionBox.field_72339_c = this.field_70161_v;
        this.collisionBox.field_72337_e = this.collisionBox.field_72338_b + 1.0;
        this.collisionBox.field_72336_d += this.size / 2.0;
        this.collisionBox.field_72334_f += this.size / 2.0;
        this.collisionBox.field_72340_a -= this.size / 2.0;
        this.collisionBox.field_72339_c -= this.size / 2.0;
        return null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public static TileEntity getRailTile(World world, BlockCoord pos) {
        if (world.func_147439_a(pos.x, pos.y, pos.z) == ThutBlocks.liftRail) {
            return world.func_147438_o(pos.x, pos.y, pos.z);
        }
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos);
        if (tile != null) {
            for (TMultiPart p : tile.partList()) {
                if (!(p instanceof PartRebar)) continue;
                PartRebar rail = (PartRebar)p;
                if (rail.te == null) {
                    rail.te = new TileEntityLiftAccess();
                }
                rail.te.func_145834_a(world);
                return rail.te;
            }
        }
        return null;
    }

    @Override
    public HashMap<String, Matrix3> getBoxes() {
        return this.boxes;
    }

    @Override
    public HashMap<String, Vector3> getOffsets() {
        return this.offsets;
    }

    @Override
    public boolean getJumping() {
        return false;
    }
}

