/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thut.api.entity.blockentity.world.client.IBlockEntityWorld;
import thut.tech.common.blocks.lift.ControllerTile;

public class ControllerRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final ResourceLocation overlay = new ResourceLocation("thuttech:textures/blocks/overlay.png");
    private final ResourceLocation overlay_1 = new ResourceLocation("thuttech:textures/blocks/overlay_1.png");
    private final ResourceLocation font = new ResourceLocation("thuttech:textures/blocks/font.png");

    public void drawEditOverlay(ControllerTile monitor, Direction side) {
        GL11.glPushMatrix();
        Color colour = new Color(255, 255, 255, 255);
        this.drawOverLay(monitor, 1, colour, side, false, 0);
        colour = monitor.callFaces[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(monitor, 1, colour, side, false, 1);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        colour = new Color(255, 255, 255, 255);
        this.drawOverLay(monitor, 2, colour, side, false, 0);
        colour = monitor.floorDisplay[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(monitor, 2, colour, side, false, 1);
        GL11.glPopMatrix();
    }

    public void drawFloorNumbers(int page) {
        for (int floor = 0; floor < 16; ++floor) {
            this.drawNumber(floor + page * 16, floor);
        }
    }

    private void drawNumber(int number, int floor) {
        boolean minus;
        TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
        GL11.glPushMatrix();
        if (renderengine != null) {
            renderengine.func_110577_a(this.font);
        }
        float dz = -0.001f;
        boolean bl = minus = number >= 64;
        if (minus) {
            number -= 64;
        }
        Tessellator t = Tessellator.func_178181_a();
        t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        double x = (double)(3 - floor & 3) / 4.0;
        double y = (3.0 - (double)(floor >> 2)) / 4.0;
        int actFloor = number;
        double[] uvs = this.locationFromNumber((actFloor + 1) % 10);
        double[] uvs1 = this.locationFromNumber((actFloor + 1) / 10);
        if (actFloor > 8) {
            GL11.glTranslated((double)(x + 0.01), (double)(y + 0.06), (double)-0.006f);
            float dx = minus ? -0.03f : 0.0f;
            float dy = -0.0f;
            t.func_178180_c().func_181662_b(0.15 + (double)dx, 0.15 + (double)dy, 0.0).func_187315_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.15 + (double)dx, 0.0 + (double)dy, 0.0).func_187315_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b((double)(0.0f + dx), 0.0 + (double)dy, 0.0).func_187315_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b((double)(0.0f + dx), 0.15 + (double)dy, 0.0).func_187315_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.15 + (double)dx + 0.1, 0.15 + (double)dy, 0.0).func_187315_a(uvs1[0], uvs1[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.15 + (double)dx + 0.1, (double)(0.0f + dy), 0.0).func_187315_a(uvs1[0], uvs1[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b((double)(0.0f + dx) + 0.1, (double)(0.0f + dy), 0.0).func_187315_a(uvs1[1], uvs1[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b((double)(0.0f + dx) + 0.1, 0.15 + (double)dy, 0.0).func_187315_a(uvs1[1], uvs1[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            if (minus) {
                uvs = this.locationFromNumber(-3);
                dx = 0.135f;
                dy = -0.0175f;
                t.func_178180_c().func_181662_b(0.15 + (double)dx, 0.15 + (double)dy, 0.0).func_187315_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.15 + (double)dx, 0.0 + (double)dy, 0.0).func_187315_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b((double)(0.0f + dx), 0.0 + (double)dy, 0.0).func_187315_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b((double)(0.0f + dx), 0.15 + (double)dy, 0.0).func_187315_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            }
        } else {
            GL11.glTranslated((double)(x + 0.05), (double)(y + 0.06), (double)-0.006f);
            t.func_178180_c().func_181662_b(0.15, 0.15, 0.0).func_187315_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.15, 0.0, 0.0).func_187315_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_187315_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.15, 0.0).func_187315_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            if (minus) {
                uvs = this.locationFromNumber(-3);
                float dx = 0.075f;
                t.func_178180_c().func_181662_b(0.22500000298023223, 0.15, 0.0).func_187315_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.22500000298023223, 0.0, 0.0).func_187315_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b((double)0.075f, 0.0, 0.0).func_187315_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b((double)0.075f, 0.15, 0.0).func_187315_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            }
        }
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public void drawOverLay(ControllerTile monitor, int floor, Color colour, Direction side, boolean wide, int order) {
        if (!wide) {
            floor -= monitor.getSidePage(side) * 16;
        }
        if (floor > 0 && floor < 17) {
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                if (wide) {
                    renderengine.func_110577_a(this.overlay_1);
                } else {
                    renderengine.func_110577_a(this.overlay);
                }
            }
            float dz = -0.001f * (float)(1 + order);
            if (monitor.func_145831_w() instanceof IBlockEntityWorld) {
                dz -= 0.004f;
            }
            double x = (double)(3 - --floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            float r = (float)colour.getRed() / 255.0f;
            float g = (float)colour.getGreen() / 255.0f;
            float b = (float)colour.getBlue() / 255.0f;
            float a = (float)colour.getAlpha() / 255.0f;
            GL11.glTranslated((double)x, (double)y, (double)dz);
            Tessellator t = Tessellator.func_178181_a();
            t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double amount = wide ? 0.25 : 0.0;
            t.func_178180_c().func_181662_b(0.25 + amount, 0.25, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            t.func_178180_c().func_181662_b(0.25 + amount, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.25, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    public double[] locationFromNumber(int number) {
        double[] ret = new double[4];
        int index = 16 + number;
        int dx = index % 10;
        int dz = index / 10;
        ret[0] = (double)dx / 10.0;
        ret[2] = (double)dz / 10.0;
        ret[1] = (double)(1 + dx) / 10.0;
        ret[3] = (double)(1 + dz) / 10.0;
        return ret;
    }

    public void func_199341_a(T tileentity, double x, double y, double z, float f, int f2) {
        ControllerTile monitor = (ControllerTile)((Object)tileentity);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.disableLighting();
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)200.0f, (float)200.0f);
        for (int i = 0; i < 6; ++i) {
            Color colour;
            Direction dir = Direction.func_82600_a((int)i);
            if (!monitor.isSideOn(dir)) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            if (dir == Direction.EAST) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == Direction.SOUTH) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == Direction.WEST) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            int a = 64;
            if (monitor.editFace[dir.ordinal()]) {
                this.drawEditOverlay(monitor, dir);
            } else if (monitor.floorDisplay[dir.ordinal()]) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.095, (double)0.0);
                colour = new Color(255, 255, 255, 255);
                this.drawOverLay(monitor, 1, colour, dir, true, 0);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.11, (double)-0.1, (double)0.0);
                this.drawNumber(monitor.currentFloor - 1, 1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.095, (double)0.0);
                if (monitor.calledFloor == monitor.floor) {
                    colour = new Color(255, 255, 0, 64);
                    this.drawOverLay(monitor, 1, colour, dir, true, 1);
                } else if (monitor.currentFloor == monitor.floor) {
                    colour = new Color(0, 128, 255, 64);
                    this.drawOverLay(monitor, 1, colour, dir, true, 2);
                }
                GL11.glPopMatrix();
            } else if (monitor.callFaces[dir.ordinal()]) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.095, (double)0.0);
                colour = new Color(255, 255, 255, 255);
                this.drawOverLay(monitor, 1, colour, dir, true, 0);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.11, (double)-0.1, (double)0.0);
                this.drawNumber(monitor.floor - 1, 1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.095, (double)0.0);
                if (monitor.calledFloor == monitor.floor) {
                    colour = new Color(255, 255, 0, 64);
                    this.drawOverLay(monitor, 1, colour, dir, true, 1);
                } else if (monitor.currentFloor == monitor.floor) {
                    colour = new Color(0, 128, 255, 64);
                    this.drawOverLay(monitor, 1, colour, dir, true, 2);
                }
                GL11.glPopMatrix();
            } else {
                this.drawFloorNumbers(monitor.getSidePage(dir));
                if (monitor.lift != null) {
                    Color unmapped = new Color(10, 10, 10, 128);
                    Color mapped = new Color(255, 255, 255, 64);
                    Color colour2 = new Color(0, 255, 0, 64);
                    this.drawOverLay(monitor, monitor.floor, colour2, dir, false, 0);
                    colour2 = new Color(255, 255, 0, 64);
                    this.drawOverLay(monitor, monitor.lift.getDestinationFloor(), colour2, dir, false, 1);
                    colour2 = new Color(0, 128, 255, 64);
                    this.drawOverLay(monitor, monitor.lift.getCurrentFloor(), colour2, dir, false, 2);
                    for (int j = monitor.getSidePage(dir) * 16; j < 16 + monitor.getSidePage(dir) * 16; ++j) {
                        if (!monitor.lift.hasFloors[j]) {
                            this.drawOverLay(monitor, j + 1, unmapped, dir, false, 3);
                            continue;
                        }
                        this.drawOverLay(monitor, j + 1, mapped, dir, false, 3);
                    }
                } else {
                    colour = new Color(255, 255, 255, 255);
                    for (int j = monitor.getSidePage(dir) * 16; j < 16 + monitor.getSidePage(dir) * 16; ++j) {
                        this.drawOverLay(monitor, j + 1, colour, dir, false, 0);
                    }
                }
            }
            GL11.glPopMatrix();
        }
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
    }

    public static class ModelLiftController
    extends Model {
        private final RendererModel _main;

        public ModelLiftController() {
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this._main = new RendererModel((Model)this, 0, 0);
            this._main.func_78789_a(0.0f, 0.0f, 0.0f, 1, 1, 1);
            this._main.func_78793_a(0.0f, 0.0f, 0.0f);
            this._main.func_78787_b(64, 32);
            this._main.field_78809_i = true;
            this.setRotation(this._main, 0.0f, 0.0f, 0.0f);
        }

        public void render(TileEntity te) {
            this._main.func_78785_a(1.0f);
        }

        private void setRotation(RendererModel model, float x, float y, float z) {
            model.field_78795_f = x;
            model.field_78796_g = y;
            model.field_78808_h = z;
        }
    }
}

