/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import net.minecraftforge.eventbus.api.Event;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.client.IBlockEntityWorld;
import thut.api.maths.Vector3;
import thut.core.common.network.Packet;
import thut.core.common.network.TileUpdate;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerBlock;
import thut.tech.common.blocks.lift.ControllerUpdate;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.network.PacketLift;

public class ControllerTile
extends TileEntity
implements ITickableTileEntity {
    public static final TileEntityType<? extends TileEntity> TYPE = TileEntityType.Builder.func_223042_a(ControllerTile::new, (Block[])new Block[]{TechCore.LIFTCONTROLLER}).func_206865_a(null);
    public int power = 0;
    public int prevPower = 1;
    public EntityLift lift;
    public BlockState copiedState = null;
    boolean listNull = false;
    List<Entity> list = new ArrayList<Entity>();
    Vector3 here;
    public ControllerTile rootNode;
    public Vector<ControllerTile> connected = new Vector();
    Direction sourceSide;
    boolean loaded = false;
    public int floor = 0;
    public int calledYValue = -1;
    public int calledFloor = 0;
    public int currentFloor = 0;
    public UUID liftID = null;
    UUID empty = new UUID(0L, 0L);
    private byte[] sides = new byte[6];
    private byte[] sidePages = new byte[6];
    int tries = 0;
    public boolean toClear = false;
    public boolean first = true;
    public boolean read = false;
    public boolean redstone = true;
    public boolean powered = false;
    public boolean[] callFaces = new boolean[6];
    public boolean[] editFace = new boolean[6];
    public boolean[] floorDisplay = new boolean[6];
    public boolean callPanel = false;
    private int tick = 0;

    public ControllerTile() {
        super(TYPE);
    }

    public ControllerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void buttonPress(int button, boolean callPanel) {
        if (callPanel && this.lift != null) {
            this.lift.call(this.floor);
        } else if (button != 0 && button <= this.lift.floors.length && this.lift != null && this.lift.hasFloors[button - 1]) {
            if (button != this.floor && this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            this.lift.call(button);
        }
    }

    public boolean checkSides() {
        List check = this.field_145850_b.func_217357_a(EntityLift.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - 1.0, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 - 1.0, (double)this.func_174877_v().func_177958_n() + 0.5 + 1.0, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5 + 1.0));
        if (check != null && check.size() > 0) {
            this.lift = (EntityLift)((Object)check.get(0));
            this.liftID = this.lift.func_110124_au();
        }
        return check != null && !check.isEmpty();
    }

    public String connectionInfo() {
        String ret = "";
        return "";
    }

    public boolean doButtonClick(LivingEntity clicker, Direction side, float hitX, float hitY, float hitZ) {
        boolean valid;
        if (this.liftID != null && !this.liftID.equals(this.empty) && this.lift != EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b)) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b);
        }
        int button = this.getButtonFromClick(side, hitX, hitY, hitZ);
        boolean bl = valid = this.lift != null && this.lift.hasFloors[button - 1];
        if (this.lift != null && this.isSideOn(side)) {
            if (this.editFace[side.ordinal()]) {
                if (!this.func_145831_w().field_72995_K) {
                    String message = "msg.callPanel.name";
                    switch (button) {
                        case 1: {
                            this.callFaces[side.ordinal()] = !this.callFaces[side.ordinal()];
                            this.floorDisplay[side.ordinal()] = false;
                            clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{this.callFaces[side.ordinal()]}));
                            break;
                        }
                        case 2: {
                            this.floorDisplay[side.ordinal()] = !this.floorDisplay[side.ordinal()];
                            this.callFaces[side.ordinal()] = false;
                            message = "msg.floorDisplay.name";
                            clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{this.floorDisplay[side.ordinal()]}));
                            break;
                        }
                        case 16: {
                            this.editFace[side.ordinal()] = false;
                            message = "msg.editMode.name";
                            clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{false}));
                        }
                    }
                    if (clicker instanceof ServerPlayerEntity) {
                        this.sendUpdate((ServerPlayerEntity)clicker);
                    }
                }
                return true;
            }
            if (this.floorDisplay[side.ordinal()]) {
                return false;
            }
            if (this.func_145831_w() instanceof IBlockEntityWorld) {
                this.buttonPress(button, this.callFaces[side.ordinal()]);
                this.calledFloor = this.lift.getDestinationFloor();
            } else if (this.func_145831_w().field_72995_K) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)32));
                buffer.func_179255_a(this.func_174877_v());
                buffer.writeInt(button);
                buffer.writeBoolean(this.callFaces[side.ordinal()]);
                PacketLift packet = new PacketLift(buffer);
                TechCore.packets.sendToServer((Packet)packet);
            }
        }
        if (clicker instanceof ServerPlayerEntity) {
            this.sendUpdate((ServerPlayerEntity)clicker);
        }
        return valid;
    }

    public int getButtonFromClick(Direction side, double x, double y, double z) {
        int ret = 0;
        x %= 1.0;
        y %= 1.0;
        z %= 1.0;
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        int page = this.getSidePage(side);
        switch (side.func_176745_a()) {
            case 0: {
                return 0 + 16 * page;
            }
            case 1: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 2: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 3: {
                ret = 1 + (int)(x * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 4: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)(z * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 5: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
        }
        return 0 + 16 * page;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = IForgeTileEntity.INFINITE_EXTENT_AABB;
        return bb;
    }

    public int getSidePage(Direction side) {
        return this.sidePages[side.func_176745_a()];
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        return this.func_189515_b(tag);
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public boolean isSideOn(Direction side) {
        boolean state = true;
        byte byte0 = this.sides[side.func_176745_a()];
        return (byte0 & 1) != 0;
    }

    public void func_145839_a(CompoundNBT par1) {
        super.func_145839_a(par1);
        this.floor = par1.func_74762_e("floor");
        this.liftID = new UUID(par1.func_74763_f("idMost"), par1.func_74763_f("idLess"));
        this.sides = par1.func_74770_j("sides");
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.callFaces[face.ordinal()] = par1.func_74767_n(face + "Call");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.editFace[face.ordinal()] = par1.func_74767_n(face + "Edit");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.floorDisplay[face.ordinal()] = par1.func_74767_n(face + "Display");
        }
        if (this.sides.length != 6) {
            this.sides = new byte[6];
        }
        this.sidePages = par1.func_74770_j("sidePages");
        if (this.sidePages.length != 6) {
            this.sidePages = new byte[6];
        }
        if (par1.func_74764_b("state")) {
            CompoundNBT state = par1.func_74775_l("state");
            this.copiedState = NBTUtil.func_190008_d((CompoundNBT)state);
        }
    }

    public void sendUpdate(ServerPlayerEntity player) {
        if (this.field_145850_b instanceof IBlockEntityWorld) {
            return;
        }
        TileUpdate.sendUpdate((TileEntity)this);
    }

    public void setFloor(int floor) {
        if (this.lift != null && floor <= this.lift.floors.length && floor > 0) {
            this.lift.setFoor(this, floor);
            this.floor = floor;
            this.func_70296_d();
        }
    }

    public void setLift(EntityLift lift) {
        this.lift = lift;
        this.liftID = lift.func_110124_au();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileUpdate.sendUpdate((TileEntity)this);
        }
    }

    public void setSide(Direction side, boolean flag) {
        boolean state = true;
        byte byte0 = this.sides[side.func_176745_a()];
        if (side.func_176745_a() < 2) {
            return;
        }
        this.sides[side.func_176745_a()] = flag ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFFFFFFFE);
        this.func_70296_d();
    }

    public void setSidePage(Direction side, int page) {
        this.sidePages[side.func_176745_a()] = (byte)page;
    }

    public void setWorldObj(World worldIn) {
        IBlockEntity blockEntity;
        this.field_145850_b = worldIn;
        if (worldIn instanceof IBlockEntityWorld && (blockEntity = ((IBlockEntityWorld)worldIn).getBlockEntity()) instanceof EntityLift) {
            this.setLift((EntityLift)blockEntity);
        }
    }

    public void func_73660_a() {
        if (this.here == null) {
            this.here = Vector3.getNewVector();
        }
        this.here.set((Object)this);
        if (this.lift != null && this.floor > 0) {
            this.lift.hasFloors[this.floor - 1] = true;
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.field_145850_b instanceof IBlockEntityWorld) {
            return;
        }
        if (this.lift == null || !this.lift.func_70089_S()) {
            this.calledYValue = -1;
            this.calledFloor = 0;
            this.currentFloor = 0;
        }
        if (this.lift != null && !this.field_145850_b.field_72995_K) {
            boolean check = this.lift.getCurrentFloor() == this.floor && (int)(this.lift.func_213322_ci().field_72448_b * 16.0) == 0;
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean old = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CURRENT);
            boolean callPanel = false;
            if (!old && !this.lift.getCalled()) {
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    callPanel |= this.callFaces[face.ordinal()];
                }
            }
            if (callPanel && !old && !this.lift.getCalled() && !check && this.field_145850_b.func_175640_z(this.func_174877_v())) {
                this.lift.call(this.floor);
            }
            if (check != old) {
                state = (BlockState)state.func_206870_a((IProperty)ControllerBlock.CURRENT, (Comparable)Boolean.valueOf(check));
                this.field_145850_b.func_175656_a(this.func_174877_v(), state);
            }
            if (this.lift.func_213322_ci().field_72448_b == 0.0 || this.lift.getDestinationFloor() == this.floor) {
                old = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CALLED);
                boolean bl = check = this.lift.getDestinationFloor() == this.floor;
                if (check != old) {
                    state = (BlockState)state.func_206870_a((IProperty)ControllerBlock.CALLED, (Comparable)Boolean.valueOf(check));
                    this.field_145850_b.func_175656_a(this.func_174877_v(), state);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ControllerUpdate(this));
        }
        if (this.lift != null && this.floor > 0) {
            if ((int)Math.round(this.lift.field_70163_u) == this.lift.floors[this.floor - 1]) {
                this.lift.setCurrentFloor(this.floor);
            } else if (this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            this.calledFloor = this.lift.getDestinationFloor();
            this.currentFloor = this.lift.getCurrentFloor();
        }
        if (this.lift == null && this.liftID != null) {
            EntityLift tempLift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b);
            if (!(this.liftID == null || this.liftID.equals(this.empty) || this.lift != null && this.lift.func_70089_S() && tempLift == this.lift)) {
                this.lift = tempLift;
                if (this.lift == null || !this.lift.func_70089_S()) {
                    return;
                }
                if (this.floor > 0 && !this.lift.hasFloors[this.floor - 1]) {
                    this.setFloor(this.floor);
                }
            }
        }
        if (!(this.floor <= 0 || this.lift != null && this.lift.func_70089_S())) {
            this.lift = null;
            this.floor = 0;
        }
        if (this.lift == null && this.tick++ % 50 == 0) {
            for (Direction side : Direction.values()) {
                TileEntity t = this.here.getTileEntity((IBlockReader)this.field_145850_b, side);
                this.here.getBlock((IBlockReader)this.field_145850_b, side);
                if (!(t instanceof ControllerTile)) continue;
                ControllerTile te = (ControllerTile)t;
                if (te.lift == null) continue;
                this.lift = te.lift;
                this.floor = te.floor;
                this.func_70296_d();
                break;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT par1) {
        super.func_189515_b(par1);
        par1.func_74768_a("floor", this.floor);
        par1.func_74773_a("sides", this.sides);
        par1.func_74773_a("sidePages", this.sidePages);
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Call", this.callFaces[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Edit", this.editFace[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Display", this.floorDisplay[face.ordinal()]);
        }
        if (this.lift != null) {
            this.liftID = this.lift.func_110124_au();
        }
        if (this.liftID != null) {
            par1.func_74772_a("idLess", this.liftID.getLeastSignificantBits());
            par1.func_74772_a("idMost", this.liftID.getMostSignificantBits());
        }
        if (this.copiedState != null) {
            CompoundNBT state = NBTUtil.func_190009_a((BlockState)this.copiedState);
            par1.func_218657_a("state", (INBT)state);
        }
        return par1;
    }
}

