/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.Vector3;
import thut.core.common.network.EntityUpdate;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.entity.LiftInteractHandler;

public class EntityLift
extends BlockEntityBase {
    public static final EntityType<EntityLift> TYPE = new BlockEntityBase.BlockEntityType(EntityLift::new);
    static final DataParameter<Integer> DESTINATIONFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Float> DESTINATIONYDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONXDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONZDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Integer> CURRENTFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Boolean> CALLEDDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    public IEnergyStorage energy = null;
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    ControllerTile current;
    public int[] floors = new int[128];
    public boolean[] hasFloors = new boolean[128];
    private final Vector3f velocity = new Vector3f();
    EntitySize field_213325_aI;

    public static EntityLift getLiftFromUUID(UUID liftID, World world) {
        Entity e;
        if (world instanceof ServerWorld && (e = ((ServerWorld)world).func_217461_a(liftID)) instanceof EntityLift) {
            return (EntityLift)e;
        }
        return LiftTracker.liftMap.get(liftID);
    }

    public EntityLift(EntityType<EntityLift> type, World par1World) {
        super(type, par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.speedUp = TechCore.config.LiftSpeedUp;
        this.speedDown = -TechCore.config.LiftSpeedDown;
    }

    public void accelerate() {
        this.field_70177_z = 0.0f;
        if (this.isServerWorld() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
        } else {
            this.toMoveX = (double)this.getDestX() != this.field_70165_t;
            this.toMoveY = (double)this.getDestY() != this.field_70163_u;
            boolean bl = this.toMoveZ = (double)this.getDestZ() != this.field_70161_v;
        }
        if (!this.toMoveX) {
            this.velocity.x = (float)((double)this.velocity.x * 0.5);
        }
        if (!this.toMoveZ) {
            this.velocity.z = (float)((double)this.velocity.z * 0.5);
        }
        if (!this.toMoveY) {
            this.velocity.y = (float)((double)this.velocity.y * 0.5);
        }
        if (this.getCalled()) {
            if (this.toMoveY) {
                float destY = this.getDestY();
                if (Math.abs((double)destY - this.field_70163_u) < 0.01) {
                    this.func_70107_b(this.field_70165_t, destY, this.field_70161_v);
                    this.toMoveY = false;
                    this.velocity.y = 0.0f;
                } else {
                    double dy = this.getSpeed(this.field_70163_u, destY, this.velocity.y, this.speedUp, this.speedDown);
                    this.velocity.y = (float)dy;
                }
            }
            if (this.toMoveX) {
                float destX = this.getDestX();
                if (Math.abs((double)destX - this.field_70165_t) < 0.01) {
                    this.func_70107_b(destX, this.field_70163_u, this.field_70161_v);
                    this.toMoveX = false;
                    this.velocity.x = 0.0f;
                } else {
                    double dx = this.getSpeed(this.field_70165_t, destX, this.velocity.x, this.speedHoriz, this.speedHoriz);
                    this.velocity.x = (float)dx;
                }
            }
            if (this.toMoveZ) {
                float destZ = this.getDestZ();
                if (Math.abs((double)destZ - this.field_70161_v) < 0.01) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, destZ);
                    this.toMoveZ = false;
                    this.velocity.z = 0.0f;
                } else {
                    double dz = this.getSpeed(this.field_70161_v, destZ, this.velocity.z, this.speedHoriz, this.speedHoriz);
                    this.velocity.z = (float)dz;
                }
            }
        }
        this.func_213293_j(this.velocity.x, this.velocity.y, this.velocity.z);
    }

    public void call(int floor) {
        if (floor == 0 || floor > this.floors.length) {
            return;
        }
        if (this.hasFloors[floor - 1]) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    protected boolean checkAccelerationConditions() {
        return this.consumePower();
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.getCalled()) {
            return true;
        }
        if (this.energy == null) {
            this.energy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        }
        if (this.energy == null) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = Vector3.getNewVector().set((Object)this.boundMax.func_177973_b((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        int energyCost = (int)(Math.abs((double)this.getDestY() - this.field_70163_u) * (double)ENERGYCOST * volume * 0.01);
        int canExtract = this.energy.extractEnergy(energyCost = Math.max(energyCost, 1), true);
        if (canExtract == energyCost) {
            power = true;
            this.energy.extractEnergy(energyCost, false);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY((float)this.field_70163_u);
            this.setCalled(false);
            this.toMoveY = false;
        }
        return power;
    }

    protected BlockEntityInteractHandler createInteractHandler() {
        return new LiftInteractHandler(this);
    }

    public void doMotion() {
        if (!this.toMoveX) {
            this.velocity.x = 0.0f;
        }
        if (!this.toMoveY) {
            this.velocity.y = 0.0f;
        }
        if (!this.toMoveZ) {
            this.velocity.z = 0.0f;
        }
        this.func_213293_j(this.velocity.x, this.velocity.y, this.velocity.z);
        if (this.getCalled()) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            BlockPos pos = this.func_180425_c();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.field_70163_u), (double)pos.func_177952_p() + 0.5);
        }
    }

    public boolean getCalled() {
        return (Boolean)this.field_70180_af.func_187225_a(CALLEDDW);
    }

    public int getCurrentFloor() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONFLOORDW);
    }

    public float getDestX() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONXDW)).floatValue();
    }

    public float getDestY() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONYDW)).floatValue();
    }

    public float getDestZ() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONZDW)).floatValue();
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.field_213325_aI == null) {
            this.field_213325_aI = EntitySize.func_220311_c((float)(1 + this.getMax().func_177958_n() - this.getMin().func_177958_n()), (float)this.getMax().func_177956_o());
        }
        return this.field_213325_aI;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        LiftTracker.liftMap.put(this.func_110124_au(), this);
    }

    protected void onGridAlign() {
        this.setCalled(false);
        BlockPos pos = this.func_180425_c();
        this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.field_70163_u), (double)pos.func_177952_p() + 0.5);
        EntityUpdate.sendEntityUpdate((Entity)this);
    }

    protected void preColliderTick() {
    }

    public void func_70037_a(CompoundNBT arg0) {
        super.func_70037_a(arg0);
        if (arg0.func_186855_b("owner")) {
            this.owner = arg0.func_186857_a("owner");
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATIONFLOORDW, (Object)0);
        this.field_70180_af.func_187214_a(DESTINATIONYDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONXDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONZDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENTFLOORDW, (Object)-1);
        this.field_70180_af.func_187214_a(CALLEDDW, (Object)Boolean.FALSE);
    }

    public void func_70106_y() {
        super.func_70106_y();
        LiftTracker.liftMap.remove(this.func_110124_au());
    }

    private void setCalled(boolean called) {
        this.field_70180_af.func_187227_b(CALLEDDW, (Object)called);
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_187227_b(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_187227_b(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestX(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestY(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestZ(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.setCalled(true);
    }

    public void setFoor(ControllerTile te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
            this.hasFloors[floor - 1] = true;
        } else if (te.floor != 0) {
            this.hasFloors[te.floor - 1] = false;
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
            this.hasFloors[floor - 1] = true;
        }
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public void setSize(EntitySize size) {
        this.field_213325_aI = size;
    }

    public void setTiles(TileEntity[][][] tiles) {
        super.setTiles(tiles);
        TileEntity[][][] tileEntityArray = tiles;
        int n = tileEntityArray.length;
        for (int i = 0; i < n; ++i) {
            TileEntity[][] tileArrArr;
            TileEntity[][] tileEntityArray2 = tileArrArr = tileEntityArray[i];
            int n2 = tileEntityArray2.length;
            for (int j = 0; j < n2; ++j) {
                TileEntity[] tileArr;
                for (TileEntity tile : tileArr = tileEntityArray2[j]) {
                    if (!(tile instanceof ControllerTile)) continue;
                    ((ControllerTile)tile).setLift(this);
                }
            }
        }
    }

    public void func_213281_b(CompoundNBT arg0) {
        super.func_213281_b(arg0);
        if (this.owner != null) {
            arg0.func_186854_a("owner", this.owner);
        }
    }

    public static class LiftTracker {
        protected static final Map<UUID, EntityLift> liftMap = Maps.newHashMap();
    }
}

