/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.handlers;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EntityLift;

@Mod.EventBusSubscriber
public class EnergyHandler {
    private static final ResourceLocation ENERGY = new ResourceLocation("thuttech", "energy");

    @SubscribeEvent
    public static void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLift) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLift());
        }
    }

    @SubscribeEvent
    public static void onTileCapabilityAttach(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof ControllerTile) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLiftController((ControllerTile)((Object)event.getObject())));
        }
    }

    public static class ProviderLiftController
    implements ICapabilityProvider,
    IEnergyStorage {
        private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);
        final ControllerTile tile;
        IEnergyStorage lift = null;

        public ProviderLiftController(ControllerTile tile) {
            this.tile = tile;
        }

        public boolean canExtract() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canReceive();
            }
            return false;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return CapabilityEnergy.ENERGY.orEmpty(capability, this.holder);
        }

        public int getEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getMaxEnergyStored();
            }
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        private void updateLift() {
            this.lift = this.tile.lift == null ? null : (IEnergyStorage)this.tile.lift.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        }
    }

    public static class ProviderLift
    extends EnergyStorage
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);

        public ProviderLift() {
            super(TechCore.config.maxLiftEnergy, TechCore.config.maxLiftEnergy);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.energy = nbt.func_74762_e("E");
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return CapabilityEnergy.ENERGY.orEmpty(capability, this.holder);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("E", this.getEnergyStored());
            return tag;
        }
    }
}

