/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client.render;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thut.api.ThutBlocks;
import thut.tech.common.blocks.lift.BlockLift;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;

public class RenderLiftController
extends TileEntitySpecialRenderer {
    private ResourceLocation texture;

    public void drawFloorNumbers(int page) {
        for (int floor = 0; floor < 16; ++floor) {
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/font.png");
                renderengine.func_110577_a(this.texture);
            }
            Tessellator t = Tessellator.func_178181_a();
            t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double x = (double)(3 - floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            int actFloor = floor + page * 16;
            double[] uvs = this.locationFromNumber((actFloor + 1) % 10);
            double[] uvs1 = this.locationFromNumber((actFloor + 1) / 10);
            if (actFloor > 8) {
                GL11.glTranslated((double)(x + 0.01), (double)(y + 0.06), (double)-0.006);
                t.func_178180_c().func_181662_b(0.15, 0.15, 0.0).func_181673_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.15, 0.0, 0.0).func_181673_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.0, 0.15, 0.0).func_181673_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.25, 0.15, 0.0).func_181673_a(uvs1[0], uvs1[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.25, 0.0, 0.0).func_181673_a(uvs1[0], uvs1[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.1, 0.0, 0.0).func_181673_a(uvs1[1], uvs1[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.1, 0.15, 0.0).func_181673_a(uvs1[1], uvs1[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            } else {
                GL11.glTranslated((double)(x + 0.05), (double)(y + 0.06), (double)-0.006);
                t.func_178180_c().func_181662_b(0.15, 0.15, 0.0).func_181673_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.15, 0.0, 0.0).func_181673_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
                t.func_178180_c().func_181662_b(0.0, 0.15, 0.0).func_181673_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
            }
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void drawLiftBounds(int minX, int maxX, int minZ, int maxZ, int minY, int maxY) {
        TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
        GL11.glPushMatrix();
        if (renderengine != null) {
            this.texture = new ResourceLocation("thuttech:textures/blocks/greenOverlay.png");
            renderengine.func_110577_a(this.texture);
        }
        int floor = 5;
        double x = (double)(3 - floor & 3) / 4.0;
        double y = (3.0 - (double)(floor >> 2)) / 4.0;
        GL11.glTranslated((double)(x - 0.125), (double)1.001, (double)(y - 0.125));
        Tessellator t = Tessellator.func_178181_a();
        t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (int i = -minX; i <= maxX; ++i) {
            for (int k = -minY; k <= maxY; ++k) {
                for (int j = -minZ; j <= maxZ; ++j) {
                    t.func_178180_c().func_181662_b(0.25 + (double)i, (double)k, 0.25 + (double)j).func_181673_a(0.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b(0.25 + (double)i, (double)k, (double)(0 + j)).func_181673_a(0.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b((double)(0 + i), (double)k, (double)(0 + j)).func_181673_a(1.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b((double)(0 + i), (double)k, 0.25 + (double)j).func_181673_a(1.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b((double)(0 + i), (double)k, 0.25 + (double)j).func_181673_a(1.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b((double)(0 + i), (double)k, (double)(0 + j)).func_181673_a(1.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b(0.25 + (double)i, (double)k, (double)(0 + j)).func_181673_a(0.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                    t.func_178180_c().func_181662_b(0.25 + (double)i, (double)k, 0.25 + (double)j).func_181673_a(0.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
                }
            }
        }
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    private void drawLiftGui(TileEntityLiftAccess monitor) {
        int xMin = -monitor.boundMin.intX();
        int zMin = -monitor.boundMin.intZ();
        int yMin = -monitor.boundMin.intY();
        int xMax = monitor.boundMax.intX();
        int zMax = monitor.boundMax.intZ();
        int yMax = monitor.boundMax.intY();
        this.drawOnTop(xMin, 0);
        this.drawOnTop(12, 1);
        this.drawOnTop(14, 2);
        this.drawOnTop(xMin, 3);
        this.drawOnTop(zMin, 4);
        this.drawOnTop(12, 5);
        this.drawOnTop(14, 6);
        this.drawOnTop(zMin, 7);
        this.drawOnTop(xMax, 8);
        this.drawOnTop(12, 9);
        this.drawOnTop(14, 10);
        this.drawOnTop(xMax, 11);
        this.drawOnTop(zMax, 12);
        this.drawOnTop(12, 13);
        this.drawOnTop(14, 14);
        this.drawOnTop(zMax, 15);
        this.drawLiftBounds(xMin, xMax, zMin, zMax, yMin, yMax);
    }

    private void drawOnTop(int fontIndex, int positionIndex) {
        TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
        GL11.glPushMatrix();
        if (renderengine != null) {
            this.texture = new ResourceLocation("thuttech:textures/blocks/font.png");
            renderengine.func_110577_a(this.texture);
        }
        int floor = positionIndex;
        Tessellator t = Tessellator.func_178181_a();
        t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        double x1 = (double)(3 - floor & 3) / 4.0;
        double y1 = (3.0 - (double)(floor >> 2)) / 4.0;
        double[] uvs = this.locationFromNumber(fontIndex);
        GL11.glTranslated((double)(x1 + 0.05), (double)1.001, (double)(y1 + 0.06));
        t.func_178180_c().func_181662_b(0.15, 0.0, 0.15).func_181673_a(uvs[0], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
        t.func_178180_c().func_181662_b(0.15, 0.0, 0.0).func_181673_a(uvs[0], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
        t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(uvs[1], uvs[3]).func_181669_b(0, 0, 0, 255).func_181675_d();
        t.func_178180_c().func_181662_b(0.0, 0.0, 0.15).func_181673_a(uvs[1], uvs[2]).func_181669_b(0, 0, 0, 255).func_181675_d();
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public void drawOverLay(TileEntityLiftAccess monitor, int floor, int colour, EnumFacing side) {
        boolean isMonitor;
        IBlockState state = monitor.func_145831_w().func_180495_p(monitor.func_174877_v());
        boolean bl = isMonitor = state.func_177229_b(BlockLift.VARIANT) == BlockLift.EnumType.CONTROLLER;
        if (isMonitor && monitor.func_145838_q() == ThutBlocks.lift && (floor -= monitor.getSidePage(side) * 16) > 0 && floor < 17) {
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            String col = colour == 0 ? "green" : (colour == 1 ? "orange" : (colour == 2 ? "blue" : "gray"));
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/" + col + "Overlay.png");
                renderengine.func_110577_a(this.texture);
            }
            double x = (double)(3 - --floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            GL11.glTranslated((double)x, (double)y, (double)(-0.001 * (double)(colour + 1)));
            Tessellator t = Tessellator.func_178181_a();
            t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            t.func_178180_c().func_181662_b(0.25, 0.25, 0.0).func_181673_a(0.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
            t.func_178180_c().func_181662_b(0.25, 0.0, 0.0).func_181673_a(0.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(1.0, 1.0).func_181669_b(255, 255, 255, 128).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.25, 0.0).func_181673_a(1.0, 0.0).func_181669_b(255, 255, 255, 128).func_181675_d();
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    public double[] locationFromNumber(int number) {
        double[] ret = new double[4];
        int index = 16 + number;
        int dx = index % 10;
        int dz = index / 10;
        ret[0] = (double)dx / 10.0;
        ret[2] = (double)dz / 10.0;
        ret[1] = (double)(1 + dx) / 10.0;
        ret[3] = (double)(1 + dz) / 10.0;
        return ret;
    }

    public void func_180535_a(TileEntity tileentity, double x, double y, double z, float f, int i1) {
        TileEntityLiftAccess monitor = (TileEntityLiftAccess)tileentity;
        IBlockState state = monitor.func_145831_w().func_180495_p(monitor.func_174877_v());
        if (state.func_177230_c() != ThutBlocks.lift) {
            return;
        }
        float[] oldLight = new float[]{-1.0f, -1.0f};
        oldLight[0] = OpenGlHelper.lastBrightnessX;
        oldLight[1] = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        boolean blend = GL11.glGetBoolean((int)3042);
        boolean light = GL11.glGetBoolean((int)2896);
        int src = GL11.glGetInteger((int)3041);
        int dst = GL11.glGetInteger((int)3040);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        if (monitor.func_145832_p() == 0 && monitor.func_145838_q() == ThutBlocks.lift) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/controlPanel_1.png");
                renderengine.func_110577_a(this.texture);
            }
            Tessellator t = Tessellator.func_178181_a();
            t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GL11.glTranslated((double)0.0, (double)1.0005, (double)0.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            t.func_178180_c().func_181662_b(1.0, 0.0, 1.0).func_181673_a(0.0, 0.0).func_181675_d();
            t.func_178180_c().func_181662_b(1.0, 0.0, 0.0).func_181673_a(0.0, 1.0).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(1.0, 1.0).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 1.0).func_181673_a(1.0, 0.0).func_181675_d();
            t.func_78381_a();
            GL11.glPopMatrix();
            this.drawLiftGui(monitor);
            GL11.glPopMatrix();
            if (light) {
                GL11.glEnable((int)2896);
            }
            if (!blend) {
                GL11.glDisable((int)3042);
            }
            GL11.glBlendFunc((int)src, (int)dst);
            if (oldLight[0] != -1.0f && oldLight[1] != -1.0f) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldLight[0], (float)oldLight[1]);
            }
            return;
        }
        for (int i = 0; i < 6; ++i) {
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            if (!monitor.isSideOn(dir)) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            if (dir == EnumFacing.EAST) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == EnumFacing.SOUTH) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == EnumFacing.WEST) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/controlPanel_1.png");
                renderengine.func_110577_a(this.texture);
            }
            Tessellator t = Tessellator.func_178181_a();
            t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-5.0E-4);
            t.func_178180_c().func_181662_b(1.0, 1.0, 0.0).func_181673_a(0.0, 0.0).func_181675_d();
            t.func_178180_c().func_181662_b(1.0, 0.0, 0.0).func_181673_a(0.0, 1.0).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181673_a(1.0, 1.0).func_181675_d();
            t.func_178180_c().func_181662_b(0.0, 1.0, 0.0).func_181673_a(1.0, 0.0).func_181675_d();
            t.func_78381_a();
            GL11.glPopMatrix();
            this.drawFloorNumbers(monitor.getSidePage(dir));
            if (monitor.lift != null) {
                this.drawOverLay(monitor, monitor.floor, 0, dir);
                this.drawOverLay(monitor, monitor.lift.getDestinationFloor(), 1, dir);
                this.drawOverLay(monitor, monitor.lift.getCurrentFloor(), 2, dir);
            }
            if (monitor.lift != null) {
                for (int j = monitor.getSidePage(dir) * 16; j < 16 + monitor.getSidePage(dir) * 16; ++j) {
                    if (monitor.lift.floors[j] >= 0) continue;
                    this.drawOverLay(monitor, j + 1, 3, dir);
                }
            }
            GL11.glPopMatrix();
        }
        if (light) {
            GL11.glEnable((int)2896);
        }
        if (!blend) {
            GL11.glDisable((int)3042);
        }
        GL11.glBlendFunc((int)src, (int)dst);
        if (oldLight[0] != -1.0f || oldLight[1] != -1.0f) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldLight[0], (float)oldLight[1]);
        }
    }

    public static class ModelLiftController
    extends ModelBase {
        private ModelRenderer _main;

        public ModelLiftController() {
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this._main = new ModelRenderer((ModelBase)this, 0, 0);
            this._main.func_78789_a(0.0f, 0.0f, 0.0f, 1, 1, 1);
            this._main.func_78793_a(0.0f, 0.0f, 0.0f);
            this._main.func_78787_b(64, 32);
            this._main.field_78809_i = true;
            this.setRotation(this._main, 0.0f, 0.0f, 0.0f);
        }

        public void render(TileEntity te) {
            this._main.func_78785_a(1.0f);
        }

        private void setRotation(ModelRenderer model, float x, float y, float z) {
            model.field_78795_f = x;
            model.field_78796_g = y;
            model.field_78808_h = z;
        }
    }
}

