/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.door;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.tech.common.blocks.door.BlockDoor;

public class TileEntityDoor
extends TileEntity
implements ITickable {
    public boolean isCore = true;
    public boolean madeDoor = false;
    public IBlockState state;
    double width = -1.0;
    double height = -1.0;
    public Vector3f shift = new Vector3f();
    EnumFacing normal;
    public TileEntityDoor core = null;
    private BlockPos corePos = null;
    Set<TileEntityDoor> parts = Sets.newHashSet();
    AxisAlignedBB box = null;

    private void addPart(TileEntityDoor part) {
        part.madeDoor = true;
        this.parts.add(part);
    }

    public void createDoor() {
        if (!this.madeDoor) {
            for (int k = -1; k <= 1; ++k) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = 0; j <= 2; ++j) {
                        IBlockState state;
                        BlockPos pos = new BlockPos(i + this.func_174877_v().func_177958_n(), j + this.func_174877_v().func_177956_o(), k + this.func_174877_v().func_177952_p());
                        if (pos.equals((Object)this.func_174877_v()) || (state = this.field_145850_b.func_180495_p(pos)) == null || !state.func_177230_c().func_149688_o().func_76220_a()) continue;
                        this.field_145850_b.func_175656_a(pos, BlockDoor.instance.func_176223_P());
                        TileEntityDoor tile = (TileEntityDoor)this.field_145850_b.func_175625_s(pos);
                        tile.state = state;
                        tile.madeDoor = true;
                        tile.setCore(this);
                    }
                }
            }
        }
        this.madeDoor = true;
    }

    private AxisAlignedBB getBounds() {
        AxisAlignedBB ret = this.box;
        if (this.state != null && this.state.func_177230_c() != BlockDoor.instance) {
            ret = this.box = this.state.func_177230_c().func_180640_a(this.field_145850_b, this.func_174877_v(), this.state);
        } else if (ret == null) {
            this.box = ret = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        }
        return ret;
    }

    public AxisAlignedBB getBounds(float partialTick) {
        AxisAlignedBB ret = this.box;
        if (this.core != null && this.core != this) {
            return this.core.getBounds(partialTick);
        }
        if (this.state != null && this.state.func_177230_c() != BlockDoor.instance) {
            this.box = this.state.func_177230_c().func_180640_a(this.field_145850_b, this.func_174877_v(), this.state);
            Vector3f shift = this.getShiftForPart(this, partialTick);
            for (TileEntityDoor door : this.parts) {
                this.box = this.box.func_111270_a(door.getBounds());
            }
            ret = this.box.func_72317_d((double)shift.x, (double)shift.y, (double)shift.z);
        } else if (ret == null) {
            ret = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
            for (TileEntityDoor door : this.parts) {
                ret = ret.func_111270_a(door.getBounds());
            }
            this.box = ret;
        }
        return ret;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 3, nbttagcompound);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    public Vector3f getShiftForPart(TileEntityDoor part, float partialTick) {
        if (this.core != null && this.core != this) {
            return this.core.getShiftForPart(part, partialTick);
        }
        if (this.madeDoor) {
            float num;
            this.shift.x = num = 3.0f * MathHelper.func_76134_b((float)(((float)this.field_145850_b.func_82737_E() + partialTick) / 30.0f));
        }
        return this.shift;
    }

    public double getWidth() {
        return this.width;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbttagcompound = pkt.func_148857_g();
        this.func_145839_a(nbttagcompound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("corex")) {
            this.corePos = new BlockPos(compound.func_74762_e("corex"), compound.func_74762_e("corey"), compound.func_74762_e("corez"));
        }
        if (compound.func_74764_b("state")) {
            NBTTagCompound tag = compound.func_74775_l("state");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            this.state = block.func_176203_a(stack.func_77952_i());
        }
        this.madeDoor = compound.func_74767_n("made");
    }

    public void setCore(TileEntityDoor core) {
        if (core == this) {
            core = null;
        }
        this.core = core;
        boolean bl = this.isCore = core == null;
        if (core != null) {
            core.addPart(this);
        }
    }

    public void func_73660_a() {
        if (this.corePos != null && this.core == null) {
            if (this.field_145850_b.func_175625_s(this.corePos) instanceof TileEntityDoor) {
                this.core = (TileEntityDoor)this.field_145850_b.func_175625_s(this.corePos);
                this.setCore(this.core);
            }
            this.corePos = null;
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.core != null) {
            compound.func_74768_a("corex", this.core.field_174879_c.func_177958_n());
            compound.func_74768_a("corey", this.core.field_174879_c.func_177956_o());
            compound.func_74768_a("corez", this.core.field_174879_c.func_177952_p());
        }
        if (this.state != null) {
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack stack = new ItemStack(this.state.func_177230_c(), 1, this.state.func_177230_c().func_176201_c(this.state));
            stack.func_77955_b(tag);
            compound.func_74782_a("state", (NBTBase)tag);
        }
        compound.func_74757_a("made", this.madeDoor);
    }
}

