/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.ThutBlocks;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.items.ItemLinker;

public class BlockLift
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177708_a((String)"variant", EnumType.class, (Predicate)new Predicate<EnumType>(){

        public boolean apply(EnumType type) {
            return type.getMetadata() < 4;
        }
    });
    public static final PropertyBool CALLED = PropertyBool.func_177716_a((String)"called");
    public static final PropertyBool CURRENT = PropertyBool.func_177716_a((String)"current");
    public int size = 5;

    public BlockLift() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149663_c("lift");
        this.func_149675_a(true);
        this.func_149647_a((CreativeTabs)TechCore.tabThut);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.CONTROLLER)).func_177226_a((IProperty)CALLED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CURRENT, (Comparable)Boolean.valueOf(false)));
        ThutBlocks.lift = this;
    }

    public boolean func_149744_f() {
        return true;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT, CALLED, CURRENT});
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityLiftAccess();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 1) {
            return new TileEntityLiftAccess();
        }
        return new TileEntityLiftAccess();
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(VARIANT) == EnumType.LIFT ? 0 : 1;
    }

    public EnumFacing getFacingfromEntity(EntityLiving e) {
        EnumFacing side = null;
        double angle = e.field_70177_z % 360.0f;
        if (angle > 315.0 || angle <= 45.0) {
            return EnumFacing.SOUTH;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return EnumFacing.WEST;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return EnumFacing.NORTH;
        }
        if (angle > 225.0 && angle <= 315.0) {
            return EnumFacing.EAST;
        }
        return side;
    }

    public int func_176201_c(IBlockState state) {
        int ret = ((EnumType)((Object)state.func_177229_b(VARIANT))).meta;
        if (((Boolean)state.func_177229_b((IProperty)CALLED)).booleanValue()) {
            ret += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)CURRENT)).booleanValue()) {
            ret += 8;
        }
        return ret;
    }

    public IBlockState func_176203_a(int meta) {
        int typeMeta = meta & 3;
        boolean called = (meta / 4 & 1) > 0;
        boolean current = (meta / 8 & 1) > 0;
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(typeMeta))).func_177226_a((IProperty)CALLED, (Comparable)Boolean.valueOf(called)).func_177226_a((IProperty)CURRENT, (Comparable)Boolean.valueOf(current));
    }

    public int func_176211_b(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (int j = 0; j < 2; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)CURRENT) != false ? 15 : 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 1;
    }

    public boolean func_180639_a(World worldObj, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(VARIANT) == EnumType.LIFT) {
            TileEntityLiftAccess te = (TileEntityLiftAccess)worldObj.func_175625_s(pos);
            ItemStack[][][] stacks = EntityLift.checkBlocks(worldObj, te, pos);
            if (stacks != null && !worldObj.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemLinker) {
                EntityLift.removeBlocks(worldObj, te, pos);
                EntityLift lift = new EntityLift(worldObj, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                lift.blocks = stacks;
                lift.boundMax = te.boundMax.copy();
                lift.boundMin = te.boundMin.copy();
                lift.owner = player.func_110124_au();
                worldObj.func_72838_d((Entity)lift);
                String message = StatCollector.func_74838_a((String)"msg.lift.create");
                player.func_145747_a((IChatComponent)new ChatComponentText(message));
                return true;
            }
            if (te != null && side == EnumFacing.UP) {
                te.doButtonClick((EntityLivingBase)player, side, hitX, hitY, hitZ);
                worldObj.func_175689_h(pos);
                return true;
            }
            return false;
        }
        if (state.func_177229_b(VARIANT) == EnumType.CONTROLLER) {
            TileEntityLiftAccess te = (TileEntityLiftAccess)worldObj.func_175625_s(pos);
            if (te != null && (!te.isSideOn(side) || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y)) {
                if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b() instanceof ItemLinker || player.func_70694_bm().func_77973_b() == Items.field_151055_y)) {
                    if (!worldObj.field_72995_K) {
                        te.setSide(side, !te.isSideOn(side));
                        te.func_70296_d();
                    }
                    return true;
                }
            } else {
                if (te != null && te.isSideOn(side)) {
                    if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b() instanceof ItemLinker)) {
                        if (!worldObj.field_72995_K) {
                            te.setSidePage(side, (te.getSidePage(side) + 1) % 4);
                        }
                        worldObj.func_175689_h(pos);
                        return true;
                    }
                    if (te != null) {
                        te.doButtonClick((EntityLivingBase)player, side, hitX, hitY, hitZ);
                    }
                    return true;
                }
                if (te == null) {
                    new Exception().printStackTrace();
                }
            }
        }
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLiftAccess) {
            // empty if block
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        LIFT(0, "lift"),
        CONTROLLER(1, "liftcontroller");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        private EnumType(int meta, String name) {
            this(meta, name, name);
        }

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] var0 = EnumType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

