/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.ThutBlocks;
import thut.api.maths.Vector3;
import thut.tech.common.blocks.lift.BlockLift;
import thut.tech.common.entity.EntityLift;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")
public class TileEntityLiftAccess
extends TileEntity
implements ITickable,
SimpleComponent {
    public int power = 0;
    public int prevPower = 1;
    public EntityLift lift;
    boolean listNull = false;
    List<Entity> list = new ArrayList<Entity>();
    Vector3 here;
    public Vector3 root = Vector3.getNewVector();
    public TileEntityLiftAccess rootNode;
    public Vector<TileEntityLiftAccess> connected = new Vector();
    EnumFacing sourceSide;
    public double energy;
    boolean isLift = false;
    public Block blockID = Blocks.field_150350_a;
    public Vector3 boundMin = Vector3.getNewVector();
    public Vector3 boundMax = Vector3.getNewVector();
    boolean loaded = false;
    public int floor = 0;
    public int calledYValue = -1;
    public int calledFloor = 0;
    public int currentFloor = 0;
    UUID liftID = null;
    UUID empty = new UUID(0L, 0L);
    private byte[] sides = new byte[6];
    private byte[] sidePages = new byte[6];
    int tries = 0;
    public boolean toClear = false;
    public boolean first = true;
    public boolean read = false;
    public boolean redstone = true;
    public boolean powered = false;

    public void buttonPress(int button) {
        if (button != 0 && button <= 64 && this.lift != null && this.lift.floors[button - 1] > 0) {
            if (button != this.floor && this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            this.lift.call(button);
        }
    }

    @Callback(doc="function(floor:number) -- Calls the Lift to the specified Floor")
    @Optional.Method(modid="OpenComputers")
    public Object[] callFloor(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.call(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="function(yValue:number) -- Calls the Lift to the specified Y level")
    @Optional.Method(modid="OpenComputers")
    public Object[] callYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.callYValue(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    public void callYValue(int yValue) {
        if (this.lift != null) {
            this.lift.callYValue(yValue);
        }
    }

    public void checkPower() {
    }

    public boolean checkSides() {
        List check = this.field_145850_b.func_72872_a(EntityLift.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - 1.0, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 - 1.0, (double)this.func_174877_v().func_177958_n() + 0.5 + 1.0, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5 + 1.0));
        if (check != null && check.size() > 0) {
            this.lift = (EntityLift)((Object)check.get(0));
            this.liftID = this.lift.id;
        }
        return check != null && !check.isEmpty();
    }

    public void clearConnections() {
    }

    public String connectionInfo() {
        String ret = "";
        return ret;
    }

    public void doButtonClick(EntityLivingBase clicker, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.liftID != null && !this.liftID.equals(this.empty) && this.lift != EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b.field_72995_K)) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b.field_72995_K);
        }
        int button = this.getButtonFromClick(side, hitX, hitY, hitZ);
        if (this.isLift && this.blockID == ThutBlocks.lift) {
            if (button == 2) {
                this.boundMin.x = Math.max(-2.0, this.boundMin.x - 1.0);
            } else if (button == 3) {
                this.boundMin.x = Math.min(0.0, this.boundMin.x + 1.0);
            } else if (button == 6) {
                this.boundMin.z = Math.max(-2.0, this.boundMin.z - 1.0);
            } else if (button == 7) {
                this.boundMin.z = Math.min(0.0, this.boundMin.z + 1.0);
            } else if (button == 10) {
                this.boundMax.x = Math.max(0.0, this.boundMax.x - 1.0);
            } else if (button == 11) {
                this.boundMax.x = Math.min(2.0, this.boundMax.x + 1.0);
            } else if (button == 14) {
                this.boundMax.z = Math.max(0.0, this.boundMax.z - 1.0);
            } else if (button == 15) {
                this.boundMax.z = Math.min(2.0, this.boundMax.z + 1.0);
            } else if (button == 4 || button == 8 || button == 12 || button == 16) {
                this.boundMax.y = Math.max(0.0, this.boundMax.y - 1.0);
            } else if (button == 1 || button == 5 || button == 9 || button == 13) {
                this.boundMax.y = Math.min(5.0, this.boundMax.y + 1.0);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.lift != null && this.isSideOn(side)) {
            this.buttonPress(button);
            this.calledFloor = this.lift.getDestinationFloor();
        }
    }

    public int getButtonFromClick(EnumFacing side, float hitX, float hitY, float hitZ) {
        int ret = 0;
        int page = this.getSidePage(side);
        switch (side.func_176745_a()) {
            case 0: {
                return 0 + 16 * page;
            }
            case 1: {
                ret = 1 + (int)((1.0f - hitX) * 4.0f % 4.0f) + 4 * (int)((1.0f - hitZ) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 2: {
                ret = 1 + (int)((1.0f - hitX) * 4.0f % 4.0f) + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 3: {
                ret = 1 + (int)(hitX * 4.0f % 4.0f) + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 4: {
                ret = 1 + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f) + (int)(hitZ * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 5: {
                ret = 1 + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f) + (int)((1.0f - hitZ) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
        }
        return 0 + 16 * page;
    }

    public String getComponentName() {
        return "lift";
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 3, nbttagcompound);
    }

    public double getEnergy() {
        return 0.0;
    }

    @Callback(doc="returns the Floor assigned to the Controller")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFloor(Context context, Arguments args) {
        return new Object[]{this.floor};
    }

    @Callback(doc="function(floor:number) -- returns the y value of the specified floor")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFloorYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            int floor = args.checkInteger(0);
            if (floor > 0 && floor <= 64) {
                int value = this.lift.floors[floor - 1];
                if (value == -1) {
                    throw new Exception("floor " + floor + " is not assigned");
                }
                return new Object[]{value};
            }
            throw new Exception("floor out of bounds");
        }
        throw new Exception("no connected lift");
    }

    public TileEntityLiftAccess getRoot() {
        TileEntityLiftAccess te;
        if (this.here == null || this.here.isEmpty()) {
            this.here = Vector3.getNewVector().set((Object)this);
        }
        if (this.rootNode != null) {
            return this.rootNode;
        }
        Block b = this.here.getBlock((IBlockAccess)this.field_145850_b, EnumFacing.DOWN);
        if (b == this.blockID && (te = (TileEntityLiftAccess)this.here.getTileEntity((IBlockAccess)this.field_145850_b, EnumFacing.DOWN)) != null && te != this) {
            this.rootNode = te.getRoot();
            return this.rootNode;
        }
        this.rootNode = this;
        return this.rootNode;
    }

    public int getSidePage(EnumFacing side) {
        return this.sidePages[side.func_176745_a()];
    }

    @Callback(doc="returns the current Y value of the lift.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            return new Object[]{(int)this.lift.field_70163_u};
        }
        throw new Exception("no connected lift");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.clearConnections();
    }

    public boolean isSideOn(EnumFacing side) {
        byte state = 1;
        byte byte0 = this.sides[side.func_176745_a()];
        return (byte0 & state) != 0;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbttagcompound = pkt.func_148857_g();
        this.func_145839_a(nbttagcompound);
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.blockID = Block.func_149684_b((String)par1.func_74779_i("block id"));
        this.floor = par1.func_74762_e("floor");
        this.liftID = new UUID(par1.func_74763_f("idMost"), par1.func_74763_f("idLess"));
        this.root = Vector3.getNewVector();
        this.root = Vector3.readFromNBT((NBTTagCompound)par1, (String)"root");
        this.sides = par1.func_74770_j("sides");
        if (this.sides.length != 6) {
            this.sides = new byte[6];
        }
        this.sidePages = par1.func_74770_j("sidePages");
        if (this.sidePages.length != 6) {
            this.sidePages = new byte[6];
        }
        if (par1.func_74764_b("corners")) {
            int[] read = par1.func_74759_k("corners");
            int xMin = read[0];
            int zMin = read[1];
            int xMax = read[2];
            int zMax = read[3];
            this.boundMin.x = xMin;
            this.boundMin.z = zMin;
            this.boundMax.x = xMax;
            this.boundMax.z = zMax;
        }
        if (par1.func_74764_b("bounds")) {
            this.boundMin = Vector3.readFromNBT((NBTTagCompound)par1.func_74775_l("bounds"), (String)"min");
            this.boundMax = Vector3.readFromNBT((NBTTagCompound)par1.func_74775_l("bounds"), (String)"max");
        }
    }

    public void setEnergy(double energy) {
    }

    @Callback(doc="function(floor:number) -- Sets the floor assosiated to the Controller")
    @Optional.Method(modid="OpenComputers")
    public Object[] setFloor(Context context, Arguments args) {
        this.floor = args.checkInteger(0);
        return new Object[]{this.floor};
    }

    public void setFloor(int floor) {
        if (this.lift != null && floor <= 64 && floor > 0) {
            this.lift.setFoor(this.getRoot(), floor);
            this.getRoot().floor = floor;
            this.getRoot().func_70296_d();
        }
    }

    public void setLift(EntityLift lift) {
        this.lift = lift;
    }

    public void setRoot(TileEntityLiftAccess root) {
        this.rootNode = root;
    }

    public void setSide(EnumFacing side, boolean flag) {
        byte state = 1;
        byte byte0 = this.sides[side.func_176745_a()];
        if (side.func_176745_a() < 2) {
            return;
        }
        this.sides[side.func_176745_a()] = flag ? (byte)(byte0 | state) : (byte)(byte0 & -state - 1);
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setSidePage(EnumFacing side, int page) {
        this.sidePages[side.func_176745_a()] = (byte)page;
    }

    public void func_73660_a() {
        if (this.first) {
            this.blockID = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            this.isLift = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockLift.VARIANT) == BlockLift.EnumType.LIFT;
            this.here = Vector3.getNewVector().set((Object)this);
            this.first = false;
        }
        if (this.isLift) {
            return;
        }
        if (this.lift == null || this.lift.field_70128_L) {
            this.calledYValue = -1;
            this.calledFloor = 0;
            this.currentFloor = 0;
        }
        if (this.lift != null && !this.field_145850_b.field_72995_K) {
            IBlockState state;
            boolean old;
            boolean check = (int)this.lift.field_70163_u + 2 == this.func_174877_v().func_177956_o() && this.lift.field_70181_x == 0.0;
            if (check != (old = ((Boolean)(state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177229_b((IProperty)BlockLift.CURRENT)).booleanValue())) {
                state = state.func_177226_a((IProperty)BlockLift.CURRENT, (Comparable)Boolean.valueOf(check));
                this.field_145850_b.func_175656_a(this.func_174877_v(), state);
            }
            if (this.lift.field_70181_x == 0.0 || this.lift.getDestinationFloor() == this.floor) {
                old = (Boolean)state.func_177229_b((IProperty)BlockLift.CALLED);
                boolean bl = check = this.lift.getDestinationFloor() == this.floor;
                if (check != old) {
                    state = state.func_177226_a((IProperty)BlockLift.CALLED, (Comparable)Boolean.valueOf(check));
                    this.field_145850_b.func_175656_a(this.func_174877_v(), state);
                }
            }
        }
        if (this.lift != null && this.floor > 0) {
            if ((int)this.lift.field_70163_u == this.func_174877_v().func_177956_o() - 2) {
                this.lift.setCurrentFloor(this.floor);
            } else if (this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            if (this.lift.floors[this.floor - 1] < 0) {
                this.lift.setFoor(this, this.floor);
            }
            this.calledFloor = this.lift.getDestinationFloor();
            this.currentFloor = this.lift.getCurrentFloor();
        }
        if (this.liftID != null && !this.liftID.equals(this.empty) && (this.lift == null || this.lift.field_70128_L)) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b.field_72995_K);
            if (this.lift == null) {
                return;
            }
        }
        if (this.getRoot().floor != this.floor) {
            this.floor = this.getRoot().floor;
            this.lift = this.getRoot().lift;
            this.func_70296_d();
        }
        if (this.floor > 0 && (this.lift == null || this.lift.field_70128_L)) {
            this.lift = null;
            this.floor = 0;
        }
        if (this.blockID == ThutBlocks.lift && this.lift == null) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity t = this.here.getTileEntity((IBlockAccess)this.field_145850_b, side);
                Block b = this.here.getBlock((IBlockAccess)this.field_145850_b, side);
                if (b != this.blockID || !(t instanceof TileEntityLiftAccess)) continue;
                TileEntityLiftAccess te = (TileEntityLiftAccess)t;
                if (te.lift == null) continue;
                this.lift = te.lift;
                this.floor = te.floor;
                this.func_70296_d();
                break;
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        if (this.blockID == null) {
            this.blockID = ThutBlocks.liftRail;
        }
        if (this.blockID == null) {
            this.blockID = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        }
        par1.func_74778_a("block id", this.blockID.func_149732_F());
        par1.func_74768_a("floor", this.floor);
        par1.func_74773_a("sides", this.sides);
        par1.func_74773_a("sidePages", this.sidePages);
        if (this.root != null) {
            this.root.writeToNBT(par1, "root");
        }
        if (this.lift != null) {
            this.liftID = this.lift.id;
        }
        if (this.liftID != null) {
            par1.func_74772_a("idLess", this.liftID.getLeastSignificantBits());
            par1.func_74772_a("idMost", this.liftID.getMostSignificantBits());
        }
        NBTTagCompound vector = new NBTTagCompound();
        this.boundMin.writeToNBT(vector, "min");
        this.boundMax.writeToNBT(vector, "max");
        par1.func_74782_a("bounds", (NBTBase)vector);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }
}

