/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thut.api.ThutBlocks;
import thut.api.entity.IMultibox;
import thut.api.maths.Matrix3;
import thut.api.maths.Vector3;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.handlers.ConfigHandler;
import thut.tech.common.items.ItemLinker;

public class EntityLift
extends EntityLivingBase
implements IEntityAdditionalSpawnData,
IMultibox {
    static final int DESTINATIONFLOORDW = 24;
    static final int DESTINATIONYDW = 25;
    static final int CURRENTFLOORDW = 26;
    public static int ACCELERATIONTICKS = 20;
    private static HashMap<UUID, EntityLift> lifts = new HashMap();
    private static HashMap<UUID, EntityLift> lifts2 = new HashMap();
    public Vector3 boundMin = Vector3.getNewVector();
    public Vector3 boundMax = Vector3.getNewVector();
    public double speedUp = ConfigHandler.LiftSpeedUp;
    public double speedDown = -ConfigHandler.LiftSpeedDown;
    public double acceleration = 0.05;
    public boolean up = true;
    public boolean toMoveY = false;
    public boolean moved = false;
    public boolean axis = true;
    public boolean hasPassenger = false;
    int n = 0;
    int passengertime = 10;
    boolean first = true;
    Random r = new Random();
    public UUID id = UUID.randomUUID();
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    public boolean called = false;
    TileEntityLiftAccess current;
    Matrix3 mainBox = new Matrix3();
    Matrix3 tempBox = new Matrix3();
    public HashMap<String, Matrix3> boxes = new HashMap();
    public List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    public HashMap<String, Vector3> offsets = new HashMap();
    public int[] floors = new int[64];
    Matrix3 base = new Matrix3();
    Matrix3 top = new Matrix3();
    Matrix3 wall1 = new Matrix3();
    public ItemStack[][][] blocks = null;
    private ItemStack[] inventory = new ItemStack[1];

    public static void clear() {
        lifts2.clear();
        lifts.clear();
    }

    public static EntityLift getLiftFromUUID(UUID uuid, boolean client) {
        if (client) {
            return lifts2.get(uuid);
        }
        return lifts.get(uuid);
    }

    public static void removeBlocks(World worldObj, TileEntityLiftAccess te, BlockPos pos) {
        int xMin = te.boundMin.intX();
        int zMin = te.boundMin.intZ();
        int xMax = te.boundMax.intX();
        int zMax = te.boundMax.intZ();
        int yMin = te.boundMin.intY();
        int yMax = te.boundMax.intY();
        Vector3 loc = Vector3.getNewVector();
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = zMin; j <= zMax; ++j) {
                for (int k = yMin; k <= yMax; ++k) {
                    worldObj.func_175698_g(loc.set((Object)pos).add((double)i, (double)k, (double)j).getPos());
                }
            }
        }
    }

    public static ItemStack[][][] checkBlocks(World worldObj, TileEntityLiftAccess te, BlockPos pos) {
        int xMin = te.boundMin.intX();
        int zMin = te.boundMin.intZ();
        int xMax = te.boundMax.intX();
        int zMax = te.boundMax.intZ();
        int yMin = te.boundMin.intY();
        int yMax = te.boundMax.intY();
        ItemStack[][][] ret = new ItemStack[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
        Vector3 loc = Vector3.getNewVector().set((Object)pos);
        for (int i = xMin; i <= xMax; ++i) {
            for (int k = yMin; k <= yMax; ++k) {
                for (int j = zMin; j <= zMax; ++j) {
                    if (i != 0 || j != 0 || k != 0) {
                        IBlockState state = loc.set((Object)pos).addTo((double)i, (double)k, (double)j).getBlockState((IBlockAccess)worldObj);
                        Block b = state.func_177230_c();
                        if (!(b instanceof ITileEntityProvider)) {
                            ret[i - xMin][k - yMin][j - zMin] = new ItemStack(b, 1, b.func_176201_c(state));
                            continue;
                        }
                        if (k != 0 && state.func_177230_c().isAir((IBlockAccess)worldObj, pos)) continue;
                        return null;
                    }
                    ret[i - xMin][k - yMin][j - zMin] = new ItemStack(ThutBlocks.lift);
                }
            }
        }
        return ret;
    }

    public EntityLift(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = -1;
        }
    }

    public EntityLift(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r.setSeed(100L);
        lifts.put(this.id, this);
    }

    public void accelerate() {
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = !this.toMoveY ? (this.field_70181_x *= 0.5) : (this.up ? Math.min(this.speedUp, this.field_70181_x + this.acceleration * this.speedUp) : Math.max(this.speedDown, this.field_70181_x + this.acceleration * this.speedDown));
    }

    public void func_70108_f(Entity entity) {
        Vector3 v = Vector3.getNewVector();
        Vector3 v1 = Vector3.getNewVector();
        this.blockBoxes.clear();
        int sizeX = this.blocks.length;
        int sizeY = this.blocks[0].length;
        int sizeZ = this.blocks[0][0].length;
        HashSet topY = Sets.newHashSet();
        for (int i = 0; i < sizeX; ++i) {
            for (int k = 0; k < sizeY; ++k) {
                for (int j = 0; j < sizeZ; ++j) {
                    ItemStack stack = this.blocks[i][k][j];
                    if (stack == null || stack.func_77973_b() == null) continue;
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    AxisAlignedBB box = Matrix3.getAABB((double)(this.field_70165_t + block.func_149704_x() - 0.5 + this.boundMin.x + (double)i), (double)(this.field_70163_u + block.func_149665_z() + (double)k), (double)(this.field_70161_v + block.func_149706_B() - 0.5 + this.boundMin.z + (double)j), (double)(this.field_70165_t + block.func_149753_y() + 0.5 + this.boundMin.x + (double)i), (double)(this.field_70163_u + block.func_149669_A() + (double)k), (double)(this.field_70161_v + block.func_149693_C() + 0.5 + this.boundMin.z + (double)j));
                    this.blockBoxes.add(box);
                    topY.add(box.field_72337_e);
                }
            }
        }
        v.setToVelocity(entity).subtractFrom(v1.setToVelocity((Entity)this));
        v1.clear();
        Matrix3.doCollision(this.blockBoxes, (AxisAlignedBB)entity.func_174813_aQ(), (Entity)entity, (double)0.0, (Vector3)v, (Vector3)v1);
        for (Double d : topY) {
            if (!(entity.field_70163_u >= d) || !(entity.field_70163_u + entity.field_70181_x <= d) || !(this.field_70181_x <= 0.0)) continue;
            double diff = entity.field_70163_u + entity.field_70181_x - (d + this.field_70181_x);
            double check = Math.max(0.5, Math.abs(entity.field_70181_x + this.field_70181_x));
            if (!(diff > 0.0) && !(diff < -0.5) && !(Math.abs(diff) > check)) continue;
            entity.field_70181_x = 0.0;
        }
        boolean collidedY = false;
        if (!v1.isEmpty()) {
            if (v1.y >= 0.0) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
            } else if (v1.y < 0.0) {
                boolean below;
                boolean bl = below = entity.field_70163_u + (double)entity.field_70131_O - (entity.field_70181_x + this.field_70181_x) < this.field_70163_u;
                if (below) {
                    v1.y = 0.0;
                }
            }
            if (v1.x != 0.0) {
                entity.field_70159_w = 0.0;
            }
            if (v1.y != 0.0) {
                entity.field_70181_x = this.field_70181_x;
            }
            if (v1.z != 0.0) {
                entity.field_70179_y = 0.0;
            }
            if (v1.y != 0.0) {
                collidedY = true;
            }
            v1.addTo(v.set((Object)entity));
            v1.moveEntity(entity);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (Math.abs(player.field_70181_x) < 0.1 && !player.field_71075_bZ.field_75100_b) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                if (collidedY) {
                    entityplayer.field_71135_a.field_147365_f = 0;
                }
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, int damage) {
        return damage > 15;
    }

    public Matrix3 bounds(Vector3 target) {
        int xMin = this.boundMin.intX();
        int zMin = this.boundMin.intZ();
        int xMax = this.boundMax.intX();
        int zMax = this.boundMax.intZ();
        this.tempBox.boxMin().set((double)xMin, 0.0, (double)zMin);
        this.tempBox.boxMax().set((double)xMax, 1.0, (double)zMax);
        return this.tempBox;
    }

    public void call(int floor) {
        if (floor == 0 || floor > 64) {
            return;
        }
        if (this.floors[floor - 1] > 0) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean checkBlocks(double dir) {
        boolean ret = true;
        Vector3 thisloc = Vector3.getNewVector().set((Object)this).addTo(0.0, dir, 0.0);
        if (this.called) {
            if (dir > 0.0 && thisloc.y > (double)this.getDestY()) {
                return false;
            }
            if (dir < 0.0 && thisloc.y < (double)this.getDestY()) {
                return false;
            }
        }
        int xMin = this.boundMin.intX();
        int zMin = this.boundMin.intZ();
        int xMax = this.boundMax.intX();
        int zMax = this.boundMax.intZ();
        Vector3 v = Vector3.getNewVector();
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = zMin; j <= zMax; ++j) {
                ret = ret && v.set(thisloc).addTo((double)i, 0.0, (double)j).clearOfBlocks((IBlockAccess)this.field_70170_p);
            }
        }
        return ret;
    }

    public void checkCollision() {
        int zMax;
        int xMax;
        int zMin;
        int xMin = this.boundMin.intX();
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t + (double)(xMin - 1), this.field_70163_u, this.field_70161_v + (double)((zMin = this.boundMin.intZ()) - 1), this.field_70165_t + (double)(xMax = this.boundMax.intX()) + 1.0, this.field_70163_u + 64.0, this.field_70161_v + (double)(zMax = this.boundMax.intZ()) + 1.0));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.field_70153_n != null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    public void clearLiquids() {
    }

    private boolean consumePower() {
        boolean power = false;
        double energyCost = 0.0;
        if (energyCost <= 0.0) {
            return true;
        }
        if (!power) {
            this.toMoveY = false;
        }
        return power;
    }

    public void doMotion() {
        if (this.up) {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x >= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedUp / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedUp / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            this.current = null;
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        } else {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x <= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedDown / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedDown / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            this.current = null;
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        }
        this.toMoveY = false;
        this.moved = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)-1);
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    public HashMap<String, Matrix3> getBoxes() {
        return this.boxes;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    public ItemStack func_82169_q(int slotIn) {
        return null;
    }

    public int getCurrentFloor() {
        return this.field_70180_af.func_75679_c(26);
    }

    public int getDestinationFloor() {
        return this.field_70180_af.func_75679_c(24);
    }

    public int getDestY() {
        return this.field_70180_af.func_75679_c(25);
    }

    public ItemStack func_71124_b(int var1) {
        return this.func_70694_bm();
    }

    public ItemStack func_70694_bm() {
        return this.func_70035_c()[0];
    }

    public ItemStack[] func_70035_c() {
        return this.inventory;
    }

    public HashMap<String, Vector3> getOffsets() {
        return this.offsets;
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemStack item = player.func_70694_bm();
        if (player.func_70093_af() && item != null && item.func_77973_b() instanceof ItemLinker && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d)) {
            if (item.func_77978_p() == null) {
                item.func_77982_d(new NBTTagCompound());
            }
            item.func_77978_p().func_74778_a("lift", this.id.toString());
            String message = StatCollector.func_74837_a((String)"msg.liftSet.name", (Object[])new Object[0]);
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(message));
            }
            return true;
        }
        if (item != null && item.func_77973_b() instanceof ItemLinker && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d) && !this.field_70170_p.field_72995_K && this.owner != null) {
            EntityPlayer ownerentity = this.field_70170_p.func_152378_a(this.owner);
            String message = StatCollector.func_74837_a((String)"msg.lift.owner", (Object[])new Object[]{ownerentity.func_70005_c_()});
            player.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
        if (player.func_70093_af() && item != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b().func_77658_a().equals(Items.field_151055_y.func_77658_a())) && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d)) {
            if (!this.field_70170_p.field_72995_K) {
                String message = StatCollector.func_74837_a((String)"msg.lift.killed", (Object[])new Object[0]);
                player.func_145747_a((IChatComponent)new ChatComponentText(message));
                this.func_70106_y();
            }
            return true;
        }
        if (player.func_70093_af() && item != null && Block.func_149634_a((Item)item.func_77973_b()) != null && (this.owner == null || this.owner.equals(player.func_110124_au()))) {
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block.func_149721_r()) {
                ItemStack item2 = item.func_77979_a(1);
                if (this.func_70694_bm() != null && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.func_70694_bm(), 1.0f);
                }
                this.func_70062_b(0, item2);
            }
        } else if (player.func_70093_af() && item == null && (this.owner == null || this.owner.equals(player.func_110124_au()))) {
            if (this.func_70694_bm() != null && !this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.func_70694_bm(), 1.0f);
            }
            this.func_70062_b(0, null);
        }
        return false;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public void func_70071_h_() {
        this.field_70167_r = this.field_70163_u;
        this.clearLiquids();
        if (this.field_70181_x == 0.0) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        if (!this.checkBlocks(0.0)) {
            this.toMoveY = false;
        }
        this.called = this.getDestY() > 0;
        this.toMoveY = this.called;
        this.up = (double)this.getDestY() > this.field_70163_u;
        this.accelerate();
        if (this.toMoveY) {
            this.doMotion();
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        this.checkCollision();
        this.passengertime = this.hasPassenger ? 20 : this.passengertime - 1;
        ++this.n;
    }

    public void passengerCheck() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        this.hasPassenger = list.size() > 0;
    }

    public void readBlocks(NBTTagCompound nbt) {
        if (nbt.func_74764_b("BlocksLength") || nbt.func_74764_b("BlocksLengthX")) {
            int sizeX = nbt.func_74762_e("BlocksLengthX");
            int sizeZ = nbt.func_74762_e("BlocksLengthZ");
            int sizeY = nbt.func_74762_e("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            this.blocks = new ItemStack[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        ItemStack b;
                        int n = -1;
                        if (nbt.func_74764_b("block" + i + "," + j)) {
                            n = nbt.func_74762_e("block" + i + "," + j);
                        } else if (nbt.func_74764_b("block" + i + "," + k + "," + j)) {
                            n = nbt.func_74762_e("block" + i + "," + k + "," + j);
                        }
                        if (n == -1) continue;
                        this.blocks[i][k][j] = b = new ItemStack(Item.func_150899_d((int)n), 1, nbt.func_74762_e("meta" + i + "," + k + "," + j));
                    }
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.axis = nbt.func_74767_n("axis");
        if (nbt.func_74764_b("size")) {
            double size = nbt.func_74769_h("size");
            int xMin = (int)(-size / 2.0);
            int zMin = (int)(-size / 2.0);
            int xMax = (int)(size / 2.0);
            int zMax = (int)(size / 2.0);
            this.boundMin.x = xMin;
            this.boundMin.z = zMin;
            this.boundMax.x = xMax;
            this.boundMax.z = zMax;
        } else if (nbt.func_74764_b("corners")) {
            int[] read = nbt.func_74759_k("corners");
            int xMin = read[0];
            int zMin = read[1];
            int xMax = read[2];
            int zMax = read[3];
            this.boundMin.x = xMin;
            this.boundMin.z = zMin;
            this.boundMax.x = xMax;
            this.boundMax.z = zMax;
        }
        if (nbt.func_74764_b("bounds")) {
            NBTTagCompound bounds = nbt.func_74775_l("bounds");
            this.boundMin = Vector3.readFromNBT((NBTTagCompound)bounds, (String)"min");
            this.boundMax = Vector3.readFromNBT((NBTTagCompound)bounds, (String)"max");
        }
        this.id = new UUID(nbt.func_74763_f("higher"), nbt.func_74763_f("lower"));
        if (nbt.func_74764_b("ownerhigher")) {
            this.owner = new UUID(nbt.func_74763_f("ownerhigher"), nbt.func_74763_f("ownerlower"));
        }
        if (nbt.func_74764_b("replacement")) {
            NBTTagCompound held = nbt.func_74775_l("replacement");
            this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)held);
        }
        this.readList(nbt);
        this.readBlocks(nbt);
    }

    public void readList(NBTTagCompound nbt) {
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = nbt.func_74762_e("floors " + i);
            if (this.floors[i] != 0) continue;
            this.floors[i] = -1;
        }
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag = buff.func_150793_b();
            this.func_70037_a(tag);
            lifts2.put(this.id, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBoxes() {
        Matrix3 m2;
        int xMin = this.boundMin.intX();
        int zMin = this.boundMin.intZ();
        int xMax = this.boundMax.intX();
        int zMax = this.boundMax.intZ();
        this.mainBox.boxMin().set((double)xMin, 0.0, (double)zMin);
        this.mainBox.boxMax().set((double)xMax, 1.0, (double)zMax);
        if (!this.boxes.containsKey("base")) {
            m2 = new Matrix3();
            this.boxes.put("base", m2);
        } else {
            m2 = this.boxes.get("base");
        }
        m2.boxMin().clear();
        m2.boxMax().set((double)(xMax - xMin), 1.0, (double)(zMax - zMin));
        m2.boxRotation().clear();
        this.boxes.put("base", m2);
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_75692_b(26, (Object)currentFloor);
    }

    public void func_70062_b(int var1, ItemStack var2) {
        this.func_70035_c()[0] = var2;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.blocks != null) {
            ItemStack[][][] itemStackArray = this.blocks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[][] barrarr;
                ItemStack[][] itemStackArray2 = barrarr = itemStackArray[i];
                int n2 = itemStackArray2.length;
                for (int j = 0; j < n2; ++j) {
                    ItemStack[] barr;
                    for (ItemStack b : barr = itemStackArray2[j]) {
                        if (b == null) continue;
                        this.func_70099_a(b, 0.5f);
                    }
                }
            }
            if (this.func_70694_bm() != null) {
                this.func_70099_a(this.func_70694_bm(), 1.0f);
            }
        }
        super.func_70106_y();
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_75692_b(24, (Object)destinationFloor);
    }

    public void setDestY(int dest) {
        this.field_70180_af.func_75692_b(25, (Object)dest);
    }

    public void setFoor(TileEntityLiftAccess te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        } else if (te.floor != 0) {
            this.floors[te.floor - 1] = -1;
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        }
    }

    public void setOffsets() {
        Vector3 v2;
        if (!this.offsets.containsKey("base")) {
            v2 = Vector3.getNewVector();
            this.offsets.put("base", v2);
        } else {
            v2 = this.offsets.get("base");
        }
        int xMin = this.boundMin.intX();
        int zMin = this.boundMax.intZ();
        v2.set((double)xMin, 0.0, (double)zMin);
    }

    public void writeBlocks(NBTTagCompound nbt) {
        if (this.blocks != null) {
            nbt.func_74768_a("BlocksLengthX", this.blocks.length);
            nbt.func_74768_a("BlocksLengthY", this.blocks[0].length);
            nbt.func_74768_a("BlocksLengthZ", this.blocks[0][0].length);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        ItemStack b = this.blocks[i][k][j];
                        if (b == null || b.func_77973_b() == null) continue;
                        nbt.func_74768_a("block" + i + "," + k + "," + j, Item.func_150891_b((Item)b.func_77973_b()));
                        nbt.func_74768_a("meta" + i + "," + k + "," + j, b.func_77952_i());
                    }
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("axis", this.axis);
        NBTTagCompound vector = new NBTTagCompound();
        this.boundMin.writeToNBT(vector, "min");
        this.boundMax.writeToNBT(vector, "max");
        nbt.func_74782_a("bounds", (NBTBase)vector);
        nbt.func_74772_a("lower", this.id.getLeastSignificantBits());
        nbt.func_74772_a("higher", this.id.getMostSignificantBits());
        if (this.owner != null) {
            nbt.func_74772_a("ownerlower", this.owner.getLeastSignificantBits());
            nbt.func_74772_a("ownerhigher", this.owner.getMostSignificantBits());
        }
        if (this.inventory[0] != null) {
            NBTTagCompound held = new NBTTagCompound();
            this.inventory[0].func_77955_b(held);
            nbt.func_74782_a("replacement", (NBTBase)held);
        }
        this.writeList(nbt);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeList(NBTTagCompound nbt) {
        for (int i = 0; i < 64; ++i) {
            nbt.func_74768_a("floors " + i, this.floors[i]);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        buff.func_150786_a(tag);
        lifts.put(this.id, this);
    }
}

